/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui;

import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.Const;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalFileHelper;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.StackTraceUtil;

/**
 * A class which implements TreeWillExpandListener interface, The listener
 * that's notified when a tree expands or collapses a node.
 * 
 * @version 1.0
 * @author Jinbo Chen
 */

public class TreeWillExpandListenerAction implements TreeWillExpandListener {
	private JTree tree;
	private ClientPrimaryDataDirectory rootDirectory;

	/**
	 * Constructs a <code>TreeWillExpandListenerAction</code> that is
	 * initialized with <code>tree</code> as the jtree component, and
	 * <code>rootDirectory</code> as the EDAL Directory. If any of the
	 * parameters are <code>null</code> this method will not initialize.
	 * 
	 * @param tree
	 *            the jtree component
	 * @param rootDirectory
	 *            the EDAL Directory
	 */
	public TreeWillExpandListenerAction(JTree tree,
			ClientPrimaryDataDirectory rootDirectory) {
		this.tree = tree;
		this.rootDirectory = rootDirectory;
	}

	@Override
	public void treeWillCollapse(TreeExpansionEvent e)
			throws ExpandVetoException {
		tree.scrollPathToVisible(e.getPath());
	}

	@Override
	public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
		DefaultMutableTreeNode node;
		node = (DefaultMutableTreeNode) (e.getPath().getLastPathComponent());
		EdalNode mynodeobj = (EdalNode) node.getUserObject();

		try {
			node.removeAllChildren();
			ClientPrimaryDataDirectory curdir = (ClientPrimaryDataDirectory) EdalFileHelper
					.getEntity(mynodeobj.getPath(), rootDirectory);
			final Map<String, ClientPrimaryDataEntity> dirnamemap = new HashMap<String, ClientPrimaryDataEntity>();

			if (curdir.isDirectory()) {
				List<ClientPrimaryDataEntity> dirlist = curdir
						.listPrimaryDataEntities();
				List<String> dirnamelist = new ArrayList<String>();

				if (dirlist != null) {
					for (ClientPrimaryDataEntity dir : dirlist) {
						if (dir.isDirectory()
								&& !(dir.getCurrentVersion().isDeleted())) {
							dirnamelist.add(dir.getName());
							dirnamemap.put(dir.getName(), dir);
						}
					}
				}
				Collections.sort(dirnamelist, String.CASE_INSENSITIVE_ORDER);

				for (final String dirname : dirnamelist) {
					DefaultMutableTreeNode child = new EdalMutableTreeModel(
							new EdalNode(dirname,
									((ClientPrimaryDataDirectory) dirnamemap
											.get(dirname)).getPath()));
					node.add(child);

				}
			}
			tree.scrollPathToVisible(e.getPath());
		} catch (RemoteException e1) {
			ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
			JOptionPane.showMessageDialog(
					null,
					"Call remote Edal server function exception:"
							+ e1.getMessage(), Const.EDAL_TITLE_STR,
					JOptionPane.ERROR_MESSAGE);
		} catch (PrimaryDataDirectoryException e1) {
			ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
			JOptionPane.showMessageDialog(null,
					"Call Edal server function exception:" + e1.getMessage(),
					Const.EDAL_TITLE_STR, JOptionPane.ERROR_MESSAGE);
		} catch (NotBoundException e1) {
			ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
			JOptionPane.showMessageDialog(null,
					"Call Edal server function exception:" + e1.getMessage(),
					Const.EDAL_TITLE_STR, JOptionPane.ERROR_MESSAGE);
		}
	}

}
