/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor;

import javax.swing.JOptionPane;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataFormat;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataFormatException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EmptyMetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.StackTraceUtil;
import eu.medsea.util.MimeUtil;

/**
 * <code>DataFormatEditor</code> provides a mechanism for the user to edit
 * DataFormat information.
 * <p>
 * 
 * The following code pops up a DataFormatEditor Dialog
 * 
 * <pre>
 * DataFormatEditor dataformateditor = new DataFormatEditor();
 * dataformateditor.showOpenDialog();
 * </pre>
 * <p>
 * 
 * @version 1.0
 * @author Jinbo Chen
 * 
 */
public class DataFormatEditor extends AbstractMetaDataEditor {
	private String _text;	
	private String _title;

	/**
	 * pop up a Dialog
	 */
	public int showOpenDialog() {
		TextDialog dlg = new TextDialog(this._text,this._title);
		int returnVal = dlg.showOpenDialog();
		if (returnVal == TextDialog.APPROVE_OPTION) {
			this._text = dlg.getText();
		}
		return returnVal;
	}

	/**
	 * set a DataFormat value
	 */
	public void setValue(UntypedData data) {
		if (data != null) {
			this._text = data.toString();
		}
	}

	/**
	 * get the DataFormat value
	 */
	public UntypedData getValue() {
		try {
			return new DataFormat(_text);
		} catch (DataFormatException e) {
			ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
			JOptionPane
					.showMessageDialog(
							null,
							"unknown data format. please use a valid mime type in the format major/minor. E.g.\""
									+ MimeUtil.UNKNOWN_MIME_TYPE + "\"",
							"EdalFileChooser", JOptionPane.ERROR_MESSAGE);
			return new EmptyMetaData();
		}
	}
	
	@Override
	public void setTitle(String title) {
		_title = title;
	}

}
