/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor;

import java.awt.event.ActionEvent;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DateEvents;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;
/**
 *  The <code>DateEventsEditor</code> is a wrapper class for <code>DateEventsDialog</code>,
 *  we can use it  with a couple of lines of code:  <p>
 *  <pre>
 *  	DateEventsEditor dateEventsEditor = new DateEventsEditor();
 *  	dateEventsEditor.setValue(dataevents); 
 *  	dateEventsEditor.showOpenDialog();
 *  </pre><p>
 * <p>
 * @version 1.0
 * @author Jinbo Chen
 */
public class DateEventsEditor extends AbstractMetaDataEditor{
	private DateEvents _dateevents;
	private String _title;
	/**
	 *  pop up a DateEventsDialog Dialog
	 */
	public int showOpenDialog() {
		DateEventsDialog dlg = new DateEventsDialog(this._dateevents,this._title);
		int returnVal = dlg.showOpenDialog();
		if (returnVal == DateEventsDialog.APPROVE_OPTION) {
			this._dateevents = dlg.getDateEvents();
		}
		return returnVal;
	}
	/**
	 * set the DateEvents value.
	 * 
	 * set the DateEvents value.
	 */
	public void setValue(UntypedData dataevents) {
		if(dataevents!=null)
		{
			this._dateevents = (DateEvents)dataevents;
		}
	}
	/**
	 * Returns the DateEvents inputted by user.
	 * 
	 * @return the DateEvents inputted by user.
	 */
	public UntypedData getValue() {		
		return this._dateevents;
	}
	
	@Override
	public void setTitle(String title) {
		_title = title;
	}
}
