/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;


import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.LegalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Person;
/**
 *  The <code>PersonDialog</code> can be used to edit <code>Person</code>,
 *  which implements the  <code>MetadataeditDialog</code> class, we can use it
 *  with a couple of lines of code:  <p>
 *  <pre>
 *  	PersonDialog personDialog = new PersonDialog(person); 
 *  	personDialog.showOpenDialog();
 *  </pre><p>
 * <p>
 * @version 1.0
 * @author Jinbo Chen
 */
public class PersonDialog extends MetaDataEditDialog{
	private static final long serialVersionUID = 1L;
	
	private JLabel surnamelabel;
	private JTextField surnametext;
	private JLabel givennamelabel;
	private JTextField givennametext;
	private JLabel addresslabel;
	private JTextField addresstext;
	private JLabel ziplabel;
	private JTextField ziptext;
	private JLabel countrylabel;
	private JTextField countrytext;
	private JLabel legalnamelabel;
	private JTextField legalnametext;
	private JLabel persontypelabel;
	private JComboBox persontypecomboBox;  
	private Person person;
	private int layoutindex = 1;
	
	/**
     * Constructs a <code>PersonDialog</code> that is initialized with
     * <code>person</code>.
     *
     * @param person      Person object to show in PersonDialog
     */ 
	public PersonDialog(Person person,String title)
	{
		super();
		
		this.person = person;
		
		setTitle(title);
		
		
		JPanel contents = (JPanel) getContentPane();
		contents.setLayout(new BorderLayout());
		
		final JPanel editPane = new JPanel();		
		final GridBagLayout gridbag = new GridBagLayout();
		editPane.setLayout(gridbag);
		
		GridBagConstraints c = new GridBagConstraints();
		
		persontypelabel = new JLabel("Person Type:");
		c.fill = GridBagConstraints.BOTH;
		c.gridx=0;
        c.gridy=0;	
        c.gridheight=1;
        c.gridwidth=1;
        c.weightx= 0;
        c.insets = new Insets(0,0,3,0);
        
    	gridbag.setConstraints(persontypelabel, c);
		editPane.add(persontypelabel);
		
		final String persontypelabels[] = { NaturalPerson.class.getSimpleName(), LegalPerson.class.getSimpleName() };  
		final DefaultComboBoxModel persontypemodel = new DefaultComboBoxModel(persontypelabels);
		persontypecomboBox = new JComboBox(persontypemodel);
		if(person instanceof de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson)
		{
			persontypecomboBox.setSelectedIndex(0);
		}
		else
		{
			persontypecomboBox.setSelectedIndex(1);
		}
		persontypecomboBox.addActionListener(new ActionListener() {  
		      public void actionPerformed(ActionEvent e) { 
		    	  layoutindex = 1;
		    	  if(persontypecomboBox.getSelectedItem().toString().equals(NaturalPerson.class.getSimpleName()))
		    	  {
		    		  buildnatureperonui(gridbag, editPane);
		    	  }
		    	  else
		    	  {
		    		  buildlegalperonui(gridbag, editPane);
		    	  }	
		    	  editPane.updateUI();
		    	  initdata();
		      }  
		});
		
		
		c.fill = GridBagConstraints.BOTH;
		c.gridx=1;
        c.gridy=0;	
        c.gridheight=1;
        c.gridwidth=2;
        c.weightx=1.0;
    	gridbag.setConstraints(persontypecomboBox, c);
		editPane.add(persontypecomboBox);
		
		if(person instanceof de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson)
		{
			buildnatureperonui(gridbag, editPane);
		}
		else
		{
			buildlegalperonui(gridbag, editPane);
		}

		contents.add(editPane,BorderLayout.CENTER);
		contents.add(createbuttonpanel(),BorderLayout.SOUTH);
		
		
		this.setSize(new Dimension(400,(int)(400*0.618)));
		
		initdata();
	}
	
	private void buildcommonsui(GridBagLayout gridbag,JPanel editPane)
	{
		if(addresslabel!=null)
		{
			editPane.remove(addresslabel);
		}
		if(addresstext!=null)
		{
			editPane.remove(addresstext);
		}
		
		if(ziplabel!=null)
		{
			editPane.remove(ziplabel);
		}
		if(ziptext!=null)
		{
			editPane.remove(ziptext);
		}
		
		if(countrylabel!=null)
		{
			editPane.remove(countrylabel);
		}
		if(countrytext!=null)
		{
			editPane.remove(countrytext);
		}
		
		GridBagConstraints c = new GridBagConstraints();
		c.fill = GridBagConstraints.BOTH;
		c.insets = new Insets(0,0,3,0);
		
		addresslabel = new JLabel("Address:");
		c.fill = GridBagConstraints.BOTH;
		c.gridx=0;
        c.gridy=layoutindex;	
        c.gridheight=1;
        c.gridwidth=1;
        c.weightx= 0;
    	gridbag.setConstraints(addresslabel, c);
		editPane.add(addresslabel);
		
		addresstext = new JTextField();
		c.fill = GridBagConstraints.BOTH;
		c.gridx=1;
        c.gridy=layoutindex;	
        c.gridheight=1;
        c.gridwidth=2;
        c.weightx=1.0;
    	gridbag.setConstraints(addresstext, c);
		editPane.add(addresstext);
		
		layoutindex++;
		
		ziplabel = new JLabel("Zip:");
		c.fill = GridBagConstraints.BOTH;
		c.gridx=0;
        c.gridy=layoutindex;	
        c.gridheight=1;
        c.gridwidth=1;
        c.weightx= 0;
    	gridbag.setConstraints(ziplabel, c);
		editPane.add(ziplabel);
		
		ziptext = new JTextField();
		c.fill = GridBagConstraints.BOTH;
		c.gridx=1;
        c.gridy=layoutindex;	
        c.gridheight=1;
        c.gridwidth=2;
        c.weightx=1.0;
    	gridbag.setConstraints(ziptext, c);		
		editPane.add(ziptext);
		
		layoutindex++;
		
		countrylabel = new JLabel("Country:");
		c.fill = GridBagConstraints.BOTH;
		c.gridx=0;
        c.gridy=layoutindex;	
        c.gridheight=1;
        c.gridwidth=1;
        c.weightx= 0;
    	gridbag.setConstraints(countrylabel, c);
		editPane.add(countrylabel);
		
		countrytext = new JTextField();
		c.fill = GridBagConstraints.BOTH;
		c.gridx=1;
        c.gridy=layoutindex;	
        c.gridheight=1;
        c.gridwidth=2;
        c.weightx=1.0;
    	gridbag.setConstraints(countrytext, c);		
		editPane.add(countrytext);
		
	}
	
	private void buildnatureperonui(GridBagLayout gridbag,JPanel editPane)
	{
		if(legalnamelabel!=null)
		{
			editPane.remove(legalnamelabel);
		}
		if(legalnametext!=null)
		{
			editPane.remove(legalnametext);
		}
		
		GridBagConstraints c = new GridBagConstraints();
		c.fill = GridBagConstraints.BOTH;
		c.insets = new Insets(0,0,3,0);
		
		givennamelabel = new JLabel("GivenName:");
		c.fill = GridBagConstraints.BOTH;
		c.gridx=0;
        c.gridy=layoutindex;	
        c.gridheight=1;
        c.gridwidth=1;
        c.weightx= 0;
    	gridbag.setConstraints(givennamelabel, c);
		editPane.add(givennamelabel);
		
		givennametext = new JTextField();
		c.fill = GridBagConstraints.BOTH;
		c.gridx=1;
        c.gridy=layoutindex;	
        c.gridheight=1;
        c.gridwidth=2;
        c.weightx=1.0;
    	gridbag.setConstraints(givennametext, c);
		editPane.add(givennametext);
		
		layoutindex ++;
		
		c.gridx=0;
        c.gridy=layoutindex;		
        c.gridheight=1;
        c.gridwidth=1;	
        c.weightx= 0;
		surnamelabel = new JLabel("SureName:");
		gridbag.setConstraints(surnamelabel, c);
		editPane.add(surnamelabel);
		
		surnametext = new JTextField();
		c.fill = GridBagConstraints.BOTH;
		c.gridx=1;
        c.gridy=layoutindex;	
        c.gridheight=1;
        c.gridwidth=2;
        c.weightx=1.0;
    	gridbag.setConstraints(surnametext, c);
		editPane.add(surnametext);
		
		layoutindex++;
		
		
		
		buildcommonsui(gridbag,editPane);
	}
	
	private void buildlegalperonui(GridBagLayout gridbag,JPanel editPane)
	{
		if(surnamelabel!=null)
		{
			editPane.remove(surnamelabel);
		}
		if(surnametext!=null)
		{
			editPane.remove(surnametext);
		}
		if(givennamelabel!=null)
		{
			editPane.remove(givennamelabel);
		}
		if(givennametext!=null)
		{
			editPane.remove(givennametext);
		}
		
		GridBagConstraints c = new GridBagConstraints();
		c.insets = new Insets(0,0,3,0);
		c.fill = GridBagConstraints.BOTH;
		c.gridx=0;
        c.gridy=layoutindex;		
        c.gridheight=1;
        c.gridwidth=1;	
        c.weightx= 0;
        legalnamelabel = new JLabel("LegalName:");
		gridbag.setConstraints(legalnamelabel, c);
		editPane.add(legalnamelabel);
		
		legalnametext = new JTextField();
		c.fill = GridBagConstraints.BOTH;
		c.gridx=1;
        c.gridy=layoutindex;	
        c.gridheight=1;
        c.gridwidth=2;
        c.weightx=1.0;
    	gridbag.setConstraints(legalnametext, c);
		editPane.add(legalnametext);
		
		layoutindex ++;
		
		buildcommonsui(gridbag,editPane);
	}
	
	@Override
	public void initdata()
	{
		if(person!=null)
		{
			if(person instanceof de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson)
			{
				surnametext.setText(((NaturalPerson)person).getSureName());
				givennametext.setText(((NaturalPerson)person).getGivenName());
			}
			else
			{
				legalnametext.setText(((LegalPerson)person).getLegalName());
			}
			addresstext.setText(person.getAddressLine());
			ziptext.setText(person.getZip());
			countrytext.setText(person.getCountry());
		}
	}
	
	/**
	 * Returns the Person inputted by user.
	 * 
	 * @return the Person inputted by user.
	 */
	public Person getPerson()
	{
		if(persontypecomboBox.getSelectedItem().toString().equals(NaturalPerson.class.getSimpleName()))
		{
			Person newperson = new NaturalPerson(surnametext.getText().trim(), givennametext.getText().trim(), addresstext.getText().trim(), ziptext.getText().trim(), countrytext.getText().trim());
			return newperson;
		}
		else
		{
			Person newperson = new LegalPerson(legalnametext.getText().trim(), addresstext.getText().trim(), ziptext.getText().trim(), countrytext.getText().trim());
			return newperson;
		}		
	}
	
}
