/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor;

import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/**
 *  The <code>TextDialog</code> can be used to edit text information,
 *  which implements the  <code>MetadataeditDialog</code> class, we can use it
 *  with a couple of lines of code:  <p>
 *  <pre>
 *  	TextDialog textDialog = new TextDialog(text); 
 *  	textDialog.showOpenDialog();
 *  </pre><p>
 * <p>
 * @version 1.0
 * @author Jinbo Chen
 */
public class TextDialog extends MetaDataEditDialog{
	private static final long serialVersionUID = 1L;
	private JTextArea textarea;
	private String _text;
	
	/**
     * Constructs a <code>TextDialog</code> that is initialized with String
     *
     * @param text      Text information to show in TextDialog
     */ 
	public TextDialog(String text,String title)
	{
		super();
		
		this._text = text;		
		
		setTitle(title);
		
		JPanel contents = (JPanel) getContentPane();
		contents.setLayout(new BorderLayout());
		
		JPanel editPane = new JPanel();	
		editPane.setLayout(new BorderLayout());
		
		textarea = new JTextArea();
		textarea.setLineWrap(true);
		
		JScrollPane scroll = new JScrollPane(textarea, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
		JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		
		editPane.add(scroll,BorderLayout.CENTER);
		
		
		contents.add(editPane,BorderLayout.CENTER);
		contents.add(createbuttonpanel(),BorderLayout.SOUTH);
		
		this.setSize(new Dimension(350,(int)(350*0.618)));
		
		initdata();
	}
	@Override
	public void initdata()
	{
		if(_text!=null)
		{
			textarea.setText(_text);
		}
	}
	/**
	 * Returns the Text information inputted by user.
	 * 
	 * @return the Text information inputted by user.
	 */
	public String getText()
	{
		return textarea.getText();
	}
}
