/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer;


import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.CheckSum;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;
/**
 *  The <code>CheckSumViewer</code> wrappers class <code>CheckSumviewDialog</code> as
 *  a <code>MetadataViewer</code> Dialog to view CheckSum datatype.
 *  we can use it  with a couple of lines of code:  <p>
 *  <pre>
 *  	CheckSumViewer checkSumViewer = new CheckSumViewer();
 *  	checkSumViewer.showOpenDialog();
 *  </pre><p>
 * <p>
 * @version 1.0
 * @author Jinbo Chen
 */
public class CheckSumViewer extends MetadataViewer{
	private CheckSum checkSum;;
	/**
	 *  pop up a CheckSumviewDialog Dialog
	 */
	public int showOpenDialog() {
		CheckSumviewDialog dlg = new CheckSumviewDialog(this.checkSum);
		int returnVal = dlg.showOpenDialog();
		return returnVal;
	}
	/**
	 * set the CheckSum value.
	 * 
	 * set the CheckSum value.
	 */
	public void setValue(UntypedData checkSum) {
		if(checkSum!=null)
		{
			this.checkSum = (CheckSum)checkSum;
		}
	}
}
