/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;
/**
 *  This is a abstract class. 
 *  To create a concrete <code>MetadataViewer</code> as a subclass,you need only provide implementations 
 *  for the following three methods: 
 *  <pre>
 *  public abstract int showOpenDialog();
 *	public abstract void setValue(UntypedData person);
 *  </pre>
 * <p>
 * @version 1.0
 * @author Jinbo Chen
 */

public abstract class MetadataViewer {
	/**
	 * pop up a Dialog
	 */
	public abstract int showOpenDialog();
	/**
	 * set the original value of metadata
	 */
	public abstract void setValue(UntypedData person);
	/** 
	 * set the title of metadata dialog
	 */
	public void setTitle(String title)
	{
		
	}
}
