/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Person;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;
/**
 *  The <code>PersonInfoViewer</code> is a wrapper class for <code>PersonviewDialog</code>,
 *  we can use it  with a couple of lines of code:  <p>
 *  <pre>
 *  	PersonInfoViewer personInfoViewer = new PersonInfoViewer();
 *  	personInfoViewer.setValue(person); 
 *  	personInfoViewer.showOpenDialog();
 *  </pre><p>
 * <p>
 * @version 1.0
 * @author Jinbo Chen
 */
public class PersonInfoViewer extends MetadataViewer{
	private Person _person;	
	private String _title;
	/**
	 * set the Person value.
	 * 
	 * set the Person value.
	 */
	public void setValue(UntypedData person) {
		if(person!=null)
		{
			this._person = (Person)person;
		}
	}
	/**
	 *  pop up a PersonviewDialog Dialog
	 */
	public int showOpenDialog() {
		PersonviewDialog dlg = new PersonviewDialog(this._person,this._title);
		int returnVal = dlg.showOpenDialog();
		return returnVal;
	}
	
	@Override
	public void setTitle(String title) {
		_title = title;
	}
}
