/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;


import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Person;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.LegalPerson;
/**
 *  The <code>PersonviewDialog</code> can be used to view <code>Person</code>,
 *  which implements the  <code>MetadataviewDialog</code> class, we can use it
 *  with a couple of lines of code:  <p>
 *  <pre>
 *  	PersonviewDialog personviewDialog = new PersonviewDialog(person); 
 *  	personviewDialog.showOpenDialog();
 *  </pre><p>
 * <p>
 * @version 1.0
 * @author Jinbo Chen
 */
public class PersonviewDialog extends MetadataViewDialog{
	private static final long serialVersionUID = 1L;
	
	private JLabel surnamelabel;
	private JTextField surnametext;
	private JLabel givennamelabel;
	private JTextField givennametext;
	private JLabel addresslabel;
	private JTextField addresstext;
	private JLabel ziplabel;
	private JTextField ziptext;
	private JLabel countrylabel;
	private JTextField countrytext;
	private JLabel legalnamelabel;
	private JTextField legalnametext;
	private Person person;
	
	public PersonviewDialog(Person person,String title)
	{
		super();
		
		this.person = person;
		
		setTitle(title);
		
		JPanel contents = (JPanel) getContentPane();
		contents.setLayout(new BorderLayout());
		
		JPanel editPane = new JPanel();		
		GridBagLayout gridbag = new GridBagLayout();
		editPane.setLayout(gridbag);
		
		GridBagConstraints c = new GridBagConstraints();
		
		addresslabel = new JLabel("Address:");
		c.fill = GridBagConstraints.BOTH;
		c.gridx=0;
        c.gridy=0;	
        c.gridheight=1;
        c.gridwidth=1;
        c.weightx= 0;
        c.insets = new Insets(0,0,3,0);
    	gridbag.setConstraints(addresslabel, c);
		editPane.add(addresslabel);
		
		addresstext = new JTextField();
		c.fill = GridBagConstraints.BOTH;
		c.gridx=1;
        c.gridy=0;	
        c.gridheight=1;
        c.gridwidth=2;
        c.weightx=1.0;
        c.ipadx=1;
        c.ipady=1;
        addresstext.setEditable(false);
    	gridbag.setConstraints(addresstext, c);
		editPane.add(addresstext);
		
		ziplabel = new JLabel("Zip:");
		c.fill = GridBagConstraints.BOTH;
		c.gridx=0;
        c.gridy=1;	
        c.gridheight=1;
        c.gridwidth=1;
        c.weightx= 0;
        c.ipadx=1;
        c.ipady=1;
    	gridbag.setConstraints(ziplabel, c);
		editPane.add(ziplabel);
		
		ziptext = new JTextField();
		c.fill = GridBagConstraints.BOTH;
		c.gridx=1;
        c.gridy=1;	
        c.gridheight=1;
        c.gridwidth=2;
        c.weightx=1.0;
        c.ipadx=1;
        c.ipady=1;
        ziptext.setEditable(false);
    	gridbag.setConstraints(ziptext, c);		
		editPane.add(ziptext);
		
		countrylabel = new JLabel("Country:");
		c.fill = GridBagConstraints.BOTH;
		c.gridx=0;
        c.gridy=2;	
        c.gridheight=1;
        c.gridwidth=1;
        c.weightx= 0;
    	gridbag.setConstraints(countrylabel, c);
		editPane.add(countrylabel);
		
		countrytext = new JTextField();
		c.fill = GridBagConstraints.BOTH;
		c.gridx=1;
        c.gridy=2;	
        c.gridheight=1;
        c.gridwidth=2;
        c.weightx=1.0;
        countrytext.setEditable(false);
    	gridbag.setConstraints(countrytext, c);		
		editPane.add(countrytext);
		
		if(person instanceof de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson)
		{
			c.fill = GridBagConstraints.BOTH;
			c.gridx=0;
	        c.gridy=3;		
	        c.gridheight=1;
	        c.gridwidth=1;	
	        c.weightx= 0;
			surnamelabel = new JLabel("SureName:");
			gridbag.setConstraints(surnamelabel, c);
			editPane.add(surnamelabel);
			
			surnametext = new JTextField();
			c.fill = GridBagConstraints.BOTH;
			c.gridx=1;
	        c.gridy=3;	
	        c.gridheight=1;
	        c.gridwidth=2;
	        c.weightx=1.0;
	        surnametext.setEditable(false);
	    	gridbag.setConstraints(surnametext, c);
			editPane.add(surnametext);
			
			givennamelabel = new JLabel("GivenName:");
			c.fill = GridBagConstraints.BOTH;
			c.gridx=0;
	        c.gridy=4;	
	        c.gridheight=1;
	        c.gridwidth=1;
	        c.weightx= 0;
	    	gridbag.setConstraints(givennamelabel, c);
			editPane.add(givennamelabel);
			
			givennametext = new JTextField();
			c.fill = GridBagConstraints.BOTH;
			c.gridx=1;
	        c.gridy=4;	
	        c.gridheight=1;
	        c.gridwidth=2;
	        c.weightx=1.0;
	        givennametext.setEditable(false);
	    	gridbag.setConstraints(givennametext, c);
			editPane.add(givennametext);
		}
		else
		{
			c.fill = GridBagConstraints.BOTH;
			c.gridx=0;
	        c.gridy=3;		
	        c.gridheight=1;
	        c.gridwidth=1;	
	        c.weightx= 0;
	        legalnamelabel = new JLabel("LegalName:");
			gridbag.setConstraints(legalnamelabel, c);
			editPane.add(legalnamelabel);
			
			legalnametext = new JTextField();
			c.fill = GridBagConstraints.BOTH;
			c.gridx=1;
	        c.gridy=3;	
	        c.gridheight=1;
	        c.gridwidth=2;
	        c.weightx=1.0;
	        legalnametext.setEditable(false);
	    	gridbag.setConstraints(legalnametext, c);
			editPane.add(legalnametext);
		}

		contents.add(editPane,BorderLayout.CENTER);
		contents.add(createbuttonpanel(),BorderLayout.SOUTH);
		
		
		this.setSize(new Dimension(350,(int)(350*0.618)));
		
		initdata();
	}
	@Override
	public void initdata()
	{
		if(person!=null)
		{
			if(person instanceof de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson)
			{
				surnametext.setText(((NaturalPerson)person).getSureName());
				givennametext.setText(((NaturalPerson)person).getGivenName());
			}
			else
			{
				legalnametext.setText(((LegalPerson)person).getLegalName());
			}
			addresstext.setText(person.getAddressLine());
			ziptext.setText(person.getZip());
			countrytext.setText(person.getCountry());
		}
	}
	
}
