/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.util;

import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataFile;
/**
 * <code>EDALFileFilter</code> is an abstract class used by {@code EDALFileChooser}
 * for filtering the set of files shown to the user. See 
 * {@code EDALFileNameExtensionFilter} for an implementation that filters using
 * the file name extension.
 * <p>
 * A <code>EDALFileFilter</code> 
 * can be set on a <code>EDALFileChooser</code> to
 * keep unwanted files from appearing in the directory listing.
 *
 * @see de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.EdalFileChooser#setFileFilter
 *
 * @version 1.0
 * @author Jinbo Chen
 */
public abstract class EdalAbstractFileFilter {
	/**
     * Whether the given file is accepted by this filter.
     */ 
	public abstract boolean accept(ClientPrimaryDataFile f);
	/**
     * The description of this filter. For example: "JPG and GIF Images"
     */ 
	public abstract String getDescription();
}
