/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.util;

import java.util.prefs.Preferences;

import javax.swing.JOptionPane;
import javax.swing.JTextField;

import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.rmi.server.Authentication;

public class EdalLoginHelper {
	public static String serveraddress;
	public static int serverport;
	public static String username;
	public static String password;
	public static ClientDataManager client;
	public static ClientPrimaryDataDirectory rootDirectory;
	public static boolean islogin = false;

	public static String encrypt(String password) {
		try {
			return ThreeDes.encrypt(password);
		} catch (Exception ex) {
			ClientDataManager.logger.error(StackTraceUtil.getStackTrace(ex));
		}
		return null;
	}

	public static String decrypt(String epassword) {
		try {
			return ThreeDes.decrypt(epassword);
		} catch (Exception ex) {
			ClientDataManager.logger.error(StackTraceUtil.getStackTrace(ex));
		}
		return null;
	}

	public void initdata(JTextField serveraddresstxt, JTextField serverporttxt,
			JTextField serverusernametxt, JTextField serverpasswordtxt) {
		Preferences prefs = Preferences.userRoot().node(
				this.getClass().getName());
		if (prefs.get("serveraddress", null) != null) {
			serveraddresstxt.setText(prefs.get("serveraddress", null));
		}
		if (prefs.get("serverport", null) != null) {
			serverporttxt.setText(prefs.get("serverport", null));
		}
		if (prefs.get("serverusername", null) != null) {
			serverusernametxt.setText(prefs.get("serverusername", null));
		}
		if (prefs.get("serverpassword", null) != null) {
			serverpasswordtxt.setText(EdalLoginHelper.decrypt(prefs.get(
					"serverpassword", null)));
		}
	}

	public void savedata(String serveraddress, int serverport, String username,
			String password) {
		Preferences prefs = Preferences.userRoot().node(
				this.getClass().getName());
		prefs.put("serveraddress", serveraddress.trim());
		prefs.put("serverport", Integer.toString(serverport));
		prefs.put("serverusername", username.trim());
		prefs.put("serverpassword", EdalLoginHelper.encrypt(password.trim()));
		
		EdalLoginHelper.serveraddress = serveraddress;
		EdalLoginHelper.serverport = serverport;
		EdalLoginHelper.username = username;
	}

	public boolean startlogin() {
		Preferences prefs = Preferences.userRoot().node(
				this.getClass().getName());
		if (prefs.get("serveraddress", null) != null
				&& prefs.get("serverport", null) != null
				&& prefs.get("serverusername", null) != null
				&& prefs.get("serverpassword", null) != null) {
			return loginremoteserver(prefs.get("serveraddress", null),
					Integer.parseInt(prefs.get("serverport", null)),
					prefs.get("serverusername", null),
					EdalLoginHelper.decrypt(prefs.get("serverpassword", null)));
		} else {
			return false;
		}
	}

	public boolean loginremoteserver(String serveraddress, int serverport,
			String username, String password) {
		try {
			Authentication auth = new Authentication(username, password);
			client = new ClientDataManager(serverport, serveraddress, auth);
			rootDirectory = client.getRootDirectory();
			islogin = true;
			EdalLoginHelper.serveraddress = serveraddress;
			EdalLoginHelper.serverport = serverport;
			EdalLoginHelper.username = username;
		} catch (Exception e) {
			islogin = false;
			client = null;
			rootDirectory = null;
			ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
			JOptionPane
					.showMessageDialog(
							null,
							e.getMessage(),
							"eDAL", JOptionPane.ERROR_MESSAGE);
		} 

		return islogin;
	}

}
