/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.util;

import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.swing.JOptionPane;

import de.ipk_gatersleben.bit.bi.edal.aspectj.security.GrantableMethods.Methods;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityException;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntity;

/**
 * A utility class used to manage Principal
 * 
 * @version 1.0
 * @author Jinbo Chen
 */
public class PrincipalUtil {

	/**
	 * From the <code>classname</code> and <code>username</code> to get a
	 * Principal Instance
	 * 
	 */
	public static Principal getInstance(String classname, String username) {
		Class c = null;
		Constructor con = null;
		Principal principal = null;
		try {
			c = Class.forName(classname);
			con = c.getConstructor(String.class);
			principal = (Principal) con.newInstance(username);
			return principal;
		} catch (Exception e) {
			ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
			return null;
		}
	}

	/**
	 * check in the <code>dataentry</code> if the <code>principalname</code> and
	 * <code>username</code> have a permission <code>methodname</code>
	 * 
	 */
	public static boolean checkPermission(ClientPrimaryDataEntity dataentry,
			String principalname, String username, String methodname) {

		try {
			Map<Principal, List<Methods>> permissionmap = dataentry
					.getPermissions();
			if (permissionmap != null) {
				Iterator it = permissionmap.entrySet().iterator();
				while (it.hasNext()) {
					Map.Entry<Principal, List<Methods>> entry = (Map.Entry<Principal, List<Methods>>) it
							.next();
					Principal key = entry.getKey();
					if (key.getName().equals(username)
							&& key.getClass().getName().equals(principalname)) {
						List<Methods> value = entry.getValue();
						for (Methods method : value) {
							if (method.toString().equals(methodname)) {
								return true;
							}
						}
					}
				}
			}
		} catch (RemoteException e) {
			ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
			JOptionPane.showMessageDialog(
					null,
					"Call remote Edal server function exception:"
							+ e.getMessage(), "EdalFileChooser",
					JOptionPane.ERROR_MESSAGE);
		} catch (PrimaryDataEntityException e) {
			ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
			JOptionPane.showMessageDialog(null,
					"Call Edal server function exception:" + e.getMessage(),
					"EdalFileChooser", JOptionPane.ERROR_MESSAGE);
		}
		return false;
	}

	/**
	 * check in the <code>dataentry</code> if the <code>username</code> have a
	 * permission <code>methodname</code>
	 * 
	 */
	public static boolean checkPermission(ClientPrimaryDataEntity dataentry,
			String username, String methodname) {

		try {
			Map<Principal, List<Methods>> permissionmap = dataentry
					.getPermissions();
			if (permissionmap != null) {
				Iterator it = permissionmap.entrySet().iterator();
				while (it.hasNext()) {
					Map.Entry<Principal, List<Methods>> entry = (Map.Entry<Principal, List<Methods>>) it
							.next();
					Principal key = entry.getKey();
					if (key.getName().equals(username)) {
						List<Methods> value = entry.getValue();
						for (Methods method : value) {
							if (method.toString().equals(methodname)) {
								return true;
							}
						}
					}
				}
			}
		} catch (RemoteException e) {
			ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
			JOptionPane.showMessageDialog(
					null,
					"Call remote Edal server function exception:"
							+ e.getMessage(), "EdalFileChooser",
					JOptionPane.ERROR_MESSAGE);
		} catch (PrimaryDataEntityException e) {
			ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
			JOptionPane.showMessageDialog(null,
					"Call Edal server function exception:" + e.getMessage(),
					"EdalFileChooser", JOptionPane.ERROR_MESSAGE);
		}
		return false;
	}
}
