/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.sample;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

import org.apache.log4j.helpers.Loader;
import org.eclipse.jetty.webapp.WebAppContext;

import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;

public class AppContextBuilder {
	private WebAppContext webAppContext;

	public WebAppContext buildWebAppContext() {
		webAppContext = new WebAppContext();
		try {
			webAppContext.setDescriptor(URLDecoder.decode(
					Loader.getResource("WEB-INF/web.xml").toExternalForm(),
					"UTF-8"));
			webAppContext.setResourceBase(URLDecoder.decode(
					Loader.getResource("WEB-INF/web.xml").toExternalForm(),
					"UTF-8"));
		} catch (UnsupportedEncodingException e) {
			ClientDataManager.logger.fatal(e.getMessage());
		}

		webAppContext.setContextPath("/");
		webAppContext.setParentLoaderPriority(true);
		return webAppContext;
	}
}
