/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.sample;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

/**
 * Main class to start a client application from <br/>
 * "java -jar ***-jar-with-dependencies.jar"
 * 
 * @author arendd
 */

public class ClientStarter {

	private static int EDAL_PORT = 2000;
	private static String EDAL_HOST = "localhost";
	private static int WEBDAV_PORT = 8080;

	public static void main(String[] args) {

		final Options options = new Options();

		System.out
				.println("e!DAL client application\nCopyright (c) 2012, IPK-Gatersleben.\nAll rights reserved.\n");

		options.addOption("h", "help", false, "print help");
		options.addOption("w", "webdav", false, "start WebDAV ");
		options.addOption("g", "gui", false, "start FileChooser GUI ");

		options.addOption("p", "server_port", true,
				"set port for e!DAL server (default=" + EDAL_PORT + ")");
		options.addOption("d", "webdav_port", true,
				"set port for WebDAV server (default=" + WEBDAV_PORT + ")");
		options.addOption("s", "server_host", true,
				"set host for e!DAL server (default=" + EDAL_HOST + ")");

		final HelpFormatter form = new HelpFormatter();

		final CommandLineParser parser = new PosixParser();
		CommandLine cmd = null;
		try {
			cmd = parser.parse(options, args);
		} catch (final ParseException e) {
			e.printStackTrace();
		}
		if (cmd.hasOption("h")) {
			form.printHelp("-h", options);
			System.exit(0);
		}

		if (cmd.hasOption("s")) {
			EDAL_HOST = cmd.getOptionValue("s");
		}
		if (cmd.hasOption("p")) {
			try {
				EDAL_PORT = Integer.parseInt(cmd.getOptionValue("p"));
			} catch (NumberFormatException e) {
				System.out
						.println("Please enter a number for e!DAL server port");
				System.exit(0);
			}
		}
		if (cmd.hasOption("d")) {
			try {
				WEBDAV_PORT = Integer.parseInt(cmd.getOptionValue("d"));
			} catch (NumberFormatException e) {
				System.out.println("Please enter a number for WebDAV port");
				System.exit(0);
			}
		}

		/* start WebDAV application */
		if (cmd.hasOption("w")) {
			String[] argm = { "-p" + String.valueOf(EDAL_PORT),
					"-s" + EDAL_HOST, "-d" + String.valueOf(WEBDAV_PORT) };

			de.ipk_gatersleben.bit.bi.edal.webdav.sample.Main.main(argm);
		}
		/* start GUI application */
		else if (cmd.hasOption("g")) {
			String[] argm = { EDAL_HOST, String.valueOf(EDAL_PORT) };

			de.ipk_gatersleben.bit.bi.edal.rmi.sample.gui.Main.main(argm);
		}
		/* stop program if no application is select */
		else {
			System.out
					.println("Please set -w to start WebDAV or -g to start FileChooser GUI");
			System.exit(-0);
		}
	}
}