/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.wrapper;

import io.milton.http.HttpManager;

public interface EdalInitListener {
	/**
	 * Called just before init on HttpManagerBuilder
	 * 
	 * @param b
	 */
	void beforeInit(EdalHttpManagerBuilder b);

	/**
	 * Called just after init, and before building the HttpManager instance
	 * 
	 * @param b
	 */
	void afterInit(EdalHttpManagerBuilder b);

	/**
	 * Called immediately after bulding the http manager
	 * 
	 * @param b
	 * @param m
	 */
	void afterBuild(EdalHttpManagerBuilder b, HttpManager m);

}
