/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.wrapper;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

/**
 * A class for caching the edal-filesystem
 * 
 * @author benz
 * 
 */

public class FileSystemCache {
	private static Cache cache = null;
	private static CacheManager manager = null;
	public static int cache_depth = 0;

	private FileSystemCache() {
	}

	public static void release() {
		if (manager != null) {
			manager.shutdown();
		}
	}

	/**
	 * Updates the FileSystemCache to keep cache_depth at a correct level.
	 */
	public void update() {

	}

	public static void init() {
		manager = CacheManager.create();
		cache = manager.getCache("edalfilehandle");
	}

	public static void put(String key, FileSystemHandler fileSystemHandler) {
		if (key != null) {
			cache.put(new Element(key, fileSystemHandler));
		}
	}

	public static FileSystemHandler get(String key) {
		if (cache.isKeyInCache(key)) {
			if ((cache.get(key)) == null) {
				return null;
			}
			return (FileSystemHandler) cache.get(key).getObjectValue();
		} else {
			return null;
		}

	}

}
