/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.metadata;

import java.util.Locale;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalLanguage;

@XmlRootElement
public class EdalLanguageWrapper {
	@XmlAttribute private String language;
	
	public EdalLanguageWrapper() {
		
	}
	
	public EdalLanguageWrapper(de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalLanguage language) {
		this.language = language.getLanguage().getDisplayLanguage();
	}
	
	public String getLanguage() {
		return language;
	}
	
	public EdalLanguage getEdalLanguage()
	{
		return new EdalLanguage(new Locale(language));
	}
}
