/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.metadata;

import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class LegalPersonWrapper extends PersonWrapper{	
	private String legalName;

	public LegalPersonWrapper(de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.LegalPerson p) {
		super(p);
		this.legalName = p.getLegalName();
	}

	
	public String getLegalName() {
		return legalName;
	}

	public void setLegalName(String legalName) {
		this.legalName = legalName;
	}

	public de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.LegalPerson getPerson() {
		return new de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.LegalPerson(this.legalName, this.getAddress_line(), this.getZip(), this.getCountry());
	}
}
