/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.metadata;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public abstract class PersonWrapper {
	@XmlAttribute private String address_line;
	@XmlAttribute private String country;
	@XmlAttribute private String zip;
	
	public PersonWrapper()
	{
		
	}

	public PersonWrapper(de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Person p) {
		this.address_line = p.getAddressLine();
		this.country = p.getCountry();
		this.zip = p.getZip();
	}

	public String getAddress_line() {
		return address_line;
	}
	
	public void setAddress_line(String adressLine) {
		this.address_line = adressLine;
	}
	
	public String getCountry() {
		return country;
	}
	
	public void setCountry(String country) {
		this.country = country;
	}
	
	public String getZip() {
		return zip;
	}
	
	public void setZip(String zip) {
		this.zip = zip;
	}
	
	public abstract de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Person getPerson();
}
