/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client;

import de.ipk_gatersleben.bit.bi.edal.aspectj.security.GrantableMethods;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfiguration;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalAuthenticateException;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.rmi.interfaces.DataManagerRmiInterface;
import de.ipk_gatersleben.bit.bi.edal.rmi.interfaces.PrimaryDataDirectoryRmiInterface;
import de.ipk_gatersleben.bit.bi.edal.rmi.server.Authentication;
import de.ipk_gatersleben.bit.bi.edal.rmi.server.ssl.EdalSslRmiClientSocketFactory;
import java.net.URL;
import java.rmi.ConnectIOException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class ClientDataManager {
    public static Logger logger = null;
    private static Subject subject;
    private static DataManagerRmiInterface dataManager;
    private static Map<Principal, List<GrantableMethods.Methods>> userPermissions;
    private Authentication auth;
    public static Map<Principal, List<GrantableMethods.Methods>> DEFAULT_PERMISSIONS;
    private final int PORT;
    private final String HOST;

    public ClientDataManager(int port, String host, Authentication auth) throws EdalAuthenticateException {
        this.auth = auth;
        this.PORT = port;
        this.HOST = host;
    }

    public MetaData createMetadataInstance() {
        MetaData metadata = null;
        try {
            metadata = dataManager.createMetaDataInstance();
        }
        catch (RemoteException e) {
            logger.error((Object)e.getMessage());
        }
        return metadata;
    }

    public ClientPrimaryDataDirectory getRootDirectory() throws RemoteException, NotBoundException, PrimaryDataDirectoryException, EdalException, EdalAuthenticateException {
        DOMConfigurator.configure((URL)ClientDataManager.class.getResource("log4j.xml"));
        logger = Logger.getLogger((String)"eDAL-Client");
        Registry registry = null;
        try {
            logger.info((Object)"trying unsecure Connection...");
            registry = LocateRegistry.getRegistry(this.HOST, this.PORT);
            dataManager = (DataManagerRmiInterface)registry.lookup("DataManager");
            DOMConfigurator.configure((URL)ClientDataManager.class.getResource("log4j.xml"));
            logger = Logger.getLogger((String)"eDAL-Client");
            logger.info((Object)"unsecure Connection successful !");
        }
        catch (ConnectIOException e) {
            logger.info((Object)"unsecure Connection failed !");
            logger.info((Object)"trying SSL Connection...");
            registry = LocateRegistry.getRegistry(this.HOST, this.PORT, (RMIClientSocketFactory)new EdalSslRmiClientSocketFactory(EdalConfiguration.KEY_STORE_PATH));
            dataManager = (DataManagerRmiInterface)registry.lookup("DataManager");
            DOMConfigurator.configure((URL)ClientDataManager.class.getResource("log4j.xml"));
            logger = Logger.getLogger((String)"eDAL-Client");
            logger.info((Object)"secure Connection successful !");
        }
        subject = dataManager.authenticate(this.auth);
        PrimaryDataDirectoryRmiInterface rootDirectory = dataManager.getRootDirectory(subject);
        userPermissions = dataManager.getDefaultPermissions();
        DEFAULT_PERMISSIONS = dataManager.getDefaultPermissions();
        return new ClientPrimaryDataDirectory(rootDirectory, this);
    }

    protected Subject getSubject() {
        Subject ret = subject;
        if (ret == null) {
            logger.error((Object)"current subject is null");
        }
        return ret;
    }

    public Map<Principal, List<GrantableMethods.Methods>> getDefaultPermissions() {
        return userPermissions;
    }

    public void setDefaultPermissions(Map<Principal, List<GrantableMethods.Methods>> permissions) {
        userPermissions = permissions;
    }

    public void resetDefaultPermissions() {
        userPermissions = DEFAULT_PERMISSIONS;
    }

    public Long getAvailableStorageSpace() throws RemoteException, EdalException {
        return dataManager.getAvailableStorageSpace();
    }

    public Long getUsedStorageSpace() throws RemoteException, EdalException {
        return dataManager.getUsedStorageSpace();
    }

    public List<Class<? extends Principal>> getSupportedPrincipals() throws RemoteException, EdalException {
        return dataManager.getSupportedPrincipals();
    }

    public Authentication getAuthentication() {
        return this.auth;
    }

    static {
        DOMConfigurator.configure((URL)ClientDataManager.class.getResource("log4j.xml"));
        logger = Logger.getLogger((String)"eDAL-Client");
        subject = null;
        dataManager = null;
        DEFAULT_PERMISSIONS = new HashMap<Principal, List<GrantableMethods.Methods>>();
    }
}

