/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client;

import de.ipk_gatersleben.bit.bi.edal.aspectj.security.GrantableMethods;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PersistentIdentifier;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientContext;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.rmi.interfaces.PrimaryDataDirectoryRmiInterface;
import de.ipk_gatersleben.bit.bi.edal.rmi.interfaces.PrimaryDataEntityRmiInterface;
import de.ipk_gatersleben.bit.bi.edal.rmi.interfaces.PrimaryDataEntityVersionRmiInterface;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class ClientPrimaryDataEntity
extends ClientContext
implements Comparable<ClientPrimaryDataEntity> {
    protected PrimaryDataEntityRmiInterface myEntityRMI;
    protected ClientPrimaryDataEntityVersion currentVersion = null;

    public ClientPrimaryDataEntity(PrimaryDataEntityRmiInterface entity, ClientDataManager client) {
        super(client);
        this.myEntityRMI = entity;
    }

    public void addPublicReference(PersistentIdentifier identifierType) throws RemoteException, PrimaryDataEntityException {
        this.myEntityRMI.addPublicReference(identifierType, this.clientDataManager.getSubject());
        this.currentVersion = this.getVersions().last();
    }

    public void delete() throws RemoteException, PrimaryDataEntityVersionException, PrimaryDataDirectoryException {
        this.myEntityRMI.delete(this.clientDataManager.getSubject());
    }

    public ClientPrimaryDataEntityVersion getCurrentVersion() throws RemoteException {
        if (this.currentVersion == null) {
            return new ClientPrimaryDataEntityVersion(this.myEntityRMI.getCurrentVersion(this.clientDataManager.getSubject()), this.clientDataManager);
        }
        return this.currentVersion;
    }

    public String getID() throws RemoteException {
        return this.myEntityRMI.getID(this.clientDataManager.getSubject());
    }

    public MetaData getMetaData() throws RemoteException {
        return this.myEntityRMI.getMetaData(this.clientDataManager.getSubject());
    }

    public String getName() throws RemoteException {
        return this.myEntityRMI.getName(this.clientDataManager.getSubject());
    }

    public ClientPrimaryDataDirectory getParentDirectory() throws PrimaryDataDirectoryException, RemoteException {
        return new ClientPrimaryDataDirectory(this.myEntityRMI.getParentDirectory(this.clientDataManager.getSubject()), this.clientDataManager);
    }

    public String getPath() throws RemoteException {
        return this.myEntityRMI.getPath(this.clientDataManager.getSubject());
    }

    public Map<Principal, List<GrantableMethods.Methods>> getPermissions() throws RemoteException, PrimaryDataEntityException {
        return this.myEntityRMI.getPermissions(this.clientDataManager.getSubject());
    }

    public List<PublicReference> getPublicReferences() throws RemoteException {
        return this.myEntityRMI.getPublicReferences(this.clientDataManager.getSubject());
    }

    public SortedSet<ClientPrimaryDataEntityVersion> getVersions() throws RemoteException {
        TreeSet<ClientPrimaryDataEntityVersion> externalSet = new TreeSet<ClientPrimaryDataEntityVersion>();
        for (PrimaryDataEntityVersionRmiInterface primaryDataEntityVersionRMI : this.myEntityRMI.getVersions(this.clientDataManager.getSubject())) {
            externalSet.add(new ClientPrimaryDataEntityVersion(primaryDataEntityVersionRMI, this.clientDataManager));
        }
        return externalSet;
    }

    public ClientPrimaryDataEntityVersion getVersionByDate(Calendar date) throws RemoteException, PrimaryDataEntityVersionException {
        return new ClientPrimaryDataEntityVersion(this.myEntityRMI.getVersionByDate(date, this.clientDataManager.getSubject()), this.clientDataManager);
    }

    public ClientPrimaryDataEntityVersion getVersionByRevisionNumber(long revisionNumber) throws RemoteException, PrimaryDataEntityVersionException {
        return new ClientPrimaryDataEntityVersion(this.myEntityRMI.getVersionByRevisionNumber(revisionNumber, this.clientDataManager.getSubject()), this.clientDataManager);
    }

    public void grantPermission(Principal principal, GrantableMethods.Methods method) throws RemoteException, PrimaryDataEntityException {
        this.myEntityRMI.grantPermission(principal, method, this.clientDataManager.getSubject());
    }

    public boolean isDirectory() throws RemoteException {
        return this.myEntityRMI.isDirectory(this.clientDataManager.getSubject());
    }

    public void move(ClientPrimaryDataDirectory destinationDirectory) throws RemoteException, PrimaryDataDirectoryException {
        this.myEntityRMI.move((PrimaryDataDirectoryRmiInterface)destinationDirectory.myEntityRMI, this.clientDataManager.getSubject());
    }

    public void rename(String name) throws RemoteException, PrimaryDataEntityVersionException, PrimaryDataDirectoryException {
        this.myEntityRMI.rename(name, this.clientDataManager.getSubject());
        this.currentVersion = this.getVersions().last();
    }

    public void revokePermission(Principal principal, GrantableMethods.Methods method) throws RemoteException, PrimaryDataEntityException {
        this.myEntityRMI.revokePermission(principal, method, this.clientDataManager.getSubject());
    }

    public void setMetaData(MetaData new_metadata) throws RemoteException, PrimaryDataEntityVersionException, MetaDataException {
        this.myEntityRMI.setMetaData(new_metadata, this.clientDataManager.getSubject());
    }

    public void switchCurrentVersion(ClientPrimaryDataEntityVersion version) throws RemoteException, PrimaryDataEntityVersionException {
        if (!this.getVersions().contains(version)) {
            throw new PrimaryDataEntityVersionException("Requested version not available !");
        }
        if (!this.getVersions().last().equals(version) && this.getVersions().last().isDeleted()) {
            throw new PrimaryDataEntityVersionException("Requested version is marked as deleted !");
        }
        this.currentVersion = version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        try {
            result = 31 * result + (this.getID() == null ? 0 : this.getID().hashCode());
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean equals(Object obj) {
        try {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ClientPrimaryDataEntity)) {
                return false;
            }
            ClientPrimaryDataEntity other = (ClientPrimaryDataEntity)obj;
            if (this.getID() == null ? other.getID() != null : !this.getID().equals(other.getID())) {
                return false;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public int compareTo(ClientPrimaryDataEntity other) {
        try {
            return this.getName().compareToIgnoreCase(other.getName());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }
}

