/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui;

import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalLoginHelper;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.StackTraceUtil;
import de.ipk_gatersleben.bit.bi.edal.rmi.server.Authentication;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class EdalConfigDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    public int returnvalue;
    public static ClientDataManager client;
    public static ClientPrimaryDataDirectory rootDirectory;
    private boolean islogin = false;
    private JPanel detialpanel = new JPanel();
    private JButton savebtn;
    private JButton cancelbtn;
    private JLabel infolabel;
    private Action okAction = new AbstractAction("Save"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            EdalConfigDialog.this.infolabel.setText("");
            if (!EdalConfigDialog.this.checkerror()) {
                return;
            }
            if (EdalConfigDialog.this.loginremoteserver(EdalConfigDialog.this.getServeraddress(), EdalConfigDialog.this.getServerport(), EdalConfigDialog.this.getUsername(), EdalConfigDialog.this.getPassword())) {
                EdalConfigDialog.this.returnvalue = 0;
                EdalConfigDialog.this.dispose();
            }
        }
    };
    private Action cancelAction = new AbstractAction("Cancel"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            EdalConfigDialog.this.returnvalue = 1;
            EdalConfigDialog.this.dispose();
        }
    };
    private JLabel serveraddresslabel;
    private JTextField serveraddresstxt;
    private JLabel serverportlabel;
    private JTextField serverporttxt;
    private JLabel serverusernamelabel;
    private JTextField serverusernametxt;
    private JLabel serverpasswordlabel;
    private JTextField serverpasswordtxt;

    public EdalConfigDialog() {
        this.addWindowListener(this.createAppCloser());
        this.setTitle("eDAL Configuration");
        JPanel contents = (JPanel)this.getContentPane();
        contents.setLayout(new BorderLayout());
        double[][] detailsize = new double[][]{{0.1, 0.3, 0.5, 0.1}, {5.0, 30.0, 5.0, 30.0, 5.0, 30.0, 5.0, 30.0, 30.0}};
        TableLayout detaillayout = new TableLayout((double[][])detailsize);
        this.detialpanel.setLayout((LayoutManager)detaillayout);
        this.serveraddresslabel = new JLabel("Server Address:");
        this.detialpanel.add((Component)this.serveraddresslabel, "1,1");
        this.serveraddresstxt = new JTextField();
        this.detialpanel.add((Component)this.serveraddresstxt, "2,1");
        this.serverportlabel = new JLabel("Server Port:");
        this.detialpanel.add((Component)this.serverportlabel, "1,3");
        this.serverporttxt = new JTextField();
        this.detialpanel.add((Component)this.serverporttxt, "2,3");
        this.serverusernamelabel = new JLabel("User Name:");
        this.detialpanel.add((Component)this.serverusernamelabel, "1,5");
        this.serverusernametxt = new JTextField();
        this.detialpanel.add((Component)this.serverusernametxt, "2,5");
        this.serverpasswordlabel = new JLabel("Password:");
        this.detialpanel.add((Component)this.serverpasswordlabel, "1,7");
        this.serverpasswordtxt = new JPasswordField();
        this.detialpanel.add((Component)this.serverpasswordtxt, "2,7");
        this.infolabel = new JLabel("");
        this.infolabel.setForeground(Color.RED);
        this.detialpanel.add((Component)this.infolabel, "1,8,2,8");
        contents.add((Component)this.detialpanel, "Center");
        contents.add((Component)this.createbuttonpanel(), "South");
        EdalLoginHelper helper = new EdalLoginHelper();
        helper.initdata(this.serveraddresstxt, this.serverporttxt, this.serverusernametxt, this.serverpasswordtxt);
        this.setSize(new Dimension(400, 247));
    }

    public String getServeraddress() {
        return this.serveraddresstxt.getText().trim();
    }

    public int getServerport() {
        return Integer.parseInt(this.serverporttxt.getText().trim());
    }

    public String getUsername() {
        return this.serverusernametxt.getText().trim();
    }

    public String getPassword() {
        return this.serverpasswordtxt.getText().trim();
    }

    public int showOpenDialog() {
        this.setModal(true);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        return this.returnvalue;
    }

    private JPanel createbuttonpanel() {
        this.savebtn = new JButton(this.okAction);
        this.cancelbtn = new JButton(this.cancelAction);
        JPanel buttonPane = new JPanel(new FlowLayout(1, 5, 5));
        buttonPane.add(this.savebtn);
        buttonPane.add(this.cancelbtn);
        this.getRootPane().setDefaultButton(this.savebtn);
        return buttonPane;
    }

    private boolean checkerror() {
        String serveraddresstxtText = this.serveraddresstxt.getText();
        if (serveraddresstxtText.trim().length() == 0) {
            this.mustfill(this.serveraddresslabel);
            JOptionPane.showMessageDialog(null, "Please input Server Address!", "eDAL Configuration", 0);
            return false;
        }
        this.resetfill(this.serveraddresslabel);
        String serverporttxtText = this.serverporttxt.getText();
        if (serverporttxtText.trim().length() == 0) {
            this.mustfill(this.serverportlabel);
            JOptionPane.showMessageDialog(null, "Please input Server Port!", "eDAL Configuration", 0);
            return false;
        }
        this.resetfill(this.serverportlabel);
        try {
            Integer.parseInt(serverporttxtText.trim());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Server Port should be Integer!", "eDAL Configuration", 0);
            return false;
        }
        String serverusernametxtText = this.serverusernametxt.getText();
        if (serverusernametxtText.trim().length() == 0) {
            this.mustfill(this.serverusernamelabel);
            JOptionPane.showMessageDialog(null, "Please input User Name!", "eDAL Configuration", 0);
            return false;
        }
        this.resetfill(this.serverusernamelabel);
        String serverpasswordtxtText = this.serverpasswordtxt.getText();
        if (serverpasswordtxtText.trim().length() == 0) {
            this.mustfill(this.serverpasswordlabel);
            JOptionPane.showMessageDialog(null, "Please input Password!", "eDAL Configuration", 0);
            return false;
        }
        this.resetfill(this.serverpasswordlabel);
        return true;
    }

    private void resetfill(JLabel label) {
        label.setForeground(Color.BLACK);
        String originaltext = label.getText();
        if (originaltext.startsWith("*")) {
            originaltext = originaltext.substring(1);
        }
        label.setText(originaltext);
    }

    private void mustfill(JLabel label) {
        label.setForeground(Color.RED);
        label.setText("*" + label.getText());
    }

    private boolean loginremoteserver(String serveraddress, int serverport, String username, String password) {
        try {
            Authentication auth = new Authentication(username, password);
            client = new ClientDataManager(serverport, serveraddress, auth);
            rootDirectory = client.getRootDirectory();
            this.islogin = true;
            EdalLoginHelper.client = client;
            EdalLoginHelper.rootDirectory = rootDirectory;
        }
        catch (Exception e) {
            this.islogin = false;
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
            this.infolabel.setText(e.getMessage());
        }
        return this.islogin;
    }

    private WindowListener createAppCloser() {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                EdalConfigDialog.this.returnvalue = 1;
                EdalConfigDialog.this.dispose();
            }
        };
    }
}

