/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDate;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDatePrecision;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalDateFormat;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.ImageUtil;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EdalDateTimePicker
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Font FONT = new Font("Courier New", 0, 12);
    private DateChooser dateChooser = null;
    private Calendar showcalendar;
    private Calendar _calendar;
    private EdalDatePrecision showprecision;
    private EdalDatePrecision _precision;
    private JTextField text;
    private JLabel label;

    public EdalDateTimePicker(EdalDate edaldate) {
        if (edaldate != null) {
            this.showcalendar = edaldate.getStartDate();
            this.showprecision = edaldate.getStartPrecision();
        } else {
            this.showcalendar = Calendar.getInstance();
            this.showprecision = EdalDatePrecision.SECOND;
        }
        this.setBorder(null);
        this.setCursor(new Cursor(12));
        double[][] mainsize = new double[][]{{0.8, 0.2}, {24.0}};
        TableLayout mainlayout = new TableLayout((double[][])mainsize);
        this.setLayout((LayoutManager)mainlayout);
        this.text = new JTextField();
        this.text.setHorizontalAlignment(0);
        this.text.setEditable(false);
        this.add((Component)this.text, "0,0");
        ImageIcon icon = ImageUtil.createImageIcon("dateIcon.gif", "choose new datetime");
        this.label = new JLabel(icon);
        this.label.setToolTipText("choose new datetime");
        this.add((Component)this.label, "1,0");
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (EdalDateTimePicker.this.dateChooser == null) {
                    EdalDateTimePicker.this.dateChooser = new DateChooser();
                }
                Point p = EdalDateTimePicker.this.getLocationOnScreen();
                p.y += 30;
                EdalDateTimePicker.this.dateChooser.showDateChooser(p);
            }
        });
    }

    public void reset() {
        this.showcalendar = Calendar.getInstance();
        this.showprecision = EdalDatePrecision.SECOND;
        this.text.setText("");
    }

    public Calendar getCalendar() {
        return this._calendar;
    }

    public EdalDatePrecision getPrecision() {
        return this._precision;
    }

    private void setDate(Date date) {
        this.text.setText(EdalDateFormat.getDefaultDateFormat(this.showprecision).format(date));
    }

    private Date getDate() {
        return this.showcalendar.getTime();
    }

    private class DateChooser
    extends JPanel
    implements ActionListener,
    ChangeListener,
    MouseListener {
        private static final long serialVersionUID = 1L;
        int startYear = 1;
        int lastYear = 5000;
        int width = 750;
        int height = 280;
        Color backGroundColor = Color.gray;
        Color palletTableColor = Color.white;
        Color todayBackColor = Color.orange;
        Color weekFontColor = Color.blue;
        Color dateFontColor = Color.black;
        Color weekendFontColor = Color.red;
        Color controlLineColor = Color.pink;
        Color controlTextColor = Color.white;
        JDialog dialog;
        JSpinner yearSpin;
        JSpinner monthSpin;
        JSpinner daySpin;
        JSpinner hourSpin;
        JSpinner minuteSpin;
        JSpinner secondSpin;
        JSpinner millisecondSpin;
        JButton[][] daysButton = new JButton[6][7];
        private Action okAction = new AbstractAction("Ok"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                EdalDateTimePicker.this._calendar = EdalDateTimePicker.this.showcalendar;
                EdalDateTimePicker.this._precision = EdalDateTimePicker.this.showprecision;
                DateChooser.this.refreshtime();
                EdalDateTimePicker.this.setDate(EdalDateTimePicker.this.showcalendar.getTime());
                DateChooser.this.dialog.setVisible(false);
            }
        };
        private Action cancelAction = new AbstractAction("Cancel"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DateChooser.this.dialog.setVisible(false);
            }
        };

        DateChooser() {
            this.setLayout(new BorderLayout());
            this.setBorder(new LineBorder(this.backGroundColor, 2));
            this.setBackground(this.backGroundColor);
            JPanel mainPane = new JPanel();
            mainPane.setLayout(new BorderLayout());
            JPanel toppanel = this.createprecisionPanel();
            mainPane.add((Component)toppanel, "North");
            JPanel controlpanel = this.createYearAndMonthPanel();
            mainPane.add((Component)controlpanel, "Center");
            JPanel displaypanel = this.createWeekAndDayPanel();
            mainPane.add((Component)displaypanel, "South");
            JPanel buttonPane = new JPanel(new FlowLayout(1, 5, 5));
            JButton savebtn = new JButton(this.okAction);
            JButton cancelbtn = new JButton(this.cancelAction);
            buttonPane.add(savebtn);
            buttonPane.add(cancelbtn);
            this.add((Component)mainPane, "Center");
            this.add((Component)buttonPane, "South");
        }

        private JPanel createprecisionPanel() {
            JPanel result = new JPanel();
            result.setLayout(new FlowLayout());
            ButtonGroup g = new ButtonGroup();
            JRadioButton centuryrb = new JRadioButton("CENTURY");
            if (EdalDateTimePicker.this.showprecision != null && EdalDateTimePicker.this.showprecision.equals((Object)EdalDatePrecision.CENTURY)) {
                centuryrb.setSelected(true);
            }
            centuryrb.addActionListener(this);
            g.add(centuryrb);
            result.add(centuryrb);
            JRadioButton decaderb = new JRadioButton("DECADE");
            if (EdalDateTimePicker.this.showprecision != null && EdalDateTimePicker.this.showprecision.equals((Object)EdalDatePrecision.DECADE)) {
                decaderb.setSelected(true);
            }
            decaderb.addActionListener(this);
            g.add(decaderb);
            result.add(decaderb);
            JRadioButton yearrb = new JRadioButton("YEAR");
            if (EdalDateTimePicker.this.showprecision != null && EdalDateTimePicker.this.showprecision.equals((Object)EdalDatePrecision.YEAR)) {
                yearrb.setSelected(true);
            }
            yearrb.addActionListener(this);
            g.add(yearrb);
            result.add(yearrb);
            JRadioButton monthrb = new JRadioButton("MONTH");
            if (EdalDateTimePicker.this.showprecision != null && EdalDateTimePicker.this.showprecision.equals((Object)EdalDatePrecision.MONTH)) {
                monthrb.setSelected(true);
            }
            monthrb.addActionListener(this);
            g.add(monthrb);
            result.add(monthrb);
            JRadioButton dayrb = new JRadioButton("DAY");
            if (EdalDateTimePicker.this.showprecision != null && EdalDateTimePicker.this.showprecision.equals((Object)EdalDatePrecision.DAY)) {
                dayrb.setSelected(true);
            }
            dayrb.addActionListener(this);
            g.add(dayrb);
            result.add(dayrb);
            JRadioButton hourrb = new JRadioButton("HOUR");
            if (EdalDateTimePicker.this.showprecision != null && EdalDateTimePicker.this.showprecision.equals((Object)EdalDatePrecision.HOUR)) {
                hourrb.setSelected(true);
            }
            hourrb.addActionListener(this);
            g.add(hourrb);
            result.add(hourrb);
            JRadioButton minuterb = new JRadioButton("MINUTE");
            if (EdalDateTimePicker.this.showprecision != null && EdalDateTimePicker.this.showprecision.equals((Object)EdalDatePrecision.MINUTE)) {
                minuterb.setSelected(true);
            }
            minuterb.addActionListener(this);
            g.add(minuterb);
            result.add(minuterb);
            JRadioButton secondrb = new JRadioButton("SECOND");
            if (EdalDateTimePicker.this.showprecision != null && EdalDateTimePicker.this.showprecision.equals((Object)EdalDatePrecision.SECOND)) {
                secondrb.setSelected(true);
            }
            secondrb.addActionListener(this);
            g.add(secondrb);
            result.add(secondrb);
            JRadioButton millisecondrb = new JRadioButton("MILLISECOND");
            if (EdalDateTimePicker.this.showprecision != null && EdalDateTimePicker.this.showprecision.equals((Object)EdalDatePrecision.MILLISECOND)) {
                millisecondrb.setSelected(true);
            }
            millisecondrb.addActionListener(this);
            g.add(millisecondrb);
            result.add(millisecondrb);
            if (EdalDateTimePicker.this.showprecision == null) {
                secondrb.setSelected(true);
            }
            return result;
        }

        private JPanel createYearAndMonthPanel() {
            Calendar c = this.getCalendar();
            int currentYear = c.get(1);
            int currentMonth = c.get(2) + 1;
            int currentday = c.get(5);
            int currentHour = c.get(11);
            int currentMinute = c.get(12);
            int currentSecond = c.get(13);
            int currentMillisecond = c.get(14);
            JPanel result = new JPanel();
            result.setLayout(new FlowLayout());
            result.setBackground(this.controlLineColor);
            JLabel yearLabel = new JLabel("Year");
            yearLabel.setForeground(this.controlTextColor);
            result.add(yearLabel);
            this.yearSpin = new JSpinner(new SpinnerNumberModel(currentYear, this.startYear, this.lastYear, 1));
            this.yearSpin.setPreferredSize(new Dimension(64, 24));
            this.yearSpin.setName("Year");
            this.yearSpin.setEditor(new JSpinner.NumberEditor(this.yearSpin, "####"));
            this.yearSpin.addChangeListener(this);
            result.add(this.yearSpin);
            JLabel monthLabel = new JLabel("Month");
            monthLabel.setForeground(this.controlTextColor);
            result.add(monthLabel);
            this.monthSpin = new JSpinner(new SpinnerNumberModel(currentMonth, 1, 12, 1));
            this.monthSpin.setPreferredSize(new Dimension(50, 24));
            this.monthSpin.setName("Month");
            this.monthSpin.addChangeListener(this);
            result.add(this.monthSpin);
            JLabel dayLabel = new JLabel("Day");
            dayLabel.setForeground(this.controlTextColor);
            result.add(dayLabel);
            this.daySpin = new JSpinner(this.getdaymodel(currentYear, currentMonth, currentday));
            this.daySpin.setPreferredSize(new Dimension(50, 24));
            this.daySpin.setName("Day");
            this.daySpin.addChangeListener(this);
            result.add(this.daySpin);
            JLabel hourLabel = new JLabel("Hour");
            hourLabel.setForeground(this.controlTextColor);
            result.add(hourLabel);
            this.hourSpin = new JSpinner(new SpinnerNumberModel(currentHour, 0, 23, 1));
            this.hourSpin.setPreferredSize(new Dimension(50, 24));
            this.hourSpin.setName("Hour");
            this.hourSpin.addChangeListener(this);
            result.add(this.hourSpin);
            JLabel minuteLabel = new JLabel("Minute");
            minuteLabel.setForeground(this.controlTextColor);
            result.add(minuteLabel);
            this.minuteSpin = new JSpinner(new SpinnerNumberModel(currentMinute, 0, 59, 1));
            this.minuteSpin.setPreferredSize(new Dimension(50, 24));
            this.minuteSpin.setName("Minute");
            this.minuteSpin.addChangeListener(this);
            result.add(this.minuteSpin);
            JLabel secondLabel = new JLabel("Second");
            secondLabel.setForeground(this.controlTextColor);
            result.add(secondLabel);
            this.secondSpin = new JSpinner(new SpinnerNumberModel(currentSecond, 0, 59, 1));
            this.secondSpin.setPreferredSize(new Dimension(50, 24));
            this.secondSpin.setName("Second");
            this.secondSpin.addChangeListener(this);
            result.add(this.secondSpin);
            JLabel millisecondLabel = new JLabel("Millisecond");
            millisecondLabel.setForeground(this.controlTextColor);
            result.add(millisecondLabel);
            this.millisecondSpin = new JSpinner(new SpinnerNumberModel(currentMillisecond, 0, 999, 1));
            this.millisecondSpin.setPreferredSize(new Dimension(55, 24));
            this.millisecondSpin.setName("Millisecond");
            this.millisecondSpin.addChangeListener(this);
            result.add(this.millisecondSpin);
            return result;
        }

        private SpinnerNumberModel getdaymodel(int currentYear, int currentMonth, int currentday) {
            int minday = 1;
            int maxday = 30;
            if (currentMonth == 1 || currentMonth == 3 || currentMonth == 5 || currentMonth == 7 || currentMonth == 8 || currentMonth == 10 || currentMonth == 12) {
                maxday = 31;
            } else if (currentMonth == 2) {
                maxday = this.isleapyear(currentYear) ? 29 : 28;
            }
            return new SpinnerNumberModel(currentday, minday, maxday, 1);
        }

        private boolean isleapyear(int year) {
            return year % 100 == 0 ? year % 400 == 0 : year % 4 == 0;
        }

        private JPanel createWeekAndDayPanel() {
            String[] colname = new String[]{"Sunday", "Monday", "Tuesday ", "Wednesday", "Thursday", "Friday", "Saturday "};
            JPanel result = new JPanel();
            result.setFont(FONT);
            result.setLayout(new GridLayout(7, 7));
            result.setBackground(Color.white);
            for (int i = 0; i < 7; ++i) {
                JLabel cell = new JLabel(colname[i]);
                cell.setHorizontalAlignment(0);
                if (i == 0 || i == 6) {
                    cell.setForeground(this.weekendFontColor);
                } else {
                    cell.setForeground(this.weekFontColor);
                }
                result.add(cell);
            }
            int actionCommandId = 0;
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 7; ++j) {
                    JButton numberButton = new JButton();
                    numberButton.setBorder(null);
                    numberButton.setHorizontalAlignment(0);
                    numberButton.setActionCommand(String.valueOf(actionCommandId));
                    numberButton.addActionListener(this);
                    numberButton.addMouseListener(this);
                    numberButton.setBackground(this.palletTableColor);
                    numberButton.setForeground(this.dateFontColor);
                    if (j == 0 || j == 6) {
                        numberButton.setForeground(this.weekendFontColor);
                    } else {
                        numberButton.setForeground(this.dateFontColor);
                    }
                    this.daysButton[i][j] = numberButton;
                    result.add(numberButton);
                    ++actionCommandId;
                }
            }
            return result;
        }

        private JDialog createDialog(Frame owner) {
            JDialog result = new JDialog(owner, "DatetimePicker", true);
            result.addWindowListener(this.createAppCloser());
            result.getContentPane().add((Component)this, "Center");
            result.pack();
            result.setSize(this.width, this.height);
            return result;
        }

        private JDialog createDialog(JDialog owner) {
            JDialog result = new JDialog(owner, "DatetimePicker", true);
            result.addWindowListener(this.createAppCloser());
            result.getContentPane().add((Component)this, "Center");
            result.pack();
            result.setSize(this.width, this.height);
            return result;
        }

        void showDateChooser(Point position) {
            if (SwingUtilities.getWindowAncestor(EdalDateTimePicker.this) != null && SwingUtilities.getWindowAncestor(EdalDateTimePicker.this) instanceof JDialog) {
                JDialog owner = (JDialog)SwingUtilities.getWindowAncestor(EdalDateTimePicker.this);
                if (this.dialog == null || this.dialog.getOwner() != owner) {
                    this.dialog = this.createDialog(owner);
                }
                this.dialog.setLocation(this.getAppropriateLocation(owner, position));
            } else {
                Frame owner = (Frame)SwingUtilities.getWindowAncestor(EdalDateTimePicker.this);
                if (this.dialog == null || this.dialog.getOwner() != owner) {
                    this.dialog = this.createDialog(owner);
                }
                this.dialog.setLocation(this.getAppropriateLocation(owner, position));
            }
            this.flushWeekAndDay();
            this.dialog.setVisible(true);
        }

        Point getAppropriateLocation(Frame owner, Point position) {
            Point result = new Point(position);
            Point p = owner.getLocation();
            int offsetX = position.x + this.width - (p.x + owner.getWidth());
            int offsetY = position.y + this.height - (p.y + owner.getHeight());
            if (offsetX > 0) {
                result.x -= offsetX;
            }
            if (offsetY > 0) {
                result.y -= offsetY;
            }
            return result;
        }

        Point getAppropriateLocation(JDialog owner, Point position) {
            Point result = new Point(position);
            Point p = owner.getLocation();
            int offsetX = position.x + this.width - (p.x + owner.getWidth());
            int offsetY = position.y + this.height - (p.y + owner.getHeight());
            if (offsetX > 0) {
                result.x -= offsetX;
            }
            if (offsetY > 0) {
                result.y -= offsetY;
            }
            return result;
        }

        private Calendar getCalendar() {
            if (EdalDateTimePicker.this.showcalendar == null) {
                EdalDateTimePicker.this.showcalendar = Calendar.getInstance();
            }
            EdalDateTimePicker.this.showcalendar.setTime(EdalDateTimePicker.this.getDate());
            return EdalDateTimePicker.this.showcalendar;
        }

        private int getSelectedYear() {
            return (Integer)this.yearSpin.getValue();
        }

        private int getSelectedMonth() {
            return (Integer)this.monthSpin.getValue();
        }

        private int getSelectedDay() {
            return (Integer)this.daySpin.getValue();
        }

        private int getSelectedHour() {
            return (Integer)this.hourSpin.getValue();
        }

        private int getSelectedMinite() {
            return (Integer)this.minuteSpin.getValue();
        }

        private int getSelectedSecond() {
            return (Integer)this.secondSpin.getValue();
        }

        private int getSelectedMillisecond() {
            return (Integer)this.millisecondSpin.getValue();
        }

        private void flushWeekAndDay() {
            Calendar c = this.getCalendar();
            c.set(5, 1);
            int maxDayNo = c.getActualMaximum(5);
            int dayNo = 2 - c.get(7);
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 7; ++j) {
                    String s = "";
                    if (dayNo >= 1 && dayNo <= maxDayNo) {
                        s = String.valueOf(dayNo);
                    }
                    this.daysButton[i][j].setText(s);
                    ++dayNo;
                    if (j == 0 || j == 6) {
                        this.daysButton[i][j].setForeground(this.weekendFontColor);
                        continue;
                    }
                    this.daysButton[i][j].setForeground(this.dateFontColor);
                }
            }
        }

        private void refreshdayspin(int currentYear, int currentMonth, int currentday) {
            this.daySpin.setModel(this.getdaymodel(currentYear, currentMonth, currentday));
            this.daySpin.updateUI();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSpinner source = (JSpinner)e.getSource();
            Calendar c = this.getCalendar();
            if (source.getName().equals("Hour")) {
                c.set(11, this.getSelectedHour());
                EdalDateTimePicker.this.setDate(c.getTime());
                return;
            }
            if (source.getName().equals("Minute")) {
                c.set(12, this.getSelectedMinite());
                EdalDateTimePicker.this.setDate(c.getTime());
                return;
            }
            if (source.getName().equals("Second")) {
                c.set(13, this.getSelectedSecond());
                EdalDateTimePicker.this.setDate(c.getTime());
                return;
            }
            if (source.getName().equals("Millisecond")) {
                c.set(14, this.getSelectedMillisecond());
                EdalDateTimePicker.this.setDate(c.getTime());
                return;
            }
            if (source.getName().equals("Year")) {
                c.set(1, this.getSelectedYear());
                this.refreshdayspin(this.getSelectedYear(), this.getSelectedMonth(), this.getSelectedDay());
            } else if (source.getName().equals("Month")) {
                c.set(2, this.getSelectedMonth() - 1);
                this.refreshdayspin(this.getSelectedYear(), this.getSelectedMonth(), this.getSelectedDay());
            }
            EdalDateTimePicker.this.setDate(c.getTime());
            this.flushWeekAndDay();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JRadioButton source;
            String classname = e.getSource().getClass().getName();
            if (classname.equals("javax.swing.JButton")) {
                JButton source2 = (JButton)e.getSource();
                if (source2.getText().length() == 0) {
                    return;
                }
                source2.setForeground(this.todayBackColor);
                int newDay = Integer.parseInt(source2.getText());
                this.daySpin.setValue(newDay);
            } else if (classname.equals("javax.swing.JRadioButton") && (source = (JRadioButton)e.getSource()).isSelected()) {
                if (source.getText().equals("CENTURY")) {
                    this.monthSpin.setEnabled(false);
                    this.daySpin.setEnabled(false);
                    this.hourSpin.setEnabled(false);
                    this.minuteSpin.setEnabled(false);
                    this.secondSpin.setEnabled(false);
                    this.millisecondSpin.setEnabled(false);
                    this.enabledisplaybuttons(false);
                    EdalDateTimePicker.this.showprecision = EdalDatePrecision.CENTURY;
                } else if (source.getText().equals("DECADE")) {
                    this.monthSpin.setEnabled(false);
                    this.daySpin.setEnabled(false);
                    this.hourSpin.setEnabled(false);
                    this.minuteSpin.setEnabled(false);
                    this.secondSpin.setEnabled(false);
                    this.millisecondSpin.setEnabled(false);
                    this.enabledisplaybuttons(false);
                    EdalDateTimePicker.this.showprecision = EdalDatePrecision.DECADE;
                } else if (source.getText().equals("YEAR")) {
                    this.monthSpin.setEnabled(false);
                    this.daySpin.setEnabled(false);
                    this.hourSpin.setEnabled(false);
                    this.minuteSpin.setEnabled(false);
                    this.secondSpin.setEnabled(false);
                    this.millisecondSpin.setEnabled(false);
                    this.enabledisplaybuttons(false);
                    EdalDateTimePicker.this.showprecision = EdalDatePrecision.YEAR;
                } else if (source.getText().equals("MONTH")) {
                    this.yearSpin.setEnabled(true);
                    this.monthSpin.setEnabled(true);
                    this.daySpin.setEnabled(false);
                    this.hourSpin.setEnabled(false);
                    this.minuteSpin.setEnabled(false);
                    this.secondSpin.setEnabled(false);
                    this.millisecondSpin.setEnabled(false);
                    this.enabledisplaybuttons(false);
                    EdalDateTimePicker.this.showprecision = EdalDatePrecision.MONTH;
                } else if (source.getText().equals("DAY")) {
                    this.yearSpin.setEnabled(true);
                    this.monthSpin.setEnabled(true);
                    this.daySpin.setEnabled(true);
                    this.hourSpin.setEnabled(false);
                    this.minuteSpin.setEnabled(false);
                    this.secondSpin.setEnabled(false);
                    this.millisecondSpin.setEnabled(false);
                    this.enabledisplaybuttons(true);
                    EdalDateTimePicker.this.showprecision = EdalDatePrecision.DAY;
                } else if (source.getText().equals("HOUR")) {
                    this.yearSpin.setEnabled(true);
                    this.monthSpin.setEnabled(true);
                    this.daySpin.setEnabled(true);
                    this.hourSpin.setEnabled(true);
                    this.minuteSpin.setEnabled(false);
                    this.secondSpin.setEnabled(false);
                    this.millisecondSpin.setEnabled(false);
                    this.enabledisplaybuttons(true);
                    EdalDateTimePicker.this.showprecision = EdalDatePrecision.HOUR;
                } else if (source.getText().equals("MINUTE")) {
                    this.yearSpin.setEnabled(true);
                    this.monthSpin.setEnabled(true);
                    this.daySpin.setEnabled(true);
                    this.hourSpin.setEnabled(true);
                    this.minuteSpin.setEnabled(true);
                    this.secondSpin.setEnabled(false);
                    this.millisecondSpin.setEnabled(false);
                    this.enabledisplaybuttons(true);
                    EdalDateTimePicker.this.showprecision = EdalDatePrecision.MINUTE;
                } else if (source.getText().equals("SECOND")) {
                    this.yearSpin.setEnabled(true);
                    this.monthSpin.setEnabled(true);
                    this.daySpin.setEnabled(true);
                    this.hourSpin.setEnabled(true);
                    this.minuteSpin.setEnabled(true);
                    this.secondSpin.setEnabled(true);
                    this.millisecondSpin.setEnabled(false);
                    this.enabledisplaybuttons(true);
                    EdalDateTimePicker.this.showprecision = EdalDatePrecision.SECOND;
                } else if (source.getText().equals("MILLISECOND")) {
                    this.yearSpin.setEnabled(true);
                    this.monthSpin.setEnabled(true);
                    this.daySpin.setEnabled(true);
                    this.hourSpin.setEnabled(true);
                    this.minuteSpin.setEnabled(true);
                    this.secondSpin.setEnabled(true);
                    this.millisecondSpin.setEnabled(true);
                    this.enabledisplaybuttons(true);
                    EdalDateTimePicker.this.showprecision = EdalDatePrecision.MILLISECOND;
                }
            }
        }

        private void enabledisplaybuttons(boolean enable) {
            for (int i = 0; i < this.daysButton.length; ++i) {
                for (int j = 0; j < this.daysButton[i].length; ++j) {
                    this.daysButton[i][j].setEnabled(enable);
                }
            }
        }

        private int formatyeartocentury(int year) {
            if (year < 100) {
                return 0;
            }
            int century = year / 100;
            return century * 100;
        }

        private int formatyeartodecade(int year) {
            if (year < 10) {
                return 0;
            }
            int century = year / 10;
            return century * 10;
        }

        private void refreshtime() {
            if (EdalDateTimePicker.this.showcalendar == null) {
                EdalDateTimePicker.this.showcalendar = this.getCalendar();
            }
            if (EdalDateTimePicker.this.showprecision != null && EdalDateTimePicker.this.showprecision.equals((Object)EdalDatePrecision.CENTURY)) {
                EdalDateTimePicker.this.showcalendar.set(1, this.formatyeartocentury(this.getSelectedYear()));
            } else if (EdalDateTimePicker.this.showprecision != null && EdalDateTimePicker.this.showprecision.equals((Object)EdalDatePrecision.DECADE)) {
                EdalDateTimePicker.this.showcalendar.set(1, this.formatyeartodecade(this.getSelectedYear()));
            } else if (EdalDateTimePicker.this.showprecision != null && EdalDateTimePicker.this.showprecision.equals((Object)EdalDatePrecision.YEAR)) {
                EdalDateTimePicker.this.showcalendar.set(1, this.getSelectedYear());
            } else if (EdalDateTimePicker.this.showprecision != null && EdalDateTimePicker.this.showprecision.equals((Object)EdalDatePrecision.MONTH)) {
                EdalDateTimePicker.this.showcalendar.set(1, this.getSelectedYear());
                EdalDateTimePicker.this.showcalendar.set(2, this.getSelectedMonth() - 1);
            } else if (EdalDateTimePicker.this.showprecision != null && EdalDateTimePicker.this.showprecision.equals((Object)EdalDatePrecision.DAY)) {
                EdalDateTimePicker.this.showcalendar.set(1, this.getSelectedYear());
                EdalDateTimePicker.this.showcalendar.set(2, this.getSelectedMonth() - 1);
                EdalDateTimePicker.this.showcalendar.set(5, this.getSelectedDay());
            } else if (EdalDateTimePicker.this.showprecision != null && EdalDateTimePicker.this.showprecision.equals((Object)EdalDatePrecision.HOUR)) {
                EdalDateTimePicker.this.showcalendar.set(1, this.getSelectedYear());
                EdalDateTimePicker.this.showcalendar.set(2, this.getSelectedMonth() - 1);
                EdalDateTimePicker.this.showcalendar.set(5, this.getSelectedDay());
                EdalDateTimePicker.this.showcalendar.set(10, this.getSelectedHour());
            } else if (EdalDateTimePicker.this.showprecision != null && EdalDateTimePicker.this.showprecision.equals((Object)EdalDatePrecision.MINUTE)) {
                EdalDateTimePicker.this.showcalendar.set(1, this.getSelectedYear());
                EdalDateTimePicker.this.showcalendar.set(2, this.getSelectedMonth() - 1);
                EdalDateTimePicker.this.showcalendar.set(5, this.getSelectedDay());
                EdalDateTimePicker.this.showcalendar.set(11, this.getSelectedHour());
                EdalDateTimePicker.this.showcalendar.set(12, this.getSelectedMinite());
            } else if (EdalDateTimePicker.this.showprecision != null && EdalDateTimePicker.this.showprecision.equals((Object)EdalDatePrecision.SECOND)) {
                EdalDateTimePicker.this.showcalendar.set(1, this.getSelectedYear());
                EdalDateTimePicker.this.showcalendar.set(2, this.getSelectedMonth() - 1);
                EdalDateTimePicker.this.showcalendar.set(5, this.getSelectedDay());
                EdalDateTimePicker.this.showcalendar.set(11, this.getSelectedHour());
                EdalDateTimePicker.this.showcalendar.set(12, this.getSelectedMinite());
                EdalDateTimePicker.this.showcalendar.set(13, this.getSelectedSecond());
            } else if (EdalDateTimePicker.this.showprecision != null && EdalDateTimePicker.this.showprecision.equals((Object)EdalDatePrecision.MILLISECOND)) {
                EdalDateTimePicker.this.showcalendar.set(1, this.getSelectedYear());
                EdalDateTimePicker.this.showcalendar.set(2, this.getSelectedMonth() - 1);
                EdalDateTimePicker.this.showcalendar.set(5, this.getSelectedDay());
                EdalDateTimePicker.this.showcalendar.set(11, this.getSelectedHour());
                EdalDateTimePicker.this.showcalendar.set(12, this.getSelectedMinite());
                EdalDateTimePicker.this.showcalendar.set(13, this.getSelectedSecond());
                EdalDateTimePicker.this.showcalendar.set(14, this.getSelectedMillisecond());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JButton source = (JButton)e.getSource();
            if (source.getText().length() == 0) {
                return;
            }
            source.setForeground(this.todayBackColor);
            int newDay = Integer.parseInt(source.getText());
            Calendar c = this.getCalendar();
            c.set(5, newDay);
            EdalDateTimePicker.this.setDate(c.getTime());
            this.daySpin.setValue(newDay);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        private WindowListener createAppCloser() {
            return new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    DateChooser.this.dialog.setVisible(false);
                }
            };
        }
    }
}

