/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DateEvents;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDate;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.EdalConfigDialog;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.EdalMutableTreeModel;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.EdalNode;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.EdalTableModel;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.PermissionDialog;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.TreeWillExpandListenerAction;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor.MetaDataSaveDialog;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer.CheckSumViewer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer.DataFormatViewer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer.DateEventsViewer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer.IdentifierRelationViewer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer.IdentifierViewer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer.LanguageViewer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer.MetadataViewer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer.PersonInfoViewer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer.TextViewer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer.ViewerContainer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalAbstractFileFilter;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalFileHelper;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalLoginHelper;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalTable;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalTitleDialog;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalTreeCellRenderer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.InfiniteProgressPanel;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.JLinkLabel;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.JVersionLabel;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.LailapsJXTaskPane;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.MetaDescription;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.PrincipalUtil;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.StackTraceUtil;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.UiUtil;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.XStatusBar;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.security.AccessControlException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIDefaults;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;

public class EdalFileChooser
extends EdalTitleDialog {
    private static final long serialVersionUID = 1L;
    private static final Font FONT = new Font("Courier New", 0, 12);
    private DefaultTableModel defaultModel = null;
    private ClientPrimaryDataDirectory rootDirectory = null;
    private JTable filemetatable = null;
    private List<String> metadatatoshow = new ArrayList<String>();
    private List<ClientPrimaryDataEntity> filelist = new ArrayList<ClientPrimaryDataEntity>();
    private List<ClientPrimaryDataEntityVersion> versionlist = new ArrayList<ClientPrimaryDataEntityVersion>();
    private ClientPrimaryDataEntityVersion currentversion;
    private Map<String, ClientPrimaryDataEntityVersion> currentversionmap = new HashMap<String, ClientPrimaryDataEntityVersion>();
    private Map<String, JTextField> detailmap = new HashMap<String, JTextField>();
    private boolean bindui = false;
    private final JLabel pathlabel = new JLabel("Path:", 2);
    protected final JTextField pathtext = new JTextField();
    protected ClientPrimaryDataEntity selectedFile = null;
    private final JTextField searchtext = new JTextField();
    protected ClientPrimaryDataDirectory currentdir;
    private DefaultMutableTreeNode currentnode;
    protected JButton okbutton;
    private int returnvalue;
    private int[] selectrows;
    private EdalAbstractFileFilter fileFilter = null;
    private int fileSelectionMode = 0;
    private boolean savemodal = false;
    private int fileselectindex;
    private String username = null;
    private static final String CHANGEMETADATAMETHODNAME = "setMetaData";
    private static final String CHANGEPERMISSIONTHODNAME = "grantPermission";
    private JSplitPane dirshowpane;
    private JSplitPane tableshowpane;
    private JPanel detailpanelparent;
    private JScrollPane treepanelparent;
    private LailapsJXTaskPane versionpanel;
    private LailapsJXTaskPane detailpanel;
    private JTree tree;
    private JButton configbutton = new JButton("eDAL Configration");
    private JButton metadatabutton = new JButton("ChangeMetadata");
    private JButton permissionbutton = new JButton("ChangePermissions");
    private Color tablebackcolor = null;
    private XStatusBar statusbar = new XStatusBar();
    private JPanel centerPane = new JPanel();
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    public static final int ERROR_OPTION = -1;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    private static final int TEXTLIMIT = 40;
    private static final int TOOLTIPSLEN = 20;
    private static final int METADATALEN = 80;
    private boolean multiSelectionEnabled = false;
    private Map<String, String> tipsmap = new HashMap<String, String>();
    private int row;
    private int column;
    private ClientDataManager client = null;
    private Action cancelAction = new AbstractAction("Cancel"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            EdalFileChooser.this.selectedFile = null;
            EdalFileChooser.this.returnvalue = 1;
            EdalFileChooser.this.dispose();
        }
    };
    private Action searchAction = new AbstractAction("Search"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            EdalFileChooser.this.search(EdalFileChooser.this.searchtext.getText().trim());
        }
    };
    private JXTaskPaneContainer metainfocontainer;

    public EdalFileChooser(Frame owner, ClientPrimaryDataDirectory rootDirectory, ClientDataManager client) {
        super((Window)owner);
        this.rootDirectory = rootDirectory;
        if (client != null) {
            this.client = client;
            this.username = client.getAuthentication().getName();
        }
    }

    public EdalFileChooser(Dialog owner, ClientPrimaryDataDirectory rootDirectory, ClientDataManager client) {
        super((Window)owner);
        this.rootDirectory = rootDirectory;
        if (client != null) {
            this.client = client;
            this.username = client.getAuthentication().getName();
        }
    }

    public ClientPrimaryDataEntity getSelectedFile() {
        if (this.fileSelectionMode == 1) {
            if (this.currentdir != null) {
                return this.currentdir;
            }
            return this.currentdir;
        }
        if (this.fileSelectionMode == 0) {
            if (this.selectedFile != null) {
                return this.selectedFile;
            }
            return this.selectedFile;
        }
        if (this.selectedFile != null) {
            return this.selectedFile;
        }
        if (this.currentdir != null) {
            return this.currentdir;
        }
        return this.currentdir;
    }

    private MetaData getEntityVersionMetaData(ClientPrimaryDataEntity dataentity, ClientPrimaryDataEntityVersion version) {
        try {
            for (ClientPrimaryDataEntityVersion curr : dataentity.getVersions()) {
                if (curr.getRevision().longValue() != version.getRevision().longValue()) continue;
                return curr.getMetaData();
            }
            return dataentity.getMetaData();
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
            JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e.getMessage(), "EDALFileChooser", 0);
            return null;
        }
    }

    public ClientPrimaryDataEntity[] getSelectedFiles() {
        if (this.selectrows != null && this.filelist.size() > 0) {
            if (this.fileSelectionMode == 1) {
                ClientPrimaryDataEntity[] selectedFiles = new ClientPrimaryDataEntity[]{this.currentdir};
                return selectedFiles;
            }
            if (this.fileSelectionMode == 0) {
                ClientPrimaryDataEntity[] selectedFiles = new ClientPrimaryDataEntity[this.selectrows.length];
                for (int i = 0; i < selectedFiles.length; ++i) {
                    selectedFiles[i] = this.filelist.get(this.selectrows[i]);
                }
                return selectedFiles;
            }
            ClientPrimaryDataEntity[] selectedFiles = new ClientPrimaryDataEntity[this.selectrows.length];
            for (int i = 0; i < selectedFiles.length; ++i) {
                selectedFiles[i] = this.filelist.get(this.selectrows[i]);
            }
            return selectedFiles;
        }
        if (this.fileSelectionMode == 0) {
            return new ClientPrimaryDataFile[0];
        }
        ClientPrimaryDataEntity[] selectedFiles = new ClientPrimaryDataEntity[]{this.currentdir};
        return selectedFiles;
    }

    public int showOpenDialog() {
        try {
            this.initViewers();
            this.savemodal = false;
            this.setTitle("Open File");
            this.init(this.rootDirectory);
            if (this.client == null && 1 == this.showlogindialog()) {
                this.dispose();
                return this.returnvalue;
            }
            this.setModal(true);
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            return this.returnvalue;
        }
        catch (Exception e) {
            this.dispose();
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
            JOptionPane.showMessageDialog(null, e.getMessage(), "EDALFileChooser", 0);
            return -1;
        }
    }

    public int showSaveDialog() {
        try {
            this.initViewers();
            this.savemodal = true;
            this.setTitle("Save File");
            this.init(this.rootDirectory);
            this.setModal(true);
            if (this.client == null && 1 == this.showlogindialog()) {
                this.dispose();
                return this.returnvalue;
            }
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            return this.returnvalue;
        }
        catch (Exception e) {
            this.dispose();
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
            JOptionPane.showMessageDialog(null, e.getMessage(), "EDALFileChooser", 0);
            return -1;
        }
    }

    public void setMultiSelectionEnabled(boolean b) {
        this.multiSelectionEnabled = b;
    }

    public void setFileFilter(EdalAbstractFileFilter filter) {
        this.fileFilter = filter;
    }

    public EdalAbstractFileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileSelectionMode(int mode) {
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new IllegalArgumentException("Incorrect Mode for file selection: " + mode);
        }
        this.fileSelectionMode = mode;
    }

    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    protected void init(ClientPrimaryDataDirectory rootDirectory) {
        this.currentdir = rootDirectory;
        JPanel maincontents = new JPanel();
        this.setContentPane(maincontents);
        maincontents.setLayout(new BorderLayout());
        maincontents.add((Component)this.centerPane, "Center");
        maincontents.add((Component)this.statusbar, "South");
        double[][] mainsize = new double[][]{{0.07, 0.05, 0.09, 0.36, 0.05, 0.028, 0.221, 0.01, 0.02, 0.07, 0.01}, {30.0, -1.0, 30.0, 6.0}};
        TableLayout mainlayout = new TableLayout((double[][])mainsize);
        this.centerPane.setLayout((LayoutManager)mainlayout);
        if (rootDirectory != null) {
            this.pathlabel.setVerticalAlignment(0);
            this.pathlabel.setFont(FONT);
            this.centerPane.add((Component)this.pathlabel, "0,0");
            this.pathtext.setFont(FONT);
            this.centerPane.add((Component)this.pathtext, "1,0,4,0");
        }
        this.searchtext.setFont(FONT);
        if (rootDirectory != null) {
            this.centerPane.add((Component)this.searchtext, "6,0");
            this.searchtext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EdalFileChooser.this.search(EdalFileChooser.this.searchtext.getText().trim());
                }
            });
        }
        JButton searchbutton = new JButton(this.searchAction);
        searchbutton.setFont(FONT);
        if (rootDirectory != null) {
            this.centerPane.add((Component)searchbutton, "8,0,9,0");
        }
        this.detailpanelparent = new JPanel();
        this.detailpanelparent.setFont(FONT);
        this.detailpanelparent.setLayout(new BorderLayout());
        if (rootDirectory != null) {
            final ClientPrimaryDataDirectory f_rootDirectory = rootDirectory;
            this.tree = new JTree(this.addNodes(null, rootDirectory));
            EdalTreeCellRenderer renderer = new EdalTreeCellRenderer(this.tree.getCellRenderer());
            this.tree.setCellRenderer(renderer);
            this.tree.setOpaque(true);
            this.tree.setBackground(Color.white);
            UIDefaults treeDefaults = new UIDefaults();
            treeDefaults.put("Tree.selectionBackground", (Object)null);
            this.tree.putClientProperty("Nimbus.Overrides", treeDefaults);
            this.tree.putClientProperty("Nimbus.Overrides.InheritDefaults", false);
            this.treepanelparent = new JScrollPane(this.tree);
            this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    EdalFileChooser.this.currentnode = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
                    EdalNode mynode = (EdalNode)EdalFileChooser.this.currentnode.getUserObject();
                    EdalFileChooser.this.pathtext.setText(mynode.getPath());
                    EdalFileChooser.this.cleartable();
                    try {
                        try {
                            EdalFileChooser.this.currentdir = (ClientPrimaryDataDirectory)EdalFileHelper.getEntity(mynode.getPath(), f_rootDirectory);
                        }
                        catch (PrimaryDataDirectoryException e1) {
                            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                            JOptionPane.showMessageDialog(null, "No such " + mynode.getPath() + " exists!", "EDALFileChooser", 0);
                        }
                        List<ClientPrimaryDataEntity> dirlist = null;
                        try {
                            dirlist = EdalFileChooser.this.currentdir.listPrimaryDataEntities();
                        }
                        catch (PrimaryDataDirectoryException e1) {
                            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                            JOptionPane.showMessageDialog(null, "Can't load load all " + EdalFileChooser.this.currentdir.getName() + "objects!", "EDALFileChooser", 0);
                        }
                        if (dirlist != null) {
                            EdalFileChooser.this.defaultModel = EdalFileChooser.this.buildtable(dirlist);
                            EdalFileChooser.this.filemetatable.setModel(EdalFileChooser.this.defaultModel);
                            EdalFileChooser.this.defaultModel.fireTableDataChanged();
                            UiUtil.fitTableColumns(EdalFileChooser.this.filemetatable);
                            if (EdalFileChooser.this.detailpanel != null && !EdalFileChooser.this.detailpanel.isCollapsed()) {
                                EdalFileChooser.this.detailpanel.setCollapsed(true);
                                EdalFileChooser.this.detailpanel.setScrollOnExpand(true);
                            }
                        }
                        if (EdalFileChooser.this.currentdir != null) {
                            EdalFileChooser.this.buildDetail(EdalFileChooser.this.detailpanelparent, EdalFileChooser.this.currentdir, true);
                        }
                        EdalFileChooser.this.showmetabutton(EdalFileChooser.this.currentdir);
                        EdalFileChooser.this.showpermissionbutton(EdalFileChooser.this.currentdir);
                    }
                    catch (RemoteException e1) {
                        ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                        JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e1.getMessage(), "EDALFileChooser", 0);
                    }
                    catch (NotBoundException e1) {
                        ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                        JOptionPane.showMessageDialog(null, "Edal internal server error occurred:" + e1.getMessage(), "EDALFileChooser", 0);
                    }
                }
            });
            this.tree.addTreeWillExpandListener(new TreeWillExpandListenerAction(this.tree, rootDirectory));
            this.tree.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    EdalFileChooser.this.checktreeRightClick(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    EdalFileChooser.this.checktreeRightClick(e);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (EdalFileChooser.this.filemetatable != null) {
                        EdalFileChooser.this.filemetatable.clearSelection();
                        JTree ttree = (JTree)e.getComponent();
                        TreePath tpath = ttree.getPathForLocation(e.getX(), e.getY());
                        if (tpath != null && tpath.getLastPathComponent() != null) {
                            EdalFileChooser.this.currentnode = (DefaultMutableTreeNode)tpath.getLastPathComponent();
                            EdalNode mynode = (EdalNode)EdalFileChooser.this.currentnode.getUserObject();
                            EdalFileChooser.this.pathtext.setText(mynode.getPath());
                        }
                    }
                }
            });
            try {
                this.defaultModel = this.buildtable(rootDirectory.listPrimaryDataEntities());
            }
            catch (RemoteException e1) {
                ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e1.getMessage(), "EDALFileChooser", 0);
            }
            catch (PrimaryDataDirectoryException e1) {
                ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                JOptionPane.showMessageDialog(null, "Call Edal server function exception:" + e1.getMessage(), "EDALFileChooser", 0);
            }
            this.filemetatable = new EdalTable(this.defaultModel);
            if (this.multiSelectionEnabled) {
                this.filemetatable.setSelectionMode(2);
            } else {
                this.filemetatable.setSelectionMode(0);
            }
            this.filemetatable.getSelectionModel().addListSelectionListener(new TableRowModelListener(this.filemetatable, this.detailpanelparent));
            this.filemetatable.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    Point point = e.getPoint();
                    int x = EdalFileChooser.this.filemetatable.rowAtPoint(point);
                    int y = EdalFileChooser.this.filemetatable.columnAtPoint(point);
                    if (x != EdalFileChooser.this.row || y != EdalFileChooser.this.column) {
                        EdalFileChooser.this.row = x;
                        EdalFileChooser.this.column = y;
                    }
                    if (EdalFileChooser.this.tipsmap.containsKey(EdalFileChooser.this.row + 1 + "," + (EdalFileChooser.this.column + 1))) {
                        EdalFileChooser.this.filemetatable.setToolTipText(EdalFileChooser.this.formattooltips((String)EdalFileChooser.this.tipsmap.get(EdalFileChooser.this.row + 1 + "," + (EdalFileChooser.this.column + 1))));
                    } else if (EdalFileChooser.this.row > 0 && EdalFileChooser.this.column > 0) {
                        Object tip = EdalFileChooser.this.filemetatable.getValueAt(EdalFileChooser.this.row, EdalFileChooser.this.column);
                        EdalFileChooser.this.filemetatable.setToolTipText(EdalFileChooser.this.formattooltips(tip.toString()));
                    }
                }
            });
            this.filemetatable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    EdalFileChooser.this.checktableRightClick(evt, EdalFileChooser.this.tree);
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    EdalFileChooser.this.checktableRightClick(evt, EdalFileChooser.this.tree);
                }
            });
            if (this.tablebackcolor == null) {
                this.tablebackcolor = this.filemetatable.getSelectionBackground();
            }
            UiUtil.fitTableColumns(this.filemetatable);
            this.tableshowpane = new JSplitPane(0, new JScrollPane(this.filemetatable), this.detailpanelparent);
            if (this.currentdir != null) {
                this.buildDetail(this.detailpanelparent, this.currentdir, true);
            }
            this.tableshowpane.setDividerLocation(0.75);
            this.tableshowpane.setResizeWeight(0.75);
            this.tableshowpane.resetToPreferredSizes();
            this.dirshowpane = new JSplitPane(1, this.treepanelparent, this.tableshowpane);
            this.centerPane.add((Component)this.dirshowpane, "0,1,10,1");
            this.detailpanelparent.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    EdalFileChooser.this.checkpanelRightClick(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    EdalFileChooser.this.checkpanelRightClick(e);
                }
            });
        }
        this.configbutton = new JButton("Change Connection");
        this.configbutton.setFont(FONT);
        this.configbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdalFileChooser.this.showlogindialog();
            }
        });
        this.permissionbutton = new JButton("Change Permissions");
        this.permissionbutton.setFont(FONT);
        this.permissionbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EdalFileChooser.this.filelist.size() > 0 && EdalFileChooser.this.filelist.get(EdalFileChooser.this.fileselectindex) != null) {
                    PermissionDialog permission = new PermissionDialog((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(EdalFileChooser.this.fileselectindex), EdalFileChooser.this.client);
                    permission.showOpenDialog();
                } else {
                    PermissionDialog permission = new PermissionDialog(EdalFileChooser.this.currentdir, EdalFileChooser.this.client);
                    permission.showOpenDialog();
                }
            }
        });
        this.metadatabutton = new JButton("Change Metadata");
        this.metadatabutton.setFont(FONT);
        this.metadatabutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EdalFileChooser.this.filelist.size() > 0 && EdalFileChooser.this.filelist.get(EdalFileChooser.this.fileselectindex) != null) {
                    MetaDataSaveDialog metadlg = new MetaDataSaveDialog((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(EdalFileChooser.this.fileselectindex));
                    int returnVal = metadlg.showOpenDialog();
                    if (returnVal == 0) {
                        Map<EnumDublinCoreElements, UntypedData> metadatavalue = metadlg.getMetadatavalue();
                        EdalFileChooser.this.changemetadata((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(EdalFileChooser.this.fileselectindex), metadatavalue, true);
                    }
                } else {
                    MetaDataSaveDialog metadlg = new MetaDataSaveDialog(EdalFileChooser.this.currentdir);
                    int returnVal = metadlg.showOpenDialog();
                    if (returnVal == 0) {
                        Map<EnumDublinCoreElements, UntypedData> metadatavalue = metadlg.getMetadatavalue();
                        EdalFileChooser.this.changemetadata(EdalFileChooser.this.currentdir, metadatavalue, false);
                    }
                }
            }
        });
        this.okbutton = new JButton("Ok");
        this.okbutton.setFont(FONT);
        this.okbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdalFileChooser.this.handleokclick();
                EdalFileChooser.this.returnvalue = 0;
                EdalFileChooser.this.dispose();
            }
        });
        JButton cancelbutton = new JButton(this.cancelAction);
        cancelbutton.setFont(FONT);
        JPanel functionButtons = new JPanel();
        functionButtons.setLayout(new FlowLayout(2));
        functionButtons.add(this.configbutton);
        if (rootDirectory != null) {
            functionButtons.add(this.permissionbutton);
            functionButtons.add(this.metadatabutton);
            this.showmetabutton(rootDirectory);
            this.showpermissionbutton(rootDirectory);
        }
        functionButtons.add(this.okbutton);
        functionButtons.add(cancelbutton);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BorderLayout());
        buttons.add((Component)functionButtons, "East");
        this.centerPane.add((Component)buttons, "0,2,10,2");
        this.addWindowListener(this.createAppCloser());
        this.setPreferredSize(new Dimension(950, 575));
        this.setMinimumSize(new Dimension(950, 575));
        if (rootDirectory != null) {
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    EdalFileChooser.this.dirshowpane.setDividerLocation(0.3);
                }
            });
        }
        this.statusbar.updateStatus();
        maincontents.updateUI();
        this.pack();
        if (rootDirectory != null) {
            this.dirshowpane.setDividerLocation(0.3);
        }
    }

    private int showlogindialog() {
        EdalConfigDialog eDALConfigUi = new EdalConfigDialog();
        int returnVal = eDALConfigUi.showOpenDialog();
        if (returnVal == 0) {
            EdalLoginHelper helper = new EdalLoginHelper();
            helper.savedata(eDALConfigUi.getServeraddress(), eDALConfigUi.getServerport(), eDALConfigUi.getUsername(), eDALConfigUi.getPassword());
            this.bindui = false;
            this.cleartable();
            this.init(EdalConfigDialog.rootDirectory);
            if (EdalConfigDialog.client != null) {
                this.client = EdalConfigDialog.client;
                this.username = this.client.getAuthentication().getName();
                this.pathtext.setText("");
            }
            return 0;
        }
        return 1;
    }

    private void cleanbuttonevent(JButton button) {
        if (button != null) {
            for (ActionListener al : button.getActionListeners()) {
                button.removeActionListener(al);
            }
        }
    }

    private void checktableRightClick(MouseEvent evt, final JTree tree) {
        if (evt.isPopupTrigger()) {
            final int rightclickrow = evt.getY() / this.filemetatable.getRowHeight();
            JMenuItem del = new JMenuItem("Delete");
            JMenuItem rename = new JMenuItem("Rename");
            JMenuItem permissionmenu = new JMenuItem("Change Permissions");
            JPopupMenu popupMenu = new JPopupMenu();
            if (this.savemodal) {
                popupMenu.add(del);
                popupMenu.add(rename);
            }
            if (this.filelist.size() > 0 && PrincipalUtil.checkPermission(this.currentdir, this.username, CHANGEPERMISSIONTHODNAME) && this.filelist.get(rightclickrow) != null) {
                popupMenu.add(permissionmenu);
            }
            JMenuItem metadatamenu = new JMenuItem("Change Metadata");
            if (this.filelist.size() > 0 && this.filelist.get(this.fileselectindex) != null) {
                popupMenu.add(metadatamenu);
                if (!PrincipalUtil.checkPermission(this.filelist.get(this.fileselectindex), this.username, CHANGEMETADATAMETHODNAME)) {
                    metadatamenu.setEnabled(false);
                }
            } else if (this.currentdir != null) {
                popupMenu.add(metadatamenu);
                if (!PrincipalUtil.checkPermission(this.currentdir, this.username, CHANGEMETADATAMETHODNAME)) {
                    metadatamenu.setEnabled(false);
                }
            }
            metadatamenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EdalFileChooser.this.filelist.size() > 0 && EdalFileChooser.this.filelist.get(EdalFileChooser.this.fileselectindex) != null) {
                        MetaDataSaveDialog metadlg = new MetaDataSaveDialog((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(EdalFileChooser.this.fileselectindex));
                        int returnVal = metadlg.showOpenDialog();
                        if (returnVal == 0) {
                            Map<EnumDublinCoreElements, UntypedData> metadatavalue = metadlg.getMetadatavalue();
                            EdalFileChooser.this.changemetadata((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(EdalFileChooser.this.fileselectindex), metadatavalue, true);
                        }
                    } else {
                        MetaDataSaveDialog metadlg = new MetaDataSaveDialog(EdalFileChooser.this.currentdir);
                        int returnVal = metadlg.showOpenDialog();
                        if (returnVal == 0) {
                            Map<EnumDublinCoreElements, UntypedData> metadatavalue = metadlg.getMetadatavalue();
                            EdalFileChooser.this.changemetadata(EdalFileChooser.this.currentdir, metadatavalue, false);
                        }
                    }
                }
            });
            del.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block10: {
                        Object[] buttons = new String[]{"Yes", "No"};
                        int rc = JOptionPane.showOptionDialog(null, "Do you want to delete?", "EDALFileChooser", 1, 0, null, buttons, buttons[1]);
                        if (rc == 0) {
                            try {
                                if (EdalFileChooser.this.filelist.size() <= 0) break block10;
                                boolean shouldfresh = false;
                                if (((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(rightclickrow)).isDirectory()) {
                                    shouldfresh = true;
                                }
                                ((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(rightclickrow)).delete();
                                EdalFileChooser.this.filelist.remove(rightclickrow);
                                List<ClientPrimaryDataEntity> dirlist = null;
                                try {
                                    dirlist = EdalFileChooser.this.currentdir.listPrimaryDataEntities();
                                }
                                catch (PrimaryDataDirectoryException e1) {
                                    ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                                    JOptionPane.showMessageDialog(null, "Can't load load all " + EdalFileChooser.this.currentdir.getName() + "objects!", "EDALFileChooser", 0);
                                }
                                if (dirlist != null) {
                                    EdalFileChooser.this.defaultModel = EdalFileChooser.this.buildtable(dirlist);
                                    EdalFileChooser.this.filemetatable.setModel(EdalFileChooser.this.defaultModel);
                                    EdalFileChooser.this.defaultModel.fireTableDataChanged();
                                    UiUtil.fitTableColumns(EdalFileChooser.this.filemetatable);
                                }
                                if (shouldfresh) {
                                    EdalFileChooser.this.refreshtreenode(tree);
                                }
                            }
                            catch (RemoteException e1) {
                                ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                                JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e1.getMessage(), "EDALFileChooser", 0);
                            }
                            catch (PrimaryDataEntityVersionException e1) {
                                ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                                JOptionPane.showMessageDialog(null, "The requested version is not available or marked as deleted!", "EDALFileChooser", 0);
                            }
                            catch (PrimaryDataDirectoryException e1) {
                                ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                                JOptionPane.showMessageDialog(null, "Call Edal server function exception:" + e1.getMessage(), "EDALFileChooser", 0);
                            }
                        }
                    }
                }
            });
            rename.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block14: {
                        String s = null;
                        try {
                            s = JOptionPane.showInputDialog(null, "Please input directoy name:", ((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(rightclickrow)).getName());
                        }
                        catch (RemoteException e2) {
                            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e2));
                            JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e2.getMessage(), "EDALFileChooser", 0);
                        }
                        if (s != null && s.trim().length() > 0) {
                            try {
                                try {
                                    if (EdalFileChooser.this.currentdir.exist(s.trim())) {
                                        JOptionPane.showMessageDialog(null, "Error:[" + s.trim() + "] already exists!\nPlease specify a different name.", "EDALFileChooser", 0);
                                        break block14;
                                    }
                                    try {
                                        ((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(rightclickrow)).rename(s.trim());
                                        List<ClientPrimaryDataEntity> dirlist = null;
                                        try {
                                            dirlist = EdalFileChooser.this.currentdir.listPrimaryDataEntities();
                                        }
                                        catch (PrimaryDataDirectoryException e1) {
                                            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                                            JOptionPane.showMessageDialog(null, "Can't load load all " + EdalFileChooser.this.currentdir.getName() + "objects!", "EDALFileChooser", 0);
                                        }
                                        if (dirlist != null) {
                                            EdalFileChooser.this.defaultModel = EdalFileChooser.this.buildtable(dirlist);
                                            EdalFileChooser.this.filemetatable.setModel(EdalFileChooser.this.defaultModel);
                                            EdalFileChooser.this.defaultModel.fireTableDataChanged();
                                            UiUtil.fitTableColumns(EdalFileChooser.this.filemetatable);
                                        }
                                        if (((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(rightclickrow)).isDirectory()) {
                                            EdalFileChooser.this.refreshtreenode(tree);
                                        }
                                    }
                                    catch (PrimaryDataEntityVersionException e1) {
                                        ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                                        JOptionPane.showMessageDialog(null, "The requested version is not available or marked as deleted!", "EDALFileChooser", 0);
                                    }
                                }
                                catch (PrimaryDataDirectoryException e1) {
                                    ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                                    JOptionPane.showMessageDialog(null, "Can't load load all objects in " + s.trim() + " directory!", "EDALFileChooser", 0);
                                }
                            }
                            catch (RemoteException e1) {
                                ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                                JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e1.getMessage(), "EDALFileChooser", 0);
                            }
                        }
                    }
                }
            });
            permissionmenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PermissionDialog permission = new PermissionDialog((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(rightclickrow), EdalFileChooser.this.client);
                    permission.showOpenDialog();
                }
            });
            popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void checktreeRightClick(MouseEvent e) {
        if (e.isPopupTrigger()) {
            final JTree tree = (JTree)e.getComponent();
            TreePath path = tree.getPathForLocation(e.getX(), e.getY());
            tree.setSelectionPath(path);
            JMenuItem del = new JMenuItem("Delete Directoy");
            JMenuItem rename = new JMenuItem("Rename Directoy");
            JMenuItem newFile = new JMenuItem("New Directoy");
            JMenuItem permissionmenu = new JMenuItem("Change Permissions");
            JMenuItem metadatamenu = new JMenuItem("Change Metadata");
            JPopupMenu popupMenu1 = new JPopupMenu();
            if (this.savemodal) {
                if (this.currentnode != null) {
                    popupMenu1.add(newFile);
                }
                if (path != null && path.getParentPath() != null) {
                    popupMenu1.add(del);
                    popupMenu1.add(rename);
                }
            }
            if (this.currentnode != null && PrincipalUtil.checkPermission(this.currentdir, this.username, CHANGEPERMISSIONTHODNAME)) {
                popupMenu1.add(permissionmenu);
            }
            permissionmenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PermissionDialog permission = new PermissionDialog(EdalFileChooser.this.currentdir, EdalFileChooser.this.client);
                    permission.showOpenDialog();
                }
            });
            if (this.currentdir != null) {
                popupMenu1.add(metadatamenu);
                if (!PrincipalUtil.checkPermission(this.currentdir, this.username, CHANGEMETADATAMETHODNAME)) {
                    metadatamenu.setEnabled(false);
                }
            }
            metadatamenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MetaDataSaveDialog metadlg = new MetaDataSaveDialog(EdalFileChooser.this.currentdir);
                    int returnVal = metadlg.showOpenDialog();
                    if (returnVal == 0) {
                        Map<EnumDublinCoreElements, UntypedData> metadatavalue = metadlg.getMetadatavalue();
                        EdalFileChooser.this.changemetadata(EdalFileChooser.this.currentdir, metadatavalue, false);
                    }
                }
            });
            del.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object[] buttons = new String[]{"Yes", "No"};
                    int rc = JOptionPane.showOptionDialog(null, "Do you want to delete current directory?", "EDALFileChooser", 1, 0, null, buttons, buttons[1]);
                    if (rc == 0) {
                        try {
                            EdalFileChooser.this.currentdir.delete();
                            ((DefaultMutableTreeNode)EdalFileChooser.this.currentnode.getParent()).remove(EdalFileChooser.this.currentnode);
                            EdalFileChooser.this.cleartable();
                            tree.updateUI();
                        }
                        catch (RemoteException e1) {
                            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                            JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e1.getMessage(), "EDALFileChooser", 0);
                        }
                        catch (PrimaryDataEntityVersionException e1) {
                            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                            JOptionPane.showMessageDialog(null, "The requested version is not available or marked as deleted!", "EDALFileChooser", 0);
                        }
                        catch (PrimaryDataDirectoryException e1) {
                            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                            JOptionPane.showMessageDialog(null, "Can't load load all objects in current directory!", "EDALFileChooser", 0);
                        }
                    }
                }
            });
            newFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block9: {
                        String s = JOptionPane.showInputDialog("Please input directoy name:");
                        if (s != null && s.trim().length() > 0) {
                            try {
                                try {
                                    if (EdalFileChooser.this.currentdir.exist(s.trim())) {
                                        JOptionPane.showMessageDialog(null, "Error:Directory [" + s.trim() + "] already exists!\nPlease specify a different name.", "EDALFileChooser", 0);
                                        break block9;
                                    }
                                    if (s.indexOf("\\") >= 0 || s.indexOf("/") >= 0 || s.indexOf(":") >= 0 || s.indexOf("?") >= 0 || s.indexOf(">") >= 0 || s.indexOf("<") >= 0 || s.indexOf("|") >= 0 || s.indexOf("\"") >= 0 || s.indexOf("\\") >= 0) {
                                        JOptionPane.showMessageDialog(null, "Error:Directory name cannot contain any of the following characters:\\ / : * ? \" < > | !\nPlease specify a different name.", "EDALFileChooser", 0);
                                        break block9;
                                    }
                                    try {
                                        ClientPrimaryDataDirectory childdir = EdalFileChooser.this.currentdir.createPrimaryDataDirectory(s.trim());
                                        EdalMutableTreeModel newChild = new EdalMutableTreeModel(new EdalNode(s.trim(), childdir.getPath()));
                                        EdalFileChooser.this.currentnode.add(newChild);
                                        tree.updateUI();
                                        EdalFileChooser.this.refreshtable();
                                    }
                                    catch (AccessControlException se) {
                                        ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(se));
                                        JOptionPane.showMessageDialog(null, "Can't create directory:" + se.getMessage(), "EDALFileChooser", 0);
                                    }
                                }
                                catch (PrimaryDataDirectoryException e1) {
                                    ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                                    JOptionPane.showMessageDialog(null, "Can't load load all objects in " + s.trim() + " directory!", "EDALFileChooser", 0);
                                }
                            }
                            catch (RemoteException e1) {
                                ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                                JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e1.getMessage(), "EDALFileChooser", 0);
                            }
                        }
                    }
                }
            });
            rename.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block11: {
                        String s = null;
                        try {
                            s = JOptionPane.showInputDialog(null, "Please input directoy name:", EdalFileChooser.this.currentdir.getName());
                        }
                        catch (RemoteException e2) {
                            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e2));
                            JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e2.getMessage(), "EDALFileChooser", 0);
                        }
                        if (s != null && s.trim().length() > 0) {
                            try {
                                try {
                                    if (EdalFileChooser.this.currentdir.getParentDirectory().exist(s.trim())) {
                                        JOptionPane.showMessageDialog(null, "Error:Directory [" + s.trim() + "] already exists!\nPlease specify a different name.", "EDALFileChooser", 0);
                                        break block11;
                                    }
                                    if (s.indexOf("\\") >= 0 || s.indexOf("/") >= 0 || s.indexOf(":") >= 0 || s.indexOf("?") >= 0 || s.indexOf(">") >= 0 || s.indexOf("<") >= 0 || s.indexOf("|") >= 0 || s.indexOf("\"") >= 0 || s.indexOf("\\") >= 0) {
                                        JOptionPane.showMessageDialog(null, "Error:Directory name cannot contain any of the following characters:\\ / : * ? \" < > | !\nPlease specify a different name.", "EDALFileChooser", 0);
                                        break block11;
                                    }
                                    try {
                                        EdalFileChooser.this.currentdir.rename(s.trim());
                                        EdalNode mynode = (EdalNode)EdalFileChooser.this.currentnode.getUserObject();
                                        mynode.setName(s.trim());
                                        mynode.setPath(EdalFileChooser.this.currentdir.getPath());
                                        EdalFileChooser.this.currentnode.setUserObject(mynode);
                                        tree.updateUI();
                                    }
                                    catch (PrimaryDataEntityVersionException e1) {
                                        ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                                        JOptionPane.showMessageDialog(null, "The requested version is not available or marked as deleted!", "EDALFileChooser", 0);
                                    }
                                }
                                catch (PrimaryDataDirectoryException e1) {
                                    ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                                    JOptionPane.showMessageDialog(null, "Can't load load all objects in " + s.trim() + " directory!", "EDALFileChooser", 0);
                                }
                            }
                            catch (RemoteException e1) {
                                ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                                JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e1.getMessage(), "EDALFileChooser", 0);
                            }
                        }
                    }
                }
            });
            popupMenu1.show(tree, e.getX(), e.getY());
        }
    }

    private void checkpanelRightClick(MouseEvent e) {
        if (e.isPopupTrigger()) {
            JPanel panel = (JPanel)e.getComponent();
            JMenuItem metadatamenu = new JMenuItem("Change Metadata");
            JPopupMenu popupMenu1 = new JPopupMenu();
            if (this.filelist.size() > 0 && this.filelist.get(this.fileselectindex) != null) {
                if (!PrincipalUtil.checkPermission(this.filelist.get(this.fileselectindex), this.username, CHANGEMETADATAMETHODNAME)) {
                    return;
                }
                popupMenu1.add(metadatamenu);
            } else if (this.currentdir != null) {
                if (!PrincipalUtil.checkPermission(this.currentdir, this.username, CHANGEMETADATAMETHODNAME)) {
                    return;
                }
                popupMenu1.add(metadatamenu);
            }
            metadatamenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EdalFileChooser.this.filelist.size() > 0 && EdalFileChooser.this.filelist.get(EdalFileChooser.this.fileselectindex) != null) {
                        MetaDataSaveDialog metadlg = new MetaDataSaveDialog((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(EdalFileChooser.this.fileselectindex));
                        int returnVal = metadlg.showOpenDialog();
                        if (returnVal == 0) {
                            Map<EnumDublinCoreElements, UntypedData> metadatavalue = metadlg.getMetadatavalue();
                            EdalFileChooser.this.changemetadata((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(EdalFileChooser.this.fileselectindex), metadatavalue, true);
                        }
                    } else {
                        MetaDataSaveDialog metadlg = new MetaDataSaveDialog(EdalFileChooser.this.currentdir);
                        int returnVal = metadlg.showOpenDialog();
                        if (returnVal == 0) {
                            Map<EnumDublinCoreElements, UntypedData> metadatavalue = metadlg.getMetadatavalue();
                            EdalFileChooser.this.changemetadata(EdalFileChooser.this.currentdir, metadatavalue, false);
                        }
                    }
                }
            });
            popupMenu1.show(panel, e.getX(), e.getY());
        }
    }

    private void refreshtable() {
        this.cleartable();
        List<ClientPrimaryDataEntity> dirlist = null;
        try {
            dirlist = this.currentdir.listPrimaryDataEntities();
        }
        catch (PrimaryDataDirectoryException e1) {
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
            JOptionPane.showMessageDialog(null, "Can't load load all current objects!", "EDALFileChooser", 0);
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
            JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e.getMessage(), "EDALFileChooser", 0);
        }
        if (dirlist != null) {
            this.defaultModel = this.buildtable(dirlist);
            this.filemetatable.setModel(this.defaultModel);
            this.defaultModel.fireTableDataChanged();
            UiUtil.fitTableColumns(this.filemetatable);
        }
    }

    private void refreshtreenode(JTree tree) {
        if (this.currentnode != null) {
            this.currentnode.removeAllChildren();
            if (this.currentdir != null) {
                try {
                    List<ClientPrimaryDataEntity> dirlist = this.currentdir.listPrimaryDataEntities();
                    ArrayList<String> dirnamelist = new ArrayList<String>();
                    HashMap<String, ClientPrimaryDataEntity> dirnamemap = new HashMap<String, ClientPrimaryDataEntity>();
                    if (dirlist != null) {
                        for (ClientPrimaryDataEntity dir : dirlist) {
                            if (!dir.isDirectory() || dir.getCurrentVersion().isDeleted()) continue;
                            dirnamelist.add(dir.getName());
                            dirnamemap.put(dir.getName(), dir);
                        }
                    }
                    Collections.sort(dirnamelist, String.CASE_INSENSITIVE_ORDER);
                    for (String dirname : dirnamelist) {
                        EdalMutableTreeModel child = new EdalMutableTreeModel(new EdalNode(dirname, ((ClientPrimaryDataDirectory)dirnamemap.get(dirname)).getPath()));
                        this.currentnode.add(child);
                    }
                    tree.updateUI();
                }
                catch (RemoteException e1) {
                    ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                    JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e1.getMessage(), "EDALFileChooser", 0);
                }
                catch (PrimaryDataDirectoryException e1) {
                    ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                    JOptionPane.showMessageDialog(null, "Can't load load all objects in current directory!", "EDALFileChooser", 0);
                }
            }
        }
    }

    protected void initViewers() {
        this.metadatatoshow.add("DATE");
        this.metadatatoshow.add("FORMAT");
        ViewerContainer.registerViewer(EnumDublinCoreElements.CHECKSUM, new CheckSumViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.CREATOR, new PersonInfoViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.CONTRIBUTOR, new PersonInfoViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.PUBLISHER, new PersonInfoViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.RELATION, new IdentifierRelationViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.DATE, new DateEventsViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.COVERAGE, new TextViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.DESCRIPTION, new TextViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.FORMAT, new DataFormatViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.IDENTIFIER, new IdentifierViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.LANGUAGE, new LanguageViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.RIGHTS, new TextViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.SOURCE, new TextViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.SUBJECT, new TextViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.TITLE, new TextViewer());
    }

    protected void handleokclick() {
        if (this.savemodal) {
            // empty if block
        }
    }

    private void switchversion(int versionidx) {
        if (this.selectedFile != null) {
            this.currentversion = this.versionlist.get(versionidx);
            try {
                String strdate = null;
                SimpleDateFormat dataformat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                if (this.currentversion.getRevisionDate() != null) {
                    strdate = dataformat.format(this.currentversion.getRevisionDate().getTime());
                }
                this.selectedFile.switchCurrentVersion(this.currentversion);
                this.currentversionmap.put(this.selectedFile.getPath(), this.currentversion);
                this.versionpanel.setTitle("Version:" + this.currentversion.getRevision() + " from " + strdate + (this.currentversion.isDeleted() ? " - deleted." : ""));
            }
            catch (RemoteException e) {
                ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
                JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e.getMessage(), "EDALFileChooser", 0);
            }
            catch (AccessControlException e) {
                ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
            }
            catch (PrimaryDataEntityVersionException e) {
                ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
            }
        }
    }

    private void search(final String keyword) {
        this.cleartable();
        final HashSet results = new HashSet();
        final ArrayList resultslist = new ArrayList();
        if (this.currentdir == null) {
            this.currentdir = this.rootDirectory;
        }
        final EdalFileChooser thisdialog = this;
        final Cursor cursor = thisdialog.getCursor();
        thisdialog.setCursor(new Cursor(3));
        final InfiniteProgressPanel glassPane = new InfiniteProgressPanel();
        glassPane.setWidth(this.getWidth());
        glassPane.setHeight(this.getHeight() - 150);
        this.setGlassPane(glassPane);
        glassPane.setText("search for:" + keyword);
        glassPane.start();
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ClientPrimaryDataEntity[] result = EdalFileChooser.this.currentdir.searchByKeyword(keyword, true, true).toArray(new ClientPrimaryDataEntity[0]);
                    if (result != null) {
                        for (ClientPrimaryDataEntity data : result) {
                            results.add(data);
                        }
                    }
                    for (ClientPrimaryDataEntity data : results) {
                        resultslist.add(data);
                    }
                    EdalFileChooser.this.defaultModel = EdalFileChooser.this.buildtable(resultslist);
                    EdalFileChooser.this.filemetatable.setModel(EdalFileChooser.this.defaultModel);
                    EdalFileChooser.this.defaultModel.fireTableDataChanged();
                    UiUtil.fitTableColumns(EdalFileChooser.this.filemetatable);
                }
                catch (RemoteException e) {
                    ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
                    JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e.getMessage(), "EDALFileChooser", 0);
                }
                catch (PrimaryDataDirectoryException e) {
                    ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
                    JOptionPane.showMessageDialog(null, "Can't find object or there are too much results!", "EDALFileChooser", 0);
                }
                finally {
                    thisdialog.setCursor(cursor);
                    glassPane.stop();
                }
            }
        }.start();
    }

    private void cleartable() {
        if (this.defaultModel != null) {
            int irow = this.defaultModel.getRowCount();
            for (int i = 0; i < irow; ++i) {
                this.defaultModel.removeRow(0);
            }
        }
        this.filelist.clear();
        this.selectedFile = null;
    }

    private EdalTableModel buildtable(List<ClientPrimaryDataEntity> dirlist) {
        ArrayList<String> rowlist;
        this.tipsmap.clear();
        this.row = 0;
        this.column = 0;
        ArrayList<String> columnlist = new ArrayList<String>();
        columnlist.add("TITLE");
        for (EnumDublinCoreElements elem : EnumDublinCoreElements.values()) {
            String dataName = elem.toString();
            if (!this.metadatatoshow.contains(dataName)) continue;
            columnlist.add(dataName);
        }
        Object[] columnNames = columnlist.toArray(new String[0]);
        ArrayList datalist = new ArrayList();
        if (dirlist != null) {
            for (ClientPrimaryDataEntity dataentry : dirlist) {
                String value;
                String tvalue;
                String dataName;
                MetaData filemetadata;
                try {
                    try {
                        dataentry.getCurrentVersion();
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (dataentry.getCurrentVersion().isDeleted()) {
                        continue;
                    }
                }
                catch (RemoteException e1) {
                    ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                    JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e1.getMessage(), "EDALFileChooser", 0);
                }
                if (this.fileSelectionMode == 2) {
                    try {
                        if (!dataentry.isDirectory() && (this.fileFilter == null || this.fileFilter.accept((ClientPrimaryDataFile)dataentry))) {
                            rowlist = new ArrayList<String>();
                            rowlist.add(dataentry.getName());
                            filemetadata = dataentry.getCurrentVersion().getMetaData();
                            for (EnumDublinCoreElements elem : EnumDublinCoreElements.values()) {
                                dataName = elem.toString();
                                try {
                                    if (!this.metadatatoshow.contains(dataName)) continue;
                                    if ("DATE".equals(dataName)) {
                                        tvalue = null;
                                        DateEvents tdataevents = (DateEvents)filemetadata.getElementValue((Enum)elem);
                                        Set dataset = tdataevents.getSet();
                                        for (EdalDate edaldate : dataset) {
                                            if (!"MODIFIED".equals(edaldate.getEvent())) continue;
                                            tvalue = edaldate.toString();
                                            break;
                                        }
                                        if (tvalue == null) {
                                            for (EdalDate edaldate : dataset) {
                                                if (!"CREATE".equals(edaldate.getEvent())) continue;
                                                tvalue = edaldate.toString();
                                                break;
                                            }
                                        }
                                        rowlist.add(tvalue);
                                        continue;
                                    }
                                    value = filemetadata.getElementValue((Enum)elem).toString();
                                    if (value != null && value.length() > 40) {
                                        int itemprow = datalist.size() + 1;
                                        int itempcol = rowlist.size() + 1;
                                        this.tipsmap.put(itemprow + "," + itempcol, value);
                                        rowlist.add(value.substring(0, 40) + "...");
                                        continue;
                                    }
                                    rowlist.add(value);
                                }
                                catch (MetaDataException e) {
                                    ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
                                    JOptionPane.showMessageDialog(null, "Can't load the value for " + dataName + "!", "EDALFileChooser", 0);
                                }
                            }
                            datalist.add(rowlist);
                            this.filelist.add(dataentry);
                            continue;
                        }
                        if (!dataentry.isDirectory()) continue;
                        rowlist = new ArrayList();
                        rowlist.add(dataentry.getName());
                        filemetadata = dataentry.getCurrentVersion().getMetaData();
                        for (EnumDublinCoreElements elem : EnumDublinCoreElements.values()) {
                            dataName = elem.toString();
                            try {
                                if (!this.metadatatoshow.contains(dataName)) continue;
                                if ("DATE".equals(dataName)) {
                                    tvalue = null;
                                    DateEvents tdataevents = (DateEvents)filemetadata.getElementValue((Enum)elem);
                                    Set dataset = tdataevents.getSet();
                                    for (EdalDate edaldate : dataset) {
                                        if (!"MODIFIED".equals(edaldate.getEvent())) continue;
                                        tvalue = edaldate.toString();
                                        break;
                                    }
                                    if (tvalue == null) {
                                        for (EdalDate edaldate : dataset) {
                                            if (!"CREATE".equals(edaldate.getEvent())) continue;
                                            tvalue = edaldate.toString();
                                            break;
                                        }
                                    }
                                    rowlist.add(tvalue);
                                    continue;
                                }
                                value = filemetadata.getElementValue((Enum)elem).toString();
                                if (value != null && value.length() > 40) {
                                    int itemprow = datalist.size() + 1;
                                    int itempcol = rowlist.size() + 1;
                                    this.tipsmap.put(itemprow + "," + itempcol, value);
                                    rowlist.add(value.substring(0, 40) + "...");
                                    continue;
                                }
                                rowlist.add(value);
                            }
                            catch (MetaDataException e) {
                                ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
                                JOptionPane.showMessageDialog(null, "Can't load the value for " + dataName + "!", "EDALFileChooser", 0);
                            }
                        }
                        datalist.add(rowlist);
                        this.filelist.add(dataentry);
                    }
                    catch (RemoteException e) {
                        ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
                        JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e.getMessage(), "EDALFileChooser", 0);
                    }
                    continue;
                }
                if (this.fileSelectionMode == 1) {
                    try {
                        if (!dataentry.isDirectory()) continue;
                        rowlist = new ArrayList();
                        rowlist.add(dataentry.getName());
                        filemetadata = dataentry.getCurrentVersion().getMetaData();
                        for (EnumDublinCoreElements elem : EnumDublinCoreElements.values()) {
                            dataName = elem.toString();
                            try {
                                if (!this.metadatatoshow.contains(dataName)) continue;
                                if ("DATE".equals(dataName)) {
                                    tvalue = null;
                                    DateEvents tdataevents = (DateEvents)filemetadata.getElementValue((Enum)elem);
                                    Set dataset = tdataevents.getSet();
                                    for (EdalDate edaldate : dataset) {
                                        if (!"MODIFIED".equals(edaldate.getEvent())) continue;
                                        tvalue = edaldate.toString();
                                        break;
                                    }
                                    if (tvalue == null) {
                                        for (EdalDate edaldate : dataset) {
                                            if (!"CREATE".equals(edaldate.getEvent())) continue;
                                            tvalue = edaldate.toString();
                                            break;
                                        }
                                    }
                                    rowlist.add(tvalue);
                                    continue;
                                }
                                value = filemetadata.getElementValue((Enum)elem).toString();
                                if (value != null && value.length() > 40) {
                                    int itemprow = datalist.size() + 1;
                                    int itempcol = rowlist.size() + 1;
                                    this.tipsmap.put(itemprow + "," + itempcol, value);
                                    rowlist.add(value.substring(0, 40) + "...");
                                    continue;
                                }
                                rowlist.add(value);
                            }
                            catch (MetaDataException e) {
                                ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
                                JOptionPane.showMessageDialog(null, "Can't load the value for " + dataName + "!", "EDALFileChooser", 0);
                            }
                        }
                        datalist.add(rowlist);
                        this.filelist.add(dataentry);
                    }
                    catch (RemoteException e) {
                        ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
                        JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e.getMessage(), "EDALFileChooser", 0);
                    }
                    continue;
                }
                if (this.fileSelectionMode != 0) continue;
                try {
                    if (dataentry.isDirectory() || this.fileFilter != null && !this.fileFilter.accept((ClientPrimaryDataFile)dataentry)) continue;
                    rowlist = new ArrayList();
                    rowlist.add(dataentry.getName());
                    filemetadata = dataentry.getCurrentVersion().getMetaData();
                    for (EnumDublinCoreElements elem : EnumDublinCoreElements.values()) {
                        try {
                            dataName = elem.toString();
                            if (!this.metadatatoshow.contains(dataName)) continue;
                            value = filemetadata.getElementValue((Enum)elem).toString();
                            if ("DATE".equals(dataName)) {
                                String tvalue2 = null;
                                DateEvents tdataevents = (DateEvents)filemetadata.getElementValue((Enum)elem);
                                Set dataset = tdataevents.getSet();
                                for (EdalDate edaldate : dataset) {
                                    if (!"MODIFIED".equals(edaldate.getEvent())) continue;
                                    tvalue2 = edaldate.toString();
                                    break;
                                }
                                if (tvalue2 == null) {
                                    for (EdalDate edaldate : dataset) {
                                        if (!"CREATE".equals(edaldate.getEvent())) continue;
                                        tvalue2 = edaldate.toString();
                                        break;
                                    }
                                }
                                rowlist.add(tvalue2);
                                continue;
                            }
                            if (value != null && value.length() > 40) {
                                int itemprow = datalist.size() + 1;
                                int itempcol = rowlist.size() + 1;
                                this.tipsmap.put(itemprow + "," + itempcol, value);
                                rowlist.add(value.substring(0, 40) + "...");
                                continue;
                            }
                            rowlist.add(value);
                        }
                        catch (MetaDataException e) {
                            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
                            JOptionPane.showMessageDialog(null, "Metadata operate Exception:" + e.getMessage(), "EDALFileChooser", 0);
                        }
                    }
                    datalist.add(rowlist);
                    this.filelist.add(dataentry);
                }
                catch (RemoteException e) {
                    ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
                    JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e.getMessage(), "EDALFileChooser", 0);
                }
            }
        }
        Object[][] rowData = new Object[datalist.size()][columnNames.length];
        for (int i = 0; i < datalist.size(); ++i) {
            rowlist = (ArrayList<String>)datalist.get(i);
            for (int j = 0; j < rowlist.size(); ++j) {
                rowData[i][j] = rowlist.get(j);
            }
        }
        return new EdalTableModel(rowData, columnNames);
    }

    private void showmetabutton(ClientPrimaryDataEntity dataentry) {
        if (!PrincipalUtil.checkPermission(dataentry, this.username, CHANGEMETADATAMETHODNAME)) {
            this.metadatabutton.setVisible(false);
        } else {
            this.metadatabutton.setVisible(true);
        }
    }

    private void showpermissionbutton(ClientPrimaryDataEntity dataentry) {
        if (!PrincipalUtil.checkPermission(dataentry, this.username, CHANGEPERMISSIONTHODNAME)) {
            this.permissionbutton.setVisible(false);
        } else {
            this.permissionbutton.setVisible(true);
        }
    }

    private void buildDetail(JPanel detailpanelparent, ClientPrimaryDataEntity dataentry, boolean refreshversion) {
        UntypedData data;
        String dataName;
        MetaData filemetadata;
        this.showmetabutton(dataentry);
        this.showpermissionbutton(dataentry);
        ArrayList<String> columnlist = new ArrayList<String>();
        for (EnumDublinCoreElements elem : EnumDublinCoreElements.values()) {
            try {
                String dataName2 = elem.toString();
                columnlist.add(dataName2);
            }
            catch (UnsupportedOperationException e) {
                ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
                JOptionPane.showMessageDialog(null, "UnsupportedOperation Exception!", "EDALFileChooser", 0);
            }
        }
        String[] columnNames = columnlist.toArray(new String[0]);
        double[][] detailsize = new double[2][];
        detailsize[0] = new double[4];
        detailsize[0][0] = 0.16;
        detailsize[0][1] = 0.34;
        detailsize[0][2] = 0.16;
        detailsize[0][3] = 0.34;
        int ilen = columnNames.length;
        int columnlen = ilen / 2;
        if (columnlen * 2 < ilen) {
            ++columnlen;
        }
        detailsize[1] = new double[columnlen];
        for (int i = 0; i < columnlen - 1; ++i) {
            detailsize[1][i] = 25.0;
        }
        detailsize[1][columnlen - 1] = -1.0;
        if (!this.bindui) {
            this.metainfocontainer = new JXTaskPaneContainer();
            this.metainfocontainer.setBackground(new Color(238, 238, 238));
            this.detailpanel = new LailapsJXTaskPane();
            this.detailpanel.setBackground(new Color(238, 238, 238));
            this.detailpanel.setJSplitPane(this.tableshowpane);
            this.detailpanel.setName("Metadata Information");
            try {
                String metaabstract = dataentry.getMetaData().toString();
                if (metaabstract.length() > 80) {
                    metaabstract = metaabstract.substring(0, 80) + "...";
                }
                this.detailpanel.setTitle("Meta data:" + metaabstract);
            }
            catch (RemoteException e1) {
                ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                JOptionPane.showMessageDialog(null, e1.getMessage(), "EDALFileChooser", 0);
            }
            if (!this.detailpanel.isCollapsed()) {
                this.detailpanel.setCollapsed(true);
                this.detailpanel.setScrollOnExpand(true);
            }
            TableLayout detaillayout = new TableLayout((double[][])detailsize);
            this.detailpanel.setLayout((LayoutManager)detaillayout);
            for (int i = 0; i < columnlen; ++i) {
                JLinkLabel label1 = new JLinkLabel(columnNames[i * 2].toString() + ":", 2);
                label1.setVerticalAlignment(0);
                label1.setFont(FONT);
                label1.setToolTipText("<html>" + MetaDescription.getDescription(columnNames[i * 2].toString()) + "</html>");
                this.detailpanel.add(label1, "0," + i);
                JTextField text1 = new JTextField();
                text1.setFont(FONT);
                this.detailpanel.add(text1, "1," + i);
                this.detailmap.put(columnNames[i * 2].toString(), text1);
                if (i * 2 + 1 >= columnNames.length) continue;
                JLinkLabel label2 = new JLinkLabel(columnNames[i * 2 + 1].toString() + ":", 2);
                label2.setVerticalAlignment(0);
                label2.setFont(FONT);
                label2.setToolTipText("<html>" + MetaDescription.getDescription(columnNames[i * 2 + 1].toString()) + "</html>");
                this.detailpanel.add(label2, "2," + i);
                JTextField text2 = new JTextField();
                text2.setFont(FONT);
                this.detailpanel.add(text2, "3," + i);
                this.detailmap.put(columnNames[i * 2 + 1].toString(), text2);
            }
            this.metainfocontainer.add((JXTaskPane)this.detailpanel);
            try {
                SortedSet<ClientPrimaryDataEntityVersion> versions = dataentry.getVersions();
                if (versions != null) {
                    ClientPrimaryDataEntityVersion[] versionarray = versions.toArray(new ClientPrimaryDataEntityVersion[0]);
                    this.versionpanel = new LailapsJXTaskPane();
                    this.buidversionpanel(this.versionpanel, versionarray);
                    this.metainfocontainer.add((JXTaskPane)this.versionpanel);
                }
            }
            catch (RemoteException e) {
                ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
                JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e.getMessage(), "EDALFileChooser", 0);
            }
            detailpanelparent.add((Component)new JScrollPane((Component)this.metainfocontainer), "Center");
            this.bindui = true;
        }
        try {
            String metaabstract = dataentry.getMetaData().toString();
            if (metaabstract.length() > 80) {
                metaabstract = metaabstract.substring(0, 80) + "...";
            }
            this.detailpanel.setTitle("Meta data:" + metaabstract);
        }
        catch (RemoteException e1) {
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
            JOptionPane.showMessageDialog(null, e1.getMessage(), "EDALFileChooser", 0);
        }
        try {
            filemetadata = this.currentversionmap.containsKey(dataentry.getPath()) ? this.getEntityVersionMetaData(dataentry, this.currentversionmap.get(dataentry.getPath())) : dataentry.getCurrentVersion().getMetaData();
            for (EnumDublinCoreElements elem : EnumDublinCoreElements.values()) {
                dataName = elem.toString();
                try {
                    data = filemetadata.getElementValue((Enum)elem);
                    if (!this.detailmap.containsKey(dataName)) continue;
                    final MetadataViewer viewer = ViewerContainer.getViewer(EnumDublinCoreElements.valueOf((String)dataName));
                    if (viewer != null) {
                        for (MouseListener al : this.detailmap.get(dataName).getMouseListeners()) {
                            this.detailmap.get(dataName).removeMouseListener(al);
                        }
                        this.detailmap.get(dataName).addMouseListener(new MouseAdapter(){

                            @Override
                            public void mouseClicked(MouseEvent e) {
                                if (e.getClickCount() == 2) {
                                    viewer.setValue(data);
                                    viewer.setTitle(dataName + " Information");
                                    viewer.showOpenDialog();
                                }
                            }
                        });
                        continue;
                    }
                    this.detailmap.get(dataName).setEditable(false);
                }
                catch (MetaDataException e) {
                    ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
                    JOptionPane.showMessageDialog(null, "Can't load the value for " + dataName + "!", "EDALFileChooser", 0);
                }
            }
        }
        catch (RemoteException e1) {
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
            JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e1.getMessage(), "EDALFileChooser", 0);
        }
        try {
            filemetadata = this.currentversionmap.containsKey(dataentry.getPath()) ? this.getEntityVersionMetaData(dataentry, this.currentversionmap.get(dataentry.getPath())) : dataentry.getCurrentVersion().getMetaData();
            for (EnumDublinCoreElements elem : EnumDublinCoreElements.values()) {
                dataName = elem.toString();
                try {
                    data = filemetadata.getElementValue((Enum)elem);
                    String value = data.toString();
                    if (!this.detailmap.containsKey(dataName)) continue;
                    this.detailmap.get(dataName).setText(value);
                    this.detailmap.get(dataName).setCaretPosition(0);
                    if (value.trim().length() <= 0) continue;
                    this.detailmap.get(dataName).setToolTipText(this.formattooltips(value));
                }
                catch (MetaDataException e) {
                    ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
                    JOptionPane.showMessageDialog(null, "Can't load the value for " + dataName + "!", "EDALFileChooser", 0);
                }
            }
        }
        catch (RemoteException e1) {
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
            JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e1.getMessage(), "EDALFileChooser", 0);
        }
        this.selectedFile = dataentry;
        if (refreshversion) {
            try {
                SortedSet<ClientPrimaryDataEntityVersion> versions = dataentry.getVersions();
                this.versionlist.clear();
                if (versions != null) {
                    ClientPrimaryDataEntityVersion[] versionarray = versions.toArray(new ClientPrimaryDataEntityVersion[0]);
                    this.buidversionpanel(this.versionpanel, versionarray);
                }
            }
            catch (RemoteException e) {
                ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
                JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e.getMessage(), "EDALFileChooser", 0);
            }
        }
    }

    private void buidversionpanel(LailapsJXTaskPane versionpanel, ClientPrimaryDataEntityVersion[] versionarray) throws RemoteException {
        versionpanel.setJSplitPane(this.tableshowpane);
        versionpanel.setFriendpanel(this.detailpanel);
        this.detailpanel.setFriendpanel(versionpanel);
        versionpanel.setName("Version Information");
        versionpanel.setTitle("Version Information");
        if (!versionpanel.isCollapsed()) {
            versionpanel.setCollapsed(true);
            versionpanel.setScrollOnExpand(true);
        }
        double[][] versionsize = new double[2][];
        versionsize[0] = new double[3];
        versionsize[0][0] = 0.45;
        versionsize[0][1] = 0.1;
        versionsize[0][2] = 0.45;
        int iversionlen = versionarray.length;
        int versioncolumnlen = iversionlen / 2;
        if (versioncolumnlen * 2 < iversionlen) {
            ++versioncolumnlen;
        }
        versionsize[1] = new double[versioncolumnlen];
        for (int i = 0; i < versioncolumnlen - 1; ++i) {
            versionsize[1][i] = 25.0;
        }
        versionsize[1][versioncolumnlen - 1] = -1.0;
        ArrayList<JVersionLabel> versionbuttonlist = new ArrayList<JVersionLabel>();
        TableLayout versionlayout = new TableLayout((double[][])versionsize);
        versionpanel.setLayout((LayoutManager)versionlayout);
        for (int i = 0; i < versioncolumnlen; ++i) {
            String strdate = null;
            SimpleDateFormat dataformat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            if (versionarray[i * 2].getRevisionDate() != null) {
                strdate = dataformat.format(versionarray[i * 2].getRevisionDate().getTime());
            }
            JVersionLabel label1 = new JVersionLabel("Version " + versionarray[i * 2].getRevision() + " : " + strdate + (versionarray[i * 2].isDeleted() ? " - deleted." : ""));
            label1.setVerticalAlignment(0);
            label1.setFont(FONT);
            versionbuttonlist.add(label1);
            label1.addMouseListener(new LinkMouseListener(versionbuttonlist, i * 2, this.detailpanelparent));
            versionpanel.add(label1, "0," + i);
            this.versionlist.add(versionarray[i * 2]);
            if (i * 2 + 1 >= versionarray.length) continue;
            strdate = dataformat.format(versionarray[i * 2 + 1].getRevisionDate().getTime());
            JVersionLabel label2 = new JVersionLabel("Version " + versionarray[i * 2 + 1].getRevision() + " : " + strdate + (versionarray[i * 2 + 1].isDeleted() ? " - deleted." : ""));
            label2.setVerticalAlignment(0);
            label2.setFont(FONT);
            label2.addMouseListener(new LinkMouseListener(versionbuttonlist, i * 2 + 1, this.detailpanelparent));
            versionpanel.add(label2, "2," + i);
            this.versionlist.add(versionarray[i * 2 + 1]);
            versionbuttonlist.add(label2);
        }
        if (versionbuttonlist.size() > 0) {
            ((JVersionLabel)versionbuttonlist.get(versionbuttonlist.size() - 1)).setSelect(true);
        }
    }

    private DefaultMutableTreeNode addNodes(DefaultMutableTreeNode curTop, ClientPrimaryDataDirectory parentdir) {
        EdalMutableTreeModel curDir = null;
        String parentname = "";
        try {
            curDir = new EdalMutableTreeModel(new EdalNode(parentdir.getName(), parentdir.getPath()));
            if (curTop != null) {
                curTop.add(curDir);
            }
            parentname = parentdir.getName();
            if (parentdir.isDirectory()) {
                List<ClientPrimaryDataEntity> dirlist = parentdir.listPrimaryDataEntities();
                ArrayList<String> dirnamelist = new ArrayList<String>();
                HashMap<String, ClientPrimaryDataEntity> dirnamemap = new HashMap<String, ClientPrimaryDataEntity>();
                if (dirlist != null) {
                    for (ClientPrimaryDataEntity dir : dirlist) {
                        ClientPrimaryDataEntityVersion version = null;
                        try {
                            version = dir.getCurrentVersion();
                            if (!dir.isDirectory() || version.isDeleted()) continue;
                            dirnamelist.add(dir.getName());
                            dirnamemap.put(dir.getName(), dir);
                        }
                        catch (Exception e) {}
                    }
                }
                Collections.sort(dirnamelist, String.CASE_INSENSITIVE_ORDER);
                for (String dirname : dirnamelist) {
                    EdalMutableTreeModel child = new EdalMutableTreeModel(new EdalNode(dirname, ((ClientPrimaryDataDirectory)dirnamemap.get(dirname)).getPath()));
                    curDir.add(child);
                }
            }
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
            JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e.getMessage(), "EDALFileChooser", 0);
        }
        catch (PrimaryDataDirectoryException e) {
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
            JOptionPane.showMessageDialog(null, "Can't load load all " + parentname + " objects!", "EDALFileChooser", 0);
        }
        return curDir;
    }

    private void disablemetadata() {
        this.metadatabutton.setVisible(false);
        this.permissionbutton.setVisible(false);
    }

    private Component[] getComponents(Component container) {
        ArrayList<Object> list = null;
        try {
            list = new ArrayList<Component>(Arrays.asList(((Container)container).getComponents()));
            for (int index = 0; index < list.size(); ++index) {
                for (Component currentComponent : this.getComponents((Component)list.get(index))) {
                    list.add(currentComponent);
                }
            }
        }
        catch (ClassCastException e) {
            list = new ArrayList();
        }
        return list.toArray(new Component[list.size()]);
    }

    private void changemetadata(ClientPrimaryDataEntity dataentry, Map<EnumDublinCoreElements, UntypedData> metadatavalue, boolean refreshversion) {
        if (metadatavalue != null) {
            try {
                MetaData fileMetaData = dataentry.getMetaData().clone();
                for (Map.Entry<EnumDublinCoreElements, UntypedData> entry : metadatavalue.entrySet()) {
                    EnumDublinCoreElements key = entry.getKey();
                    UntypedData val = entry.getValue();
                    fileMetaData.setElementValue(key, val);
                }
                dataentry.setMetaData(fileMetaData);
                this.buildDetail(this.detailpanelparent, dataentry, refreshversion);
            }
            catch (Exception re) {
                ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(re));
                JOptionPane.showMessageDialog(null, re.getMessage(), "EDALFileChooser", 0);
            }
        }
    }

    private String formattooltips(String tooltips) {
        if (tooltips == null) {
            return "";
        }
        if (tooltips.length() <= 20) {
            return tooltips;
        }
        return tooltips.substring(0, 20) + "...";
    }

    private WindowListener createAppCloser() {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                EdalFileChooser.this.returnvalue = 1;
                EdalFileChooser.this.dispose();
            }
        };
    }

    static /* synthetic */ int[] access$3002(EdalFileChooser x0, int[] x1) {
        x0.selectrows = x1;
        return x1;
    }

    private class TableRowModelListener
    implements ListSelectionListener {
        private JTable table;
        private JPanel detailpanelparent;

        public TableRowModelListener(JTable table, JPanel detailpanelparent) {
            this.table = table;
            this.detailpanelparent = detailpanelparent;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            boolean b = this.table.getSelectionModel().getValueIsAdjusting();
            if (!b && this.table.getSelectedRow() > -1) {
                EdalFileChooser.access$3002(EdalFileChooser.this, this.table.getSelectedRows());
                EdalFileChooser.this.fileselectindex = this.table.getSelectedRow();
                if (EdalFileChooser.this.selectrows.length == 1) {
                    EdalFileChooser.this.buildDetail(this.detailpanelparent, (ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(this.table.getSelectedRow()), true);
                    try {
                        EdalFileChooser.this.pathtext.setText(((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(this.table.getSelectedRow())).getPath());
                    }
                    catch (RemoteException e1) {
                        ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                        JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e1.getMessage(), "EDALFileChooser", 0);
                    }
                } else {
                    EdalFileChooser.this.disablemetadata();
                }
                if (EdalFileChooser.this.detailpanel != null && !EdalFileChooser.this.detailpanel.isCollapsed()) {
                    EdalFileChooser.this.detailpanel.setCollapsed(true);
                    EdalFileChooser.this.detailpanel.setScrollOnExpand(true);
                }
            }
        }
    }

    private class LinkMouseListener
    extends MouseAdapter {
        private int versionidx;
        private JPanel detailpanelparent;
        private List<JVersionLabel> versionbuttonlist;

        public LinkMouseListener(List<JVersionLabel> versionbuttonlist, int versionidx, JPanel detailpanelparent) {
            this.versionidx = versionidx;
            this.detailpanelparent = detailpanelparent;
            this.versionbuttonlist = versionbuttonlist;
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (this.versionbuttonlist != null) {
                for (int i = 0; i < this.versionbuttonlist.size(); ++i) {
                    if (i != this.versionidx) {
                        this.versionbuttonlist.get(i).setSelect(false);
                        continue;
                    }
                    this.versionbuttonlist.get(i).setSelect(true);
                }
            }
            EdalFileChooser.this.switchversion(this.versionidx);
            EdalFileChooser.this.buildDetail(this.detailpanelparent, (ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(EdalFileChooser.this.fileselectindex), false);
        }
    }
}

