/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DateEvents;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDate;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDateRange;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.EdalDateTimePicker;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.EdalTableModel;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor.MetaDataEditDialog;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalDateFormat;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalTable;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.UiUtil;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class DateEventsDialog
extends MetaDataEditDialog {
    private static final long serialVersionUID = 1L;
    private int width = 770;
    private EdalDateTimePicker starttimetext;
    private EdalDateTimePicker endtimetext;
    private JTextArea eventtext;
    private DateEvents dateevents;
    private Set<EdalDate> memoryevents = new HashSet<EdalDate>();
    private EdalTableModel defaultModel = null;
    private JTable infotable = null;
    private Map<Integer, EdalDate> containmap = new HashMap<Integer, EdalDate>();
    private Action addAction = new AbstractAction("add"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            EdalDate basicdate = null;
            if (DateEventsDialog.this.starttimetext.getCalendar() != null && DateEventsDialog.this.starttimetext.getPrecision() != null && DateEventsDialog.this.endtimetext.getCalendar() != null && DateEventsDialog.this.endtimetext.getPrecision() != null && DateEventsDialog.this.eventtext.getText().trim().length() > 0) {
                basicdate = new EdalDateRange(DateEventsDialog.this.starttimetext.getCalendar(), DateEventsDialog.this.starttimetext.getPrecision(), DateEventsDialog.this.endtimetext.getCalendar(), DateEventsDialog.this.endtimetext.getPrecision(), DateEventsDialog.this.eventtext.getText());
            } else if (DateEventsDialog.this.starttimetext.getCalendar() != null && DateEventsDialog.this.starttimetext.getPrecision() != null && DateEventsDialog.this.eventtext.getText().trim().length() > 0) {
                basicdate = new EdalDate(DateEventsDialog.this.starttimetext.getCalendar(), DateEventsDialog.this.starttimetext.getPrecision(), DateEventsDialog.this.eventtext.getText());
            } else {
                JOptionPane.showMessageDialog(null, "Please enter at least a startdate and event!", "EDALFileChooser", 0);
                return;
            }
            DateEventsDialog.this.memoryevents.add(basicdate);
            DateEventsDialog.this.defaultModel = DateEventsDialog.this.buildTable();
            DateEventsDialog.this.infotable.setModel(DateEventsDialog.this.defaultModel);
            DateEventsDialog.this.defaultModel.fireTableDataChanged();
            UiUtil.fitTableColumns(DateEventsDialog.this.infotable);
            DateEventsDialog.this.starttimetext.reset();
            DateEventsDialog.this.endtimetext.reset();
            DateEventsDialog.this.eventtext.setText("");
        }
    };
    private Action delAction = new AbstractAction("remove"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DateEventsDialog.this.infotable.getSelectedRow() > -1) {
                int iselect = DateEventsDialog.this.infotable.getSelectedRow();
                EdalDate basicdate2del = (EdalDate)DateEventsDialog.this.containmap.get(iselect);
                if (basicdate2del.getEvent().equals(EdalDate.STANDART_EVENT_TYPES.CREATE.toString()) || basicdate2del.getEvent().equals(EdalDate.STANDART_EVENT_TYPES.MODIFIED.toString())) {
                    JOptionPane.showMessageDialog(null, "event " + basicdate2del.getEvent() + " can't be deleted!", "EDALFileChooser", 0);
                    return;
                }
                EdalDate basicdate = (EdalDate)DateEventsDialog.this.containmap.remove(iselect);
                DateEventsDialog.this.dateevents.remove((Object)basicdate);
                DateEventsDialog.this.memoryevents.remove(basicdate);
                DateEventsDialog.this.defaultModel.removeRow(iselect);
                DateEventsDialog.this.defaultModel.fireTableDataChanged();
            }
        }
    };

    public DateEventsDialog(DateEvents dateevents, String title) {
        this.dateevents = dateevents;
        this.setTitle(title);
        JPanel contents = (JPanel)this.getContentPane();
        contents.setLayout(new BorderLayout());
        JPanel showPane = new JPanel();
        showPane.setLayout(new BorderLayout());
        showPane.setPreferredSize(new Dimension((int)((double)this.width * 0.618), 100));
        this.setResizable(false);
        this.defaultModel = this.buildTable();
        this.infotable = new EdalTable(this.defaultModel);
        UiUtil.fitTableColumns(this.infotable);
        showPane.add((Component)new JScrollPane(this.infotable), "Center");
        JPanel editPane = new JPanel();
        double[][] editsize = new double[][]{{0.1, 0.3, 0.1, 0.1, 0.2, 0.1, 0.1}, {30.0, 30.0, 80.0, 30.0}};
        TableLayout editlayout = new TableLayout((double[][])editsize);
        editPane.setLayout((LayoutManager)editlayout);
        JLabel starttimelabel = new JLabel("StartTime:");
        editPane.add((Component)starttimelabel, "0,0");
        this.starttimetext = new EdalDateTimePicker(null);
        editPane.add((Component)this.starttimetext, "1,0,2,0");
        JLabel endtimelabel = new JLabel("EndTime:");
        editPane.add((Component)endtimelabel, "3,0");
        this.endtimetext = new EdalDateTimePicker(null);
        editPane.add((Component)this.endtimetext, "4,0,6,0");
        JLabel eventlabel = new JLabel("Event:");
        editPane.add((Component)eventlabel, "0,1");
        int rows = 20;
        int cols = 30;
        this.eventtext = new JTextArea(rows, cols);
        editPane.add((Component)this.eventtext, "0,2,6,2");
        JButton addbtn = new JButton(this.addAction);
        editPane.add((Component)addbtn, "2,3");
        JButton delbtn = new JButton(this.delAction);
        editPane.add((Component)delbtn, "3,3");
        JSplitPane tableshowpane = new JSplitPane(0, new JScrollPane(showPane), editPane);
        tableshowpane.setDividerLocation(0.8);
        tableshowpane.setResizeWeight(0.8);
        tableshowpane.setBorder(BorderFactory.createTitledBorder(""));
        contents.add((Component)tableshowpane, "Center");
        contents.add((Component)this.createbuttonpanel(), "South");
        this.setSize(new Dimension(this.width, (int)((double)this.width * 0.618)));
        this.initdata();
    }

    public DateEvents getDateEvents() {
        if (!this.memoryevents.isEmpty()) {
            this.dateevents.addAll(this.memoryevents);
        }
        return this.dateevents;
    }

    @Override
    public void initdata() {
    }

    private EdalTableModel buildTable() {
        int i;
        ArrayList<String> columnlist = new ArrayList<String>();
        columnlist.add("DateType");
        columnlist.add("StartTime");
        columnlist.add("EndTime");
        columnlist.add("Event");
        Object[] columnNames = columnlist.toArray(new String[0]);
        ArrayList datalist = new ArrayList();
        if (this.dateevents != null) {
            this.containmap.clear();
            Set eventset = this.dateevents.getSet();
            eventset.addAll(this.memoryevents);
            i = 0;
            for (EdalDate basicdate : eventset) {
                this.containmap.put(i++, basicdate);
                ArrayList<String> rowlist = new ArrayList<String>();
                if (basicdate instanceof EdalDateRange) {
                    rowlist.add("DateRange");
                    if (basicdate.getStartDate() != null && basicdate.getStartPrecision() != null) {
                        rowlist.add(EdalDateFormat.getDefaultDateFormat(basicdate.getStartPrecision()).format(basicdate.getStartDate().getTime()));
                    } else {
                        rowlist.add("");
                    }
                    if (((EdalDateRange)basicdate).getEndDate() != null && ((EdalDateRange)basicdate).getEndPrecision() != null) {
                        rowlist.add(EdalDateFormat.getDefaultDateFormat(((EdalDateRange)basicdate).getEndPrecision()).format(((EdalDateRange)basicdate).getEndDate().getTime()));
                    } else {
                        rowlist.add("");
                    }
                } else {
                    rowlist.add("Timepoint");
                    if (basicdate.getStartDate() != null && basicdate.getStartPrecision() != null) {
                        rowlist.add(EdalDateFormat.getDefaultDateFormat(basicdate.getStartPrecision()).format(basicdate.getStartDate().getTime()));
                    } else {
                        rowlist.add("");
                    }
                    rowlist.add("");
                }
                if (basicdate.getString() != null) {
                    rowlist.add(basicdate.getString());
                } else {
                    rowlist.add("");
                }
                datalist.add(rowlist);
            }
        }
        Object[][] rowData = new Object[datalist.size()][columnNames.length];
        for (i = 0; i < datalist.size(); ++i) {
            List rowlist = (List)datalist.get(i);
            for (int j = 0; j < rowlist.size(); ++j) {
                rowData[i][j] = rowlist.get(j);
            }
        }
        return new EdalTableModel(rowData, columnNames);
    }

    @Override
    public void cancelbuttonevent(ActionEvent e) {
        this.dateevents.removeAll(this.memoryevents);
        this.memoryevents.clear();
    }
}

