/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor;

import de.ipk_gatersleben.bit.bi.edal.aspectj.security.GrantableMethods;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor.SortedListModel;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.PrincipalUtil;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.StackTraceUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;

public class PermissionNewuserDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    private static final String DEFAULT_SOURCE_CHOICE_LABEL = "Available Permissions";
    private static final String DEFAULT_DEST_CHOICE_LABEL = "Assigned Permissions";
    private static final String ADD_BUTTON_LABEL = "Add >>";
    private static final String REMOVE_BUTTON_LABEL = "<< Remove";
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private JButton savebtn;
    private JButton cancelbtn;
    public int returnvalue;
    private JList sourceList;
    private JList destList;
    private SortedListModel sourceListModel;
    private SortedListModel destListModel;
    private JButton removeButton;
    private JLabel destLabel;
    private ClientPrimaryDataEntity dataentry = null;
    private ClientDataManager client;
    private List<GrantableMethods.Methods> allavailablemethods = new ArrayList<GrantableMethods.Methods>();
    private List<String> principals = new ArrayList<String>();
    private List<Class<? extends Principal>> supportedprincipals;
    private JTextField usertext = new JTextField();
    private JComboBox principalcomboBox;
    private Action okAction = new AbstractAction("Ok"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            PermissionNewuserDialog.this.assignpermission();
            PermissionNewuserDialog.this.returnvalue = 0;
            PermissionNewuserDialog.this.dispose();
        }
    };
    private Action cancelAction = new AbstractAction("Cancel"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            PermissionNewuserDialog.this.returnvalue = 1;
            PermissionNewuserDialog.this.dispose();
        }
    };

    public PermissionNewuserDialog(ClientPrimaryDataEntity dataentry, ClientDataManager client) {
        this.dataentry = dataentry;
        this.client = client;
        this.loadconstants();
        this.setTitle("Add NewUser");
        JPanel contents = (JPanel)this.getContentPane();
        contents.setLayout(new BorderLayout());
        JPanel userselectpanel = new JPanel();
        JLabel principallabel = new JLabel("UserName:", 0);
        userselectpanel.add(principallabel);
        this.usertext.setPreferredSize(new Dimension(90, 28));
        userselectpanel.add(this.usertext);
        this.principalcomboBox = new JComboBox();
        this.principalcomboBox.setName("principal");
        for (Class<? extends Principal> obj : this.supportedprincipals) {
            this.principalcomboBox.addItem(obj.getSimpleName());
            this.principals.add(obj.getName());
        }
        userselectpanel.add(this.principalcomboBox);
        JPanel permissioneditpanel = new JPanel();
        this.initpermissionpanel(permissioneditpanel);
        JPanel editPane = new JPanel();
        editPane.setLayout(new BorderLayout());
        editPane.add((Component)userselectpanel, "North");
        editPane.add((Component)permissioneditpanel, "Center");
        contents.add((Component)editPane, "Center");
        contents.add((Component)this.createbuttonpanel(), "South");
        this.setSize(new Dimension(600, 370));
    }

    public int showOpenDialog() {
        this.setModal(true);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        return this.returnvalue;
    }

    private void initpermissionpanel(JPanel permissioneditpanel) {
        permissioneditpanel.setBorder(BorderFactory.createEtchedBorder());
        permissioneditpanel.setLayout(new GridBagLayout());
        JLabel sourceLabel = new JLabel(DEFAULT_SOURCE_CHOICE_LABEL);
        this.sourceListModel = new SortedListModel();
        this.sourceList = new JList(this.sourceListModel);
        permissioneditpanel.add((Component)sourceLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, EMPTY_INSETS, 0, 0));
        permissioneditpanel.add((Component)new JScrollPane(this.sourceList), new GridBagConstraints(0, 1, 1, 5, 0.5, 1.0, 10, 1, EMPTY_INSETS, 0, 0));
        JButton addButton = new JButton(ADD_BUTTON_LABEL);
        permissioneditpanel.add((Component)addButton, new GridBagConstraints(1, 2, 1, 2, 0.0, 0.25, 10, 0, EMPTY_INSETS, 0, 0));
        addButton.addActionListener(new AddListener());
        this.removeButton = new JButton(REMOVE_BUTTON_LABEL);
        permissioneditpanel.add((Component)this.removeButton, new GridBagConstraints(1, 4, 1, 2, 0.0, 0.25, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.removeButton.addActionListener(new RemoveListener());
        this.destLabel = new JLabel(DEFAULT_DEST_CHOICE_LABEL);
        this.destListModel = new SortedListModel();
        this.destList = new JList(this.destListModel);
        permissioneditpanel.add((Component)this.destLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, EMPTY_INSETS, 0, 0));
        permissioneditpanel.add((Component)new JScrollPane(this.destList), new GridBagConstraints(2, 1, 1, 5, 0.5, 1.0, 10, 1, EMPTY_INSETS, 0, 0));
        this.refreshPrincipals();
    }

    private void refreshPrincipals() {
        ArrayList<GrantableMethods.Methods> allavailablenoselectedmethods = new ArrayList<GrantableMethods.Methods>();
        for (GrantableMethods.Methods method : this.allavailablemethods) {
            allavailablenoselectedmethods.add(method);
        }
        this.addSourceElements(allavailablenoselectedmethods.toArray(new GrantableMethods.Methods[0]));
    }

    private void loadconstants() {
        try {
            if (this.dataentry != null) {
                List keysets;
                List commonskeysets = GrantableMethods.ENTITY_METHODS;
                for (GrantableMethods.Methods m : commonskeysets) {
                    this.allavailablemethods.add(m);
                }
                if (this.dataentry.isDirectory()) {
                    keysets = GrantableMethods.DIRECTORY_METHODS;
                    for (GrantableMethods.Methods m : keysets) {
                        this.allavailablemethods.add(m);
                    }
                } else {
                    keysets = GrantableMethods.FILE_METHODS;
                    for (GrantableMethods.Methods m : keysets) {
                        this.allavailablemethods.add(m);
                    }
                }
            }
            this.supportedprincipals = this.client.getSupportedPrincipals();
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
            JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e.getMessage(), "EdalFileChooser", 0);
        }
        catch (EdalException e) {
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
            JOptionPane.showMessageDialog(null, "Call Edal server function exception:" + e.getMessage(), "EdalFileChooser", 0);
        }
    }

    private void fillListModel(SortedListModel model, ListModel newValues) {
        int size = newValues.getSize();
        for (int i = 0; i < size; ++i) {
            model.add(newValues.getElementAt(i));
        }
    }

    private void fillListModel(SortedListModel model, Object[] newValues) {
        model.addAll(newValues);
    }

    public void addDestinationElements(Object[] newValue) {
        this.fillListModel(this.destListModel, newValue);
    }

    public void addSourceElements(ListModel newValue) {
        this.fillListModel(this.sourceListModel, newValue);
    }

    public void addSourceElements(Object[] newValue) {
        this.fillListModel(this.sourceListModel, newValue);
    }

    public void clearSourceListModel() {
        this.sourceListModel.clear();
    }

    public void clearDestinationListModel() {
        this.destListModel.clear();
    }

    private void clearSourceSelected() {
        Object[] selected = this.sourceList.getSelectedValues();
        for (int i = selected.length - 1; i >= 0; --i) {
            this.sourceListModel.removeElement(selected[i]);
        }
        this.sourceList.getSelectionModel().clearSelection();
    }

    private void clearDestinationSelected() {
        Object[] selected = this.destList.getSelectedValues();
        for (int i = selected.length - 1; i >= 0; --i) {
            this.destListModel.removeElement(selected[i]);
        }
        this.destList.getSelectionModel().clearSelection();
    }

    private JPanel createbuttonpanel() {
        this.savebtn = new JButton(this.okAction);
        this.cancelbtn = new JButton(this.cancelAction);
        JPanel buttonPane = new JPanel(new FlowLayout(1, 5, 5));
        buttonPane.add(this.savebtn);
        buttonPane.add(this.cancelbtn);
        return buttonPane;
    }

    private void assignpermission() {
        String currentuser = this.usertext.getText().trim();
        if (currentuser.length() == 0) {
            JOptionPane.showMessageDialog(null, "Please Input UserName!", "EdalFileChooser", 0);
        }
        String currentprincipalname = this.principals.get(this.principalcomboBox.getSelectedIndex());
        Principal currentprincipal = PrincipalUtil.getInstance(currentprincipalname, currentuser);
        int destsize = this.destListModel.getSize();
        for (int i = 0; i < destsize; ++i) {
            try {
                boolean isin = PrincipalUtil.checkPermission(this.dataentry, currentprincipalname, currentuser, this.destListModel.getElementAt(i).toString());
                if (isin) continue;
                this.dataentry.grantPermission(currentprincipal, GrantableMethods.Methods.valueOf((String)this.destListModel.getElementAt(i).toString()));
                continue;
            }
            catch (RemoteException ex) {
                ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(ex));
                JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + ex.getMessage(), "EdalFileChooser", 0);
                continue;
            }
            catch (Exception ex) {
                ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(ex));
                JOptionPane.showMessageDialog(null, "Call Edal server function exception:" + ex.getMessage(), "EdalFileChooser", 0);
            }
        }
        JOptionPane.showMessageDialog(null, "Grant permissions finish!", "EdalFileChooser", 1);
    }

    private class RemoveListener
    implements ActionListener {
        private RemoveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selected = PermissionNewuserDialog.this.destList.getSelectedValues();
            PermissionNewuserDialog.this.addSourceElements(selected);
            PermissionNewuserDialog.this.clearDestinationSelected();
        }
    }

    private class AddListener
    implements ActionListener {
        private AddListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selected = PermissionNewuserDialog.this.sourceList.getSelectedValues();
            PermissionNewuserDialog.this.addDestinationElements(selected);
            PermissionNewuserDialog.this.clearSourceSelected();
        }
    }
}

