/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.LegalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Person;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor.MetaDataEditDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PersonDialog
extends MetaDataEditDialog {
    private static final long serialVersionUID = 1L;
    private JLabel surnamelabel;
    private JTextField surnametext;
    private JLabel givennamelabel;
    private JTextField givennametext;
    private JLabel addresslabel;
    private JTextField addresstext;
    private JLabel ziplabel;
    private JTextField ziptext;
    private JLabel countrylabel;
    private JTextField countrytext;
    private JLabel legalnamelabel;
    private JTextField legalnametext;
    private JLabel persontypelabel;
    private JComboBox persontypecomboBox;
    private Person person;
    private int layoutindex = 1;

    public PersonDialog(Person person, String title) {
        this.person = person;
        this.setTitle(title);
        JPanel contents = (JPanel)this.getContentPane();
        contents.setLayout(new BorderLayout());
        final JPanel editPane = new JPanel();
        final GridBagLayout gridbag = new GridBagLayout();
        editPane.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        this.persontypelabel = new JLabel("Person Type:");
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 3, 0);
        gridbag.setConstraints(this.persontypelabel, c);
        editPane.add(this.persontypelabel);
        String[] persontypelabels = new String[]{NaturalPerson.class.getSimpleName(), LegalPerson.class.getSimpleName()};
        DefaultComboBoxModel<String> persontypemodel = new DefaultComboBoxModel<String>(persontypelabels);
        this.persontypecomboBox = new JComboBox<String>(persontypemodel);
        if (person instanceof NaturalPerson) {
            this.persontypecomboBox.setSelectedIndex(0);
        } else {
            this.persontypecomboBox.setSelectedIndex(1);
        }
        this.persontypecomboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PersonDialog.this.layoutindex = 1;
                if (PersonDialog.this.persontypecomboBox.getSelectedItem().toString().equals(NaturalPerson.class.getSimpleName())) {
                    PersonDialog.this.buildnatureperonui(gridbag, editPane);
                } else {
                    PersonDialog.this.buildlegalperonui(gridbag, editPane);
                }
                editPane.updateUI();
                PersonDialog.this.initdata();
            }
        });
        c.fill = 1;
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        gridbag.setConstraints(this.persontypecomboBox, c);
        editPane.add(this.persontypecomboBox);
        if (person instanceof NaturalPerson) {
            this.buildnatureperonui(gridbag, editPane);
        } else {
            this.buildlegalperonui(gridbag, editPane);
        }
        contents.add((Component)editPane, "Center");
        contents.add((Component)this.createbuttonpanel(), "South");
        this.setSize(new Dimension(400, 247));
        this.initdata();
    }

    private void buildcommonsui(GridBagLayout gridbag, JPanel editPane) {
        if (this.addresslabel != null) {
            editPane.remove(this.addresslabel);
        }
        if (this.addresstext != null) {
            editPane.remove(this.addresstext);
        }
        if (this.ziplabel != null) {
            editPane.remove(this.ziplabel);
        }
        if (this.ziptext != null) {
            editPane.remove(this.ziptext);
        }
        if (this.countrylabel != null) {
            editPane.remove(this.countrylabel);
        }
        if (this.countrytext != null) {
            editPane.remove(this.countrytext);
        }
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(0, 0, 3, 0);
        this.addresslabel = new JLabel("Address:");
        c.fill = 1;
        c.gridx = 0;
        c.gridy = this.layoutindex;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        gridbag.setConstraints(this.addresslabel, c);
        editPane.add(this.addresslabel);
        this.addresstext = new JTextField();
        c.fill = 1;
        c.gridx = 1;
        c.gridy = this.layoutindex++;
        c.gridheight = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        gridbag.setConstraints(this.addresstext, c);
        editPane.add(this.addresstext);
        this.ziplabel = new JLabel("Zip:");
        c.fill = 1;
        c.gridx = 0;
        c.gridy = this.layoutindex;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        gridbag.setConstraints(this.ziplabel, c);
        editPane.add(this.ziplabel);
        this.ziptext = new JTextField();
        c.fill = 1;
        c.gridx = 1;
        c.gridy = this.layoutindex++;
        c.gridheight = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        gridbag.setConstraints(this.ziptext, c);
        editPane.add(this.ziptext);
        this.countrylabel = new JLabel("Country:");
        c.fill = 1;
        c.gridx = 0;
        c.gridy = this.layoutindex;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        gridbag.setConstraints(this.countrylabel, c);
        editPane.add(this.countrylabel);
        this.countrytext = new JTextField();
        c.fill = 1;
        c.gridx = 1;
        c.gridy = this.layoutindex;
        c.gridheight = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        gridbag.setConstraints(this.countrytext, c);
        editPane.add(this.countrytext);
    }

    private void buildnatureperonui(GridBagLayout gridbag, JPanel editPane) {
        if (this.legalnamelabel != null) {
            editPane.remove(this.legalnamelabel);
        }
        if (this.legalnametext != null) {
            editPane.remove(this.legalnametext);
        }
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(0, 0, 3, 0);
        this.givennamelabel = new JLabel("GivenName:");
        c.fill = 1;
        c.gridx = 0;
        c.gridy = this.layoutindex;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        gridbag.setConstraints(this.givennamelabel, c);
        editPane.add(this.givennamelabel);
        this.givennametext = new JTextField();
        c.fill = 1;
        c.gridx = 1;
        c.gridy = this.layoutindex++;
        c.gridheight = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        gridbag.setConstraints(this.givennametext, c);
        editPane.add(this.givennametext);
        c.gridx = 0;
        c.gridy = this.layoutindex;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.surnamelabel = new JLabel("SureName:");
        gridbag.setConstraints(this.surnamelabel, c);
        editPane.add(this.surnamelabel);
        this.surnametext = new JTextField();
        c.fill = 1;
        c.gridx = 1;
        c.gridy = this.layoutindex++;
        c.gridheight = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        gridbag.setConstraints(this.surnametext, c);
        editPane.add(this.surnametext);
        this.buildcommonsui(gridbag, editPane);
    }

    private void buildlegalperonui(GridBagLayout gridbag, JPanel editPane) {
        if (this.surnamelabel != null) {
            editPane.remove(this.surnamelabel);
        }
        if (this.surnametext != null) {
            editPane.remove(this.surnametext);
        }
        if (this.givennamelabel != null) {
            editPane.remove(this.givennamelabel);
        }
        if (this.givennametext != null) {
            editPane.remove(this.givennametext);
        }
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 3, 0);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = this.layoutindex;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.legalnamelabel = new JLabel("LegalName:");
        gridbag.setConstraints(this.legalnamelabel, c);
        editPane.add(this.legalnamelabel);
        this.legalnametext = new JTextField();
        c.fill = 1;
        c.gridx = 1;
        c.gridy = this.layoutindex++;
        c.gridheight = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        gridbag.setConstraints(this.legalnametext, c);
        editPane.add(this.legalnametext);
        this.buildcommonsui(gridbag, editPane);
    }

    @Override
    public void initdata() {
        if (this.person != null) {
            if (this.person instanceof NaturalPerson) {
                this.surnametext.setText(((NaturalPerson)this.person).getSureName());
                this.givennametext.setText(((NaturalPerson)this.person).getGivenName());
            } else {
                this.legalnametext.setText(((LegalPerson)this.person).getLegalName());
            }
            this.addresstext.setText(this.person.getAddressLine());
            this.ziptext.setText(this.person.getZip());
            this.countrytext.setText(this.person.getCountry());
        }
    }

    public Person getPerson() {
        if (this.persontypecomboBox.getSelectedItem().toString().equals(NaturalPerson.class.getSimpleName())) {
            NaturalPerson newperson = new NaturalPerson(this.surnametext.getText().trim(), this.givennametext.getText().trim(), this.addresstext.getText().trim(), this.ziptext.getText().trim(), this.countrytext.getText().trim());
            return newperson;
        }
        LegalPerson newperson = new LegalPerson(this.legalnametext.getText().trim(), this.addresstext.getText().trim(), this.ziptext.getText().trim(), this.countrytext.getText().trim());
        return newperson;
    }
}

