/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DateEvents;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDate;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDateRange;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer.MetadataViewDialog;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalDateFormat;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class DateEventsViewerDialog
extends MetadataViewDialog {
    private static final long serialVersionUID = 1L;
    private DateEvents dateevents;
    private DefaultTableModel defaultModel = null;
    private JTable infotable = null;
    private Map<Integer, EdalDate> containmap = new HashMap<Integer, EdalDate>();

    public DateEventsViewerDialog(DateEvents dateevents, String title) {
        this.dateevents = dateevents;
        this.setTitle(title);
        JPanel contents = (JPanel)this.getContentPane();
        contents.setLayout(new BorderLayout());
        JPanel showPane = new JPanel();
        showPane.setLayout(new BorderLayout());
        showPane.setPreferredSize(new Dimension(432, 100));
        this.defaultModel = this.buildTable();
        this.infotable = new JTable(this.defaultModel);
        this.infotable.setAutoResizeMode(0);
        this.infotable.setEnabled(false);
        this.fitTableColumns(this.infotable);
        showPane.add((Component)new JScrollPane(this.infotable), "Center");
        contents.add((Component)showPane, "Center");
        contents.add((Component)this.createbuttonpanel(), "South");
        this.setSize(new Dimension(400, 247));
        this.initdata();
    }

    @Override
    public void initdata() {
    }

    private void fitTableColumns(JTable myTable) {
        JTableHeader header = myTable.getTableHeader();
        int rowCount = myTable.getRowCount();
        Enumeration<TableColumn> columns = myTable.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            int col = header.getColumnModel().getColumnIndex(column.getIdentifier());
            int width = (int)myTable.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(myTable, column.getIdentifier(), false, false, -1, col).getPreferredSize().getWidth();
            for (int row = 0; row < rowCount; ++row) {
                int preferedWidth = (int)myTable.getCellRenderer(row, col).getTableCellRendererComponent(myTable, myTable.getValueAt(row, col), false, false, row, col).getPreferredSize().getWidth();
                width = Math.max(width, preferedWidth);
            }
            header.setResizingColumn(column);
            column.setWidth(width + myTable.getIntercellSpacing().width);
        }
    }

    private DefaultTableModel buildTable() {
        int i;
        ArrayList<String> columnlist = new ArrayList<String>();
        columnlist.add("DateType");
        columnlist.add("StartTime");
        columnlist.add("EndTime");
        columnlist.add("Event");
        Object[] columnNames = columnlist.toArray(new String[0]);
        ArrayList datalist = new ArrayList();
        if (this.dateevents != null) {
            this.containmap.clear();
            Set eventset = this.dateevents.getSet();
            i = 0;
            for (EdalDate basicdate : eventset) {
                this.containmap.put(i++, basicdate);
                ArrayList<String> rowlist = new ArrayList<String>();
                if (basicdate instanceof EdalDateRange) {
                    rowlist.add("DateRange");
                    if (basicdate.getStartDate() != null && basicdate.getStartPrecision() != null) {
                        rowlist.add(EdalDateFormat.getDefaultDateFormat(basicdate.getStartPrecision()).format(basicdate.getStartDate().getTime()));
                    } else {
                        rowlist.add("");
                    }
                    if (((EdalDateRange)basicdate).getEndDate() != null && ((EdalDateRange)basicdate).getEndPrecision() != null) {
                        rowlist.add(EdalDateFormat.getDefaultDateFormat(((EdalDateRange)basicdate).getEndPrecision()).format(((EdalDateRange)basicdate).getEndDate().getTime()));
                    } else {
                        rowlist.add("");
                    }
                } else {
                    rowlist.add("Timepoint");
                    if (basicdate.getStartDate() != null && basicdate.getStartPrecision() != null) {
                        rowlist.add(EdalDateFormat.getDefaultDateFormat(basicdate.getStartPrecision()).format(basicdate.getStartDate().getTime()));
                    } else {
                        rowlist.add("");
                    }
                    rowlist.add("");
                }
                if (basicdate.getString() != null) {
                    rowlist.add(basicdate.getString());
                } else {
                    rowlist.add("");
                }
                datalist.add(rowlist);
            }
        }
        Object[][] rowData = new Object[datalist.size()][columnNames.length];
        for (i = 0; i < datalist.size(); ++i) {
            List rowlist = (List)datalist.get(i);
            for (int j = 0; j < rowlist.size(); ++j) {
                rowData[i][j] = rowlist.get(j);
            }
        }
        return new DefaultTableModel(rowData, columnNames);
    }
}

