/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.util;

import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalAbstractFileFilter;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.StackTraceUtil;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Locale;

public class EdalFileNameExtensionFilter
extends EdalAbstractFileFilter {
    private final String description;
    private final String[] extensions;
    private final String[] lowerCaseExtensions;

    public EdalFileNameExtensionFilter(String description, String ... extensions) {
        if (extensions == null || extensions.length == 0) {
            throw new IllegalArgumentException("Extensions must be non-null and not empty");
        }
        this.description = description;
        this.extensions = new String[extensions.length];
        this.lowerCaseExtensions = new String[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            if (extensions[i] == null || extensions[i].length() == 0) {
                throw new IllegalArgumentException("Each extension must be non-null and not empty");
            }
            this.extensions[i] = extensions[i];
            this.lowerCaseExtensions[i] = extensions[i].toLowerCase(Locale.ENGLISH);
        }
    }

    @Override
    public boolean accept(ClientPrimaryDataFile f) {
        if (f != null) {
            try {
                String fileName = f.getName();
                int i = fileName.lastIndexOf(46);
                if (i > 0 && i < fileName.length() - 1) {
                    String desiredExtension = fileName.substring(i + 1).toLowerCase(Locale.ENGLISH);
                    for (String extension : this.lowerCaseExtensions) {
                        if (!desiredExtension.equals(extension)) continue;
                        return true;
                    }
                }
            }
            catch (RemoteException e) {
                ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String[] getExtensions() {
        String[] result = new String[this.extensions.length];
        System.arraycopy(this.extensions, 0, result, 0, this.extensions.length);
        return result;
    }

    public String toString() {
        return super.toString() + "[description=" + this.getDescription() + " extensions=" + Arrays.asList(this.getExtensions()) + "]";
    }
}

