/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class EdalTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private static final Color EVEN_ROW_COLOR = new Color(241, 245, 250);
    private static final Color TABLE_GRID_COLOR = new Color(0xD9D9D9);
    private static final CellRendererPane CELL_RENDER_PANE = new CellRendererPane();

    public EdalTable(TableModel dm) {
        super(dm);
        this.init();
    }

    private void init() {
        this.setTableHeader(this.createTableHeader());
        this.getTableHeader().setReorderingAllowed(false);
        this.setOpaque(false);
        this.setGridColor(TABLE_GRID_COLOR);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setShowGrid(false);
    }

    private JTableHeader createTableHeader() {
        return new JTableHeader(this.getColumnModel()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                JViewport viewport = (JViewport)this.table.getParent();
                if (viewport != null && this.table.getWidth() < viewport.getWidth()) {
                    int x = this.table.getWidth();
                    int width = viewport.getWidth() - this.table.getWidth();
                    EdalTable.paintHeader(g, this.getTable(), x, width);
                }
            }
        };
    }

    private static void paintHeader(Graphics g, JTable table, int x, int width) {
        TableCellRenderer renderer = table.getTableHeader().getDefaultRenderer();
        Component component = renderer.getTableCellRendererComponent(table, "", false, false, -1, 2);
        component.setBounds(0, 0, width, table.getTableHeader().getHeight());
        ((JComponent)component).setOpaque(false);
        CELL_RENDER_PANE.paintComponent(g, component, null, x, 0, width, table.getTableHeader().getHeight(), true);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component component = super.prepareRenderer(renderer, row, column);
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(this.getSelectionModel().isSelectedIndex(row));
        }
        return component;
    }

    public static JScrollPane createStripedJScrollPane(JTable table) {
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setViewport(new StripedViewport(table));
        scrollPane.getViewport().setView(table);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setCorner("UPPER_RIGHT_CORNER", EdalTable.createCornerComponent(table));
        return scrollPane;
    }

    private static JComponent createCornerComponent(final JTable table) {
        return new JComponent(){

            @Override
            protected void paintComponent(Graphics g) {
                EdalTable.paintHeader(g, table, 0, this.getWidth());
            }
        };
    }

    private static class StripedViewport
    extends JViewport {
        private final JTable fTable;

        public StripedViewport(JTable table) {
            this.fTable = table;
            this.setOpaque(false);
            this.initListeners();
        }

        private void initListeners() {
            PropertyChangeListener listener = this.createTableColumnWidthListener();
            for (int i = 0; i < this.fTable.getColumnModel().getColumnCount(); ++i) {
                this.fTable.getColumnModel().getColumn(i).addPropertyChangeListener(listener);
            }
        }

        private PropertyChangeListener createTableColumnWidthListener() {
            return new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    StripedViewport.this.repaint();
                }
            };
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.paintStripedBackground(g);
            this.paintVerticalGridLines(g);
            super.paintComponent(g);
        }

        private void paintStripedBackground(Graphics g) {
            int currentRow;
            int rowAtPoint = this.fTable.rowAtPoint(g.getClipBounds().getLocation());
            int topY = rowAtPoint < 0 ? g.getClipBounds().y : this.fTable.getCellRect((int)rowAtPoint, (int)0, (boolean)true).y;
            int n = currentRow = rowAtPoint < 0 ? 0 : rowAtPoint;
            while (topY < g.getClipBounds().y + g.getClipBounds().height) {
                int bottomY = topY + this.fTable.getRowHeight();
                g.setColor(this.getRowColor(currentRow));
                g.fillRect(g.getClipBounds().x, topY, g.getClipBounds().width, bottomY);
                topY = bottomY;
                ++currentRow;
            }
        }

        private Color getRowColor(int row) {
            return row % 2 == 0 ? EVEN_ROW_COLOR : this.getBackground();
        }

        private void paintVerticalGridLines(Graphics g) {
            int x = 0;
            for (int i = 0; i < this.fTable.getColumnCount(); ++i) {
                TableColumn column = this.fTable.getColumnModel().getColumn(i);
                g.setColor(TABLE_GRID_COLOR);
                g.drawLine((x += column.getWidth()) - 1, g.getClipBounds().y, x - 1, this.getHeight());
            }
        }
    }
}

