/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.util;

import de.ipk_gatersleben.bit.bi.edal.aspectj.security.GrantableMethods;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityException;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.StackTraceUtil;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class PrincipalUtil {
    public static Principal getInstance(String classname, String username) {
        Class<?> c = null;
        Constructor<?> con = null;
        Principal principal = null;
        try {
            c = Class.forName(classname);
            con = c.getConstructor(String.class);
            principal = (Principal)con.newInstance(username);
            return principal;
        }
        catch (Exception e) {
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
            return null;
        }
    }

    public static boolean checkPermission(ClientPrimaryDataEntity dataentry, String principalname, String username, String methodname) {
        try {
            Map<Principal, List<GrantableMethods.Methods>> permissionmap = dataentry.getPermissions();
            if (permissionmap != null) {
                for (Map.Entry<Principal, List<GrantableMethods.Methods>> entry : permissionmap.entrySet()) {
                    Principal key = entry.getKey();
                    if (!key.getName().equals(username) || !key.getClass().getName().equals(principalname)) continue;
                    List<GrantableMethods.Methods> value = entry.getValue();
                    for (GrantableMethods.Methods method : value) {
                        if (!method.toString().equals(methodname)) continue;
                        return true;
                    }
                }
            }
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
            JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e.getMessage(), "EdalFileChooser", 0);
        }
        catch (PrimaryDataEntityException e) {
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
            JOptionPane.showMessageDialog(null, "Call Edal server function exception:" + e.getMessage(), "EdalFileChooser", 0);
        }
        return false;
    }

    public static boolean checkPermission(ClientPrimaryDataEntity dataentry, String username, String methodname) {
        try {
            Map<Principal, List<GrantableMethods.Methods>> permissionmap = dataentry.getPermissions();
            if (permissionmap != null) {
                for (Map.Entry<Principal, List<GrantableMethods.Methods>> entry : permissionmap.entrySet()) {
                    Principal key = entry.getKey();
                    if (!key.getName().equals(username)) continue;
                    List<GrantableMethods.Methods> value = entry.getValue();
                    for (GrantableMethods.Methods method : value) {
                        if (!method.toString().equals(methodname)) continue;
                        return true;
                    }
                }
            }
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
            JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e.getMessage(), "EdalFileChooser", 0);
        }
        catch (PrimaryDataEntityException e) {
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
            JOptionPane.showMessageDialog(null, "Call Edal server function exception:" + e.getMessage(), "EdalFileChooser", 0);
        }
        return false;
    }
}

