/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.util;

import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalLoginHelper;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.ImageUtil;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.XStatusLabel;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.XStatusMessageLabel;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.XStatusSeparator;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.XStatusTimeLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.TexturePaint;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class XStatusBar
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Image backgroundLeftImage = ImageUtil.getImage("statusbar_background_left.png");
    private Image backgroundRightImage = ImageUtil.getImage("statusbar_background_right.png");
    private ImageIcon backgroundImageIcon = ImageUtil.createImageIcon("statusbar_background.png", "");
    private TexturePaint paint = ImageUtil.createTexturePaint("outlook_bar_background.png");
    private JPanel leftPane = new JPanel(new BorderLayout());
    private JPanel rightPane = new JPanel(new FlowLayout(3, 0, 0));
    private Border border = BorderFactory.createEmptyBorder(2, 10, 0, 0);
    private XStatusLabel serverinfo;
    private XStatusLabel userinfo;

    public XStatusBar() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.leftPane, "Center");
        this.add((Component)this.rightPane, "East");
        this.setBorder(this.border);
        this.leftPane.setOpaque(false);
        this.rightPane.setOpaque(false);
        this.addDefaultSubLabel();
    }

    private void addDefaultSubLabel() {
        this.leftPane.add((Component)new XStatusMessageLabel(), "Center");
        this.addSeparator();
        this.serverinfo = new XStatusLabel(EdalLoginHelper.serveraddress + ":" + EdalLoginHelper.serverport, ImageUtil.createImageIcon("server_12x12.png", ""));
        this.rightPane.add(this.serverinfo);
        this.addSeparator();
        this.userinfo = new XStatusLabel(EdalLoginHelper.username, ImageUtil.createImageIcon("user_12x12.png", ""));
        this.rightPane.add(this.userinfo);
        this.addSeparator();
        this.rightPane.add(new XStatusTimeLabel());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(this.paint);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.drawImage(this.backgroundLeftImage, 0, 0, null);
        g2d.drawImage(this.backgroundRightImage, this.getWidth() - this.backgroundRightImage.getWidth(null), 0, null);
    }

    public JPanel getLeftPane() {
        return this.leftPane;
    }

    public JPanel getRightPane() {
        return this.rightPane;
    }

    public void addSeparator() {
        this.rightPane.add(new XStatusSeparator());
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, this.backgroundImageIcon.getIconHeight() - 5);
    }

    public void updateStatus() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                XStatusBar.this.serverinfo.setText(EdalLoginHelper.serveraddress + ":" + EdalLoginHelper.serverport);
                XStatusBar.this.userinfo.setText(EdalLoginHelper.username);
            }
        };
        thread.start();
    }
}

