/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.sample.gui;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFileException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.EdalConfigDialog;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.EdalFileChooser;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor.MetaDataSaveDialog;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalLoginHelper;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.StackTraceUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.security.AccessControlException;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Main {
    public static JFrame frame;
    public static JFrame externalframe;
    private static JTextField localpathtext;
    private static JTextField localfilenametext;
    private static ClientPrimaryDataEntity fileobjtoupload;
    private static Map<EnumDublinCoreElements, UntypedData> metadatavalue;
    private static EdalLoginHelper loginhelper;
    private static LookAndFeel defalutskin;
    static Action openfileAction;
    static Action opendirAction;
    static Action selectlocalpathAction;
    static Action selectlocalfileAction;
    static Action uploadAction;

    private static void savefiletolocal(ClientPrimaryDataEntity remotefile) {
        try {
            if (localpathtext.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(null, "Please choose a directory to save the file!", "Demo", 0);
                return;
            }
            File file = new File(localpathtext.getText().trim() + File.separator + remotefile.getName());
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e1) {
                    ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                }
            } else {
                Object[] buttons = new String[]{"Yes", "No"};
                int rc = JOptionPane.showOptionDialog(null, "Do you want to overwrite file:" + file.getName(), "Demo", 1, 0, null, buttons, buttons[0]);
                if (rc != 0) {
                    return;
                }
            }
            FileOutputStream out = new FileOutputStream(file);
            ((ClientPrimaryDataFile)remotefile).read(out);
            JOptionPane.showMessageDialog(null, "Save File " + remotefile.getName() + " succeed!", "Demo", 1);
        }
        catch (FileNotFoundException e1) {
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
            JOptionPane.showMessageDialog(null, "Can't find file:" + localpathtext.getText().trim() + "!", "Demo", 0);
        }
        catch (IOException e1) {
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
            JOptionPane.showMessageDialog(null, "Can't operate File:" + localpathtext.getText().trim() + "!", "Demo", 0);
        }
        catch (PrimaryDataFileException e) {
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
            JOptionPane.showMessageDialog(null, "Edal server Exception:" + e.getMessage(), "Demo", 0);
        }
    }

    public static void main(String[] args) {
        System.out.println("e!DAL FileChooser GUI\nCopyright (c) 2013, IPK-Gatersleben.\nAll rights reserved.\n");
        defalutskin = UIManager.getLookAndFeel();
        loginhelper = new EdalLoginHelper();
        boolean islogin = loginhelper.startlogin();
        if (!islogin) {
            EdalConfigDialog eDALConfigUi = new EdalConfigDialog();
            int returnVal = eDALConfigUi.showOpenDialog();
            if (returnVal == 0) {
                loginhelper.savedata(eDALConfigUi.getServeraddress(), eDALConfigUi.getServerport(), eDALConfigUi.getUsername(), eDALConfigUi.getPassword());
                if (EdalConfigDialog.client == null) {
                    if (args.length == 0) {
                        System.exit(0);
                    } else {
                        frame.dispose();
                    }
                }
            } else if (args.length == 0) {
                System.exit(0);
            } else {
                frame.dispose();
            }
        }
        frame = new JFrame("Demo");
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel p1 = new JPanel();
        p1.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.1;
        p1.add((Component)new JButton(openfileAction), c);
        c.fill = 2;
        c.gridwidth = 2;
        c.gridx = 1;
        c.gridy = 0;
        localpathtext = new JTextField();
        p1.add((Component)localpathtext, c);
        localpathtext.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        c.fill = 2;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        JButton selectlocalpathbtn = new JButton(selectlocalpathAction);
        p1.add((Component)selectlocalpathbtn, c);
        tabbedPane.addTab("Get file from EDAL", p1);
        JPanel p2 = new JPanel();
        p2.setLayout(new GridBagLayout());
        c.fill = 2;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.1;
        p2.add((Component)new JButton(opendirAction), c);
        c.fill = 2;
        c.gridwidth = 2;
        c.gridx = 1;
        c.gridy = 0;
        localfilenametext = new JTextField();
        p2.add((Component)localfilenametext, c);
        c.fill = 2;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        JButton selectremotepathbtn = new JButton(selectlocalfileAction);
        p2.add((Component)selectremotepathbtn, c);
        c.fill = 2;
        c.gridwidth = 1;
        c.gridx = 1;
        c.gridy = 1;
        JButton saveremotebtn = new JButton(uploadAction);
        p2.add((Component)saveremotebtn, c);
        tabbedPane.addTab("Upload file to EDAL", p2);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)tabbedPane, "Center");
        frame.setSize(600, 300);
        frame.setLocationRelativeTo(null);
        if (args.length == 0) {
            frame.setDefaultCloseOperation(3);
        } else {
            frame.setDefaultCloseOperation(0);
            frame.addWindowListener(Main.createAppCloser());
        }
        frame.setVisible(true);
    }

    public static void externalcall(JFrame externalframe) {
        Main.externalframe = externalframe;
        Main.externalframe.setEnabled(false);
        Main.main(new String[]{""});
    }

    private static WindowListener createAppCloser() {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                frame.dispose();
                externalframe.setEnabled(true);
                if (defalutskin != null) {
                    try {
                        UIManager.setLookAndFeel(defalutskin);
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    static {
        loginhelper = null;
        openfileAction = new AbstractAction("Open EDAL File"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientPrimaryDataEntity[] files;
                Window window = frame.getContentPane() instanceof Window ? (Window)frame.getContentPane() : SwingUtilities.getWindowAncestor(frame.getContentPane());
                EdalFileChooser dlg = window instanceof Frame ? new EdalFileChooser((Frame)window, EdalLoginHelper.rootDirectory, EdalLoginHelper.client) : new EdalFileChooser((Dialog)window, EdalLoginHelper.rootDirectory, EdalLoginHelper.client);
                dlg.setMultiSelectionEnabled(true);
                dlg.setFileSelectionMode(2);
                int returnVal = dlg.showOpenDialog();
                if (returnVal == 0 && (files = dlg.getSelectedFiles()) != null) {
                    for (ClientPrimaryDataEntity file : files) {
                        try {
                            if (file == null || file.isDirectory()) continue;
                            Main.savefiletolocal(file);
                        }
                        catch (RemoteException e1) {
                            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                            JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e1.getMessage(), "Demo", 0);
                        }
                    }
                }
            }
        };
        opendirAction = new AbstractAction("Choose EDAL Path"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Window window = frame.getContentPane() instanceof Window ? (Window)frame.getContentPane() : SwingUtilities.getWindowAncestor(frame.getContentPane());
                EdalFileChooser dlg = window instanceof Frame ? new EdalFileChooser((Frame)window, EdalLoginHelper.rootDirectory, EdalLoginHelper.client) : new EdalFileChooser((Dialog)window, EdalLoginHelper.rootDirectory, EdalLoginHelper.client);
                dlg.setFileSelectionMode(2);
                int returnVal = dlg.showSaveDialog();
                if (returnVal == 0) {
                    fileobjtoupload = dlg.getSelectedFile();
                }
            }
        };
        selectlocalpathAction = new AbstractAction("Choose path to download"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String dir = "";
                Component parent = null;
                JFileChooser chooser = new JFileChooser(dir);
                chooser.setFileSelectionMode(1);
                if (chooser.showSaveDialog(parent) == 0 && (dir = chooser.getSelectedFile().getAbsolutePath()) != null) {
                    localpathtext.setText(dir);
                }
            }
        };
        selectlocalfileAction = new AbstractAction("Select Local File"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileopen = new JFileChooser();
                int ret = fileopen.showOpenDialog(null);
                if (ret == 0) {
                    File file = fileopen.getSelectedFile();
                    localfilenametext.setText(file.getPath());
                }
            }
        };
        uploadAction = new AbstractAction("Upload"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (fileobjtoupload != null && localfilenametext.getText().trim().length() > 0) {
                    try {
                        block36: {
                            File inputFile = new File(localfilenametext.getText().trim());
                            FileInputStream in = new FileInputStream(inputFile);
                            if (fileobjtoupload.isDirectory()) {
                                ClientPrimaryDataDirectory dir = (ClientPrimaryDataDirectory)fileobjtoupload;
                                if (dir.exist(inputFile.getName())) {
                                    Object[] buttons = new String[]{"Yes", "No"};
                                    int rc = JOptionPane.showOptionDialog(null, "Do you want to update version?", "Demo", 1, 0, null, buttons, buttons[0]);
                                    if (rc != 0) {
                                        return;
                                    }
                                    ClientPrimaryDataFile file = (ClientPrimaryDataFile)dir.getPrimaryDataEntity(inputFile.getName());
                                    try {
                                        file.store(in);
                                        MetaDataSaveDialog metadlg = new MetaDataSaveDialog(file);
                                        int returnVal = metadlg.showOpenDialog();
                                        if (returnVal == 0) {
                                            metadatavalue = metadlg.getMetadatavalue();
                                        } else {
                                            metadatavalue = null;
                                        }
                                        if (metadatavalue == null) break block36;
                                        try {
                                            MetaData fileMetaData = file.getMetaData().clone();
                                            for (Map.Entry entry : metadatavalue.entrySet()) {
                                                EnumDublinCoreElements key = (EnumDublinCoreElements)entry.getKey();
                                                UntypedData val = (UntypedData)entry.getValue();
                                                fileMetaData.setElementValue(key, val);
                                            }
                                            file.setMetaData(fileMetaData);
                                        }
                                        catch (Exception re) {
                                            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(re));
                                            JOptionPane.showMessageDialog(null, re.getMessage(), "Demo", 0);
                                        }
                                    }
                                    catch (AccessControlException se) {
                                        ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(se));
                                        JOptionPane.showMessageDialog(null, "Call Edal server function exception:" + se.getMessage(), "Demo", 0);
                                    }
                                } else {
                                    try {
                                        ClientPrimaryDataFile file = dir.createPrimaryDataFile(inputFile.getName());
                                        file.store(in);
                                        MetaDataSaveDialog metadlg = new MetaDataSaveDialog(file);
                                        int returnVal = metadlg.showOpenDialog();
                                        if (returnVal == 0) {
                                            metadatavalue = metadlg.getMetadatavalue();
                                        } else {
                                            metadatavalue = null;
                                        }
                                        if (metadatavalue == null) break block36;
                                        try {
                                            MetaData fileMetaData = file.getMetaData().clone();
                                            for (Map.Entry entry : metadatavalue.entrySet()) {
                                                EnumDublinCoreElements key = (EnumDublinCoreElements)entry.getKey();
                                                if (key == EnumDublinCoreElements.TYPE || key == EnumDublinCoreElements.SIZE) continue;
                                                UntypedData val = (UntypedData)entry.getValue();
                                                fileMetaData.setElementValue(key, val);
                                            }
                                            file.setMetaData(fileMetaData);
                                        }
                                        catch (Exception re) {
                                            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(re));
                                            JOptionPane.showMessageDialog(null, re.getMessage(), "Demo", 0);
                                        }
                                    }
                                    catch (AccessControlException se) {
                                        ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(se));
                                        JOptionPane.showMessageDialog(null, "Call Edal server function exception:" + se.getMessage(), "Demo", 0);
                                    }
                                }
                            } else {
                                Object[] buttons = new String[]{"Yes", "No"};
                                int rc = JOptionPane.showOptionDialog(null, "Do you want to update version?", "Demo", 1, 0, null, buttons, buttons[0]);
                                if (rc != 0) {
                                    return;
                                }
                                try {
                                    ((ClientPrimaryDataFile)fileobjtoupload).store(in);
                                    MetaDataSaveDialog metadlg = new MetaDataSaveDialog(fileobjtoupload);
                                    int returnVal = metadlg.showOpenDialog();
                                    if (returnVal == 0) {
                                        metadatavalue = metadlg.getMetadatavalue();
                                    } else {
                                        metadatavalue = null;
                                    }
                                    if (metadatavalue != null) {
                                        try {
                                            MetaData fileMetaData = fileobjtoupload.getMetaData().clone();
                                            for (Map.Entry entry : metadatavalue.entrySet()) {
                                                EnumDublinCoreElements key = (EnumDublinCoreElements)entry.getKey();
                                                if (key == EnumDublinCoreElements.TYPE || key == EnumDublinCoreElements.SIZE) continue;
                                                UntypedData val = (UntypedData)entry.getValue();
                                                fileMetaData.setElementValue(key, val);
                                            }
                                            fileobjtoupload.setMetaData(fileMetaData);
                                        }
                                        catch (Exception re) {
                                            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(re));
                                            JOptionPane.showMessageDialog(null, re.getMessage(), "Demo", 0);
                                        }
                                    }
                                }
                                catch (AccessControlException se) {
                                    ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(se));
                                    JOptionPane.showMessageDialog(null, "Call Edal server function exception:" + se.getMessage(), "Demo", 0);
                                }
                            }
                        }
                        JOptionPane.showMessageDialog(null, "Upload Data succeed!", "Demo", 1);
                    }
                    catch (FileNotFoundException e1) {
                        ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                        JOptionPane.showMessageDialog(null, "Can't find file:" + localfilenametext.getText().trim() + "!", "Demo", 0);
                    }
                    catch (IOException e1) {
                        ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                        JOptionPane.showMessageDialog(null, "Can't operate File:" + localfilenametext.getText().trim() + "!", "Demo", 0);
                    }
                    catch (Exception e1) {
                        ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                        JOptionPane.showMessageDialog(null, e1.getMessage(), "Demo", 0);
                    }
                } else if (fileobjtoupload == null) {
                    JOptionPane.showMessageDialog(null, "Please choose the edal path you want to upload!", "Demo", 0);
                } else {
                    JOptionPane.showMessageDialog(null, "Please choose the file you want to upload!", "Demo", 0);
                }
            }
        };
    }
}

