/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.sample;

import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfiguration;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.webdav.sample.AppContextBuilder;
import de.ipk_gatersleben.bit.bi.edal.webdav.sample.Main;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.FileSystemCache;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.jetty.http.ssl.SslContextFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.ssl.SslSocketConnector;

public class WebdavServer {
    private Server server;
    private static int EDAL_PORT = 0;
    private static String EDAL_HOST = "";
    private static int WEBDAV_SSLPORT = 8443;

    public WebdavServer() {
        Properties prop = new Properties();
        try {
            prop.load(Main.class.getResourceAsStream("/eDALwebDAV.properties"));
            EDAL_HOST = prop.getProperty("server.host");
            EDAL_PORT = Integer.parseInt(prop.getProperty("server.port"));
            WEBDAV_SSLPORT = Integer.parseInt(prop.getProperty("browser.sslport"));
        }
        catch (IOException e) {
            ClientDataManager.logger.fatal((Object)"error loading default WebDAV properties", (Throwable)e);
            System.exit(-1);
        }
        this.server = new Server(WEBDAV_SSLPORT);
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePassword("eDALkey");
        sslContextFactory.setKeyStore(EdalConfiguration.KEY_STORE_PATH.toString());
        SslSocketConnector sslConnector = new SslSocketConnector(sslContextFactory);
        sslConnector.setPort(WEBDAV_SSLPORT);
        this.server.setConnectors(new Connector[]{sslConnector});
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(new Handler[]{new AppContextBuilder().buildWebAppContext()});
        this.server.setHandler((Handler)contexts);
    }

    public void start() throws Exception {
        FileSystemCache.init();
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
        this.server.join();
    }

    public boolean isStarted() {
        return this.server.isStarted();
    }

    public boolean isStopped() {
        return this.server.isStopped();
    }
}

