/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.wrapper;

import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import io.milton.http.Auth;
import io.milton.http.AuthenticationService;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.Response;
import io.milton.http.entity.BufferingGetableResourceEntity;
import io.milton.http.entity.GetableResourceEntity;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.http.http11.Bufferable;
import io.milton.http.http11.CacheControlHelper;
import io.milton.http.http11.ContentGenerator;
import io.milton.http.http11.DefaultCacheControlHelper;
import io.milton.http.http11.DefaultHttp11ResponseHandler;
import io.milton.http.http11.ETagGenerator;
import io.milton.http.http11.Http11ResponseHandler;
import io.milton.http.http11.SimpleContentGenerator;
import io.milton.resource.GetableResource;
import io.milton.resource.Resource;
import io.milton.sso.ExternalIdentityProvider;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class EdalHttp11ResponseHandler
implements Http11ResponseHandler,
Bufferable {
    private static String miltonVerson;
    private final AuthenticationService authenticationService;
    private final ETagGenerator eTagGenerator;
    private CacheControlHelper cacheControlHelper;
    private ContentGenerator contentGenerator;
    private int maxMemorySize;
    private DefaultHttp11ResponseHandler.BUFFERING buffering;

    public EdalHttp11ResponseHandler(AuthenticationService authenticationService, ETagGenerator eTagGenerator) {
        Properties props = new Properties();
        try {
            props.load(ClientDataManager.class.getResourceAsStream("/milton.properties"));
        }
        catch (IOException ex) {
            ClientDataManager.logger.warn((Object)"Failed lot load milton properties file", (Throwable)ex);
        }
        miltonVerson = props.getProperty("milton.version");
        this.cacheControlHelper = new DefaultCacheControlHelper();
        this.contentGenerator = new SimpleContentGenerator();
        this.maxMemorySize = 100000;
        this.authenticationService = authenticationService;
        this.eTagGenerator = eTagGenerator;
    }

    public CacheControlHelper getCacheControlHelper() {
        return this.cacheControlHelper;
    }

    public void setCacheControlHelper(CacheControlHelper cacheControlHelper) {
        this.cacheControlHelper = cacheControlHelper;
    }

    public String generateEtag(Resource r) {
        return this.eTagGenerator.generateEtag(r);
    }

    public void respondWithOptions(Resource resource, Response response, Request request, List<String> methodsAllowed) {
        this.setRespondCommonHeaders(response, resource, Response.Status.SC_OK, request.getAuthorization());
        response.setAllowHeader(methodsAllowed);
        response.setContentLengthHeader(Long.valueOf(0L));
    }

    public void respondNotFound(Response response, Request request) {
        response.setStatus(Response.Status.SC_NOT_FOUND);
        response.setContentTypeHeader("text/html");
        this.contentGenerator.generate(null, request, response, Response.Status.SC_NOT_FOUND);
    }

    public void respondUnauthorised(Resource resource, Response response, Request request) {
        if (this.authenticationService.canUseExternalAuth(resource, request)) {
            ClientDataManager.logger.info((Object)"respondUnauthorised: use external authentication");
            this.initiateExternalAuth(resource, request, response);
        } else {
            ClientDataManager.logger.info((Object)("respondUnauthorised: return staus: " + Response.Status.SC_UNAUTHORIZED));
            if (request.getAuthorization() != null && request.getAuthorization().getTag() != null) {
                response.setStatus(Response.Status.SC_METHOD_NOT_ALLOWED);
            } else {
                response.setStatus(Response.Status.SC_UNAUTHORIZED);
            }
            List challenges = this.authenticationService.getChallenges(resource, request);
            response.setAuthenticateHeader(challenges);
        }
    }

    public void respondMethodNotImplemented(Resource resource, Response response, Request request) {
        response.setStatus(Response.Status.SC_NOT_IMPLEMENTED);
        this.contentGenerator.generate(resource, request, response, Response.Status.SC_NOT_IMPLEMENTED);
    }

    public void respondMethodNotAllowed(Resource res, Response response, Request request) {
        ClientDataManager.logger.debug((Object)("method not allowed. handler: " + this.getClass().getName() + " resource: " + res.getClass().getName()));
        response.setStatus(Response.Status.SC_METHOD_NOT_ALLOWED);
        this.contentGenerator.generate(res, request, response, Response.Status.SC_METHOD_NOT_ALLOWED);
    }

    public void respondConflict(Resource resource, Response response, Request request, String message) {
        ClientDataManager.logger.debug((Object)"respondConflict");
        response.setStatus(Response.Status.SC_CONFLICT);
        this.contentGenerator.generate(resource, request, response, Response.Status.SC_CONFLICT);
    }

    public void respondServerError(Request request, Response response, String reason) {
        response.setStatus(Response.Status.SC_INTERNAL_SERVER_ERROR);
        this.contentGenerator.generate(null, request, response, Response.Status.SC_INTERNAL_SERVER_ERROR);
    }

    public void respondRedirect(Response response, Request request, String redirectUrl) {
        if (redirectUrl == null) {
            throw new NullPointerException("redirectUrl cannot be null");
        }
        ClientDataManager.logger.trace((Object)"respondRedirect");
        response.sendRedirect(redirectUrl);
    }

    public void respondExpectationFailed(Response response, Request request) {
        response.setStatus(Response.Status.SC_EXPECTATION_FAILED);
    }

    public void respondCreated(Resource resource, Response response, Request request) {
        this.setRespondCommonHeaders(response, resource, Response.Status.SC_CREATED, request.getAuthorization());
    }

    public void respondNoContent(Resource resource, Response response, Request request) {
        this.setRespondCommonHeaders(response, resource, Response.Status.SC_NO_CONTENT, request.getAuthorization());
    }

    public void respondPartialContent(GetableResource resource, Response response, Request request, Map<String, String> params, Range range) throws NotAuthorizedException, BadRequestException, NotFoundException {
        String acc;
        String ct;
        ClientDataManager.logger.debug((Object)("respondPartialContent: " + range.getStart() + " - " + range.getFinish()));
        response.setStatus(Response.Status.SC_PARTIAL_CONTENT);
        response.setContentRangeHeader(range.getStart(), range.getFinish(), resource.getContentLength());
        response.setDateHeader(new Date());
        String etag = this.eTagGenerator.generateEtag((Resource)resource);
        if (etag != null) {
            response.setEtag(etag);
        }
        if ((ct = resource.getContentType(acc = request.getAcceptHeader())) != null) {
            response.setContentTypeHeader(ct);
        }
        response.setEntity((Response.Entity)new GetableResourceEntity(resource, range, params, ct));
    }

    public void respondHead(Resource resource, Response response, Request request) {
        this.setRespondContentCommonHeaders(response, resource, Response.Status.SC_OK, request.getAuthorization());
        if (!(resource instanceof GetableResource)) {
            return;
        }
        GetableResource gr = (GetableResource)resource;
        Long contentLength = gr.getContentLength();
        if (contentLength != null) {
            response.setContentLengthHeader(contentLength);
        } else {
            ClientDataManager.logger.trace((Object)"No content length is available for HEAD request");
        }
        String acc = request.getAcceptHeader();
        String ct = gr.getContentType(acc);
        if (ct != null && (ct = this.pickBestContentType(ct)) != null) {
            response.setContentTypeHeader(ct);
        }
    }

    public void respondContent(Resource resource, Response response, Request request, Map<String, String> params) throws NotAuthorizedException, BadRequestException, NotFoundException {
        ClientDataManager.logger.debug((Object)("respondContent: " + resource.getClass()));
        Auth auth = request.getAuthorization();
        this.setRespondContentCommonHeaders(response, resource, auth);
        if (resource instanceof GetableResource) {
            boolean doBuffering;
            GetableResource gr = (GetableResource)resource;
            String acc = request.getAcceptHeader();
            String ct = gr.getContentType(acc);
            if (ct != null) {
                ct = this.pickBestContentType(ct);
                response.setContentTypeHeader(ct);
            }
            this.cacheControlHelper.setCacheControl(gr, response, request.getAuthorization());
            Long contentLength = gr.getContentLength();
            if (this.buffering == null || this.buffering == DefaultHttp11ResponseHandler.BUFFERING.whenNeeded) {
                doBuffering = contentLength == null;
            } else {
                boolean bl = doBuffering = this.buffering == DefaultHttp11ResponseHandler.BUFFERING.always;
            }
            if (!doBuffering) {
                ClientDataManager.logger.trace((Object)("sending content with known content length: " + contentLength));
                if (contentLength != null) {
                    response.setContentLengthHeader(contentLength);
                }
                response.setEntity((Response.Entity)new GetableResourceEntity(gr, params, ct));
            } else {
                response.setEntity((Response.Entity)new BufferingGetableResourceEntity(gr, params, ct, contentLength, this.getMaxMemorySize()));
            }
        }
    }

    public void respondNotModified(GetableResource resource, Response response, Request request) {
        ClientDataManager.logger.trace((Object)"respondNotModified");
        response.setStatus(Response.Status.SC_NOT_MODIFIED);
        response.setDateHeader(new Date());
        String etag = this.eTagGenerator.generateEtag((Resource)resource);
        if (etag != null) {
            response.setEtag(etag);
        }
        Date modDate = resource.getModifiedDate();
        response.setLastModifiedHeader(modDate);
        this.cacheControlHelper.setCacheControl(resource, response, request.getAuthorization());
    }

    protected void setRespondContentCommonHeaders(Response response, Resource resource, Auth auth) {
        this.setRespondContentCommonHeaders(response, resource, Response.Status.SC_OK, auth);
    }

    protected void setRespondContentCommonHeaders(Response response, Resource resource, Response.Status status, Auth auth) {
        this.setRespondCommonHeaders(response, resource, status, auth);
        EdalHttp11ResponseHandler.setModifiedDate(response, resource, auth);
    }

    protected void setRespondCommonHeaders(Response response, Resource resource, Response.Status status, Auth auth) {
        response.setStatus(status);
        response.setNonStandardHeader("Server", "milton.io-" + miltonVerson);
        response.setDateHeader(new Date());
        String etag = this.eTagGenerator.generateEtag(resource);
        if (etag != null) {
            response.setEtag(etag);
        }
    }

    public static void setModifiedDate(Response response, Resource resource, Auth auth) {
        Date modDate = resource.getModifiedDate();
        if (modDate != null) {
            response.setLastModifiedHeader(modDate);
        }
    }

    public void respondBadRequest(Resource resource, Response response, Request request) {
        response.setStatus(Response.Status.SC_BAD_REQUEST);
    }

    public void respondForbidden(Resource resource, Response response, Request request) {
        response.setStatus(Response.Status.SC_FORBIDDEN);
    }

    public void respondDeleteFailed(Request request, Response response, Resource resource, Response.Status status) {
        response.setStatus(status);
    }

    public void respondPreconditionFailed(Request request, Response response, Resource resource) {
        response.setStatus(Response.Status.SC_PRECONDITION_FAILED);
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public int getMaxMemorySize() {
        return this.maxMemorySize;
    }

    public void setMaxMemorySize(int maxMemorySize) {
        this.maxMemorySize = maxMemorySize;
    }

    public DefaultHttp11ResponseHandler.BUFFERING getBuffering() {
        return this.buffering;
    }

    public void setBuffering(DefaultHttp11ResponseHandler.BUFFERING buffering) {
        this.buffering = buffering;
    }

    private String pickBestContentType(String ct) {
        if (ct == null) {
            return null;
        }
        if (ct.contains(",")) {
            return ct.split(",")[0];
        }
        return ct;
    }

    public void initiateExternalAuth(Resource resource, Request request, Response response) {
        ExternalIdentityProvider eip = this.getSelectedIP(request);
        if (eip != null) {
            eip.initiateExternalAuth(resource, request, response);
        }
    }

    private ExternalIdentityProvider getSelectedIP(Request request) {
        List list = this.authenticationService.getExternalIdentityProviders();
        if (list.size() == 1) {
            return (ExternalIdentityProvider)list.get(0);
        }
        String ipName = (String)request.getParams().get("_ip");
        if (ipName != null && ipName.length() > 0) {
            for (ExternalIdentityProvider eip : list) {
                if (!ipName.equals(eip.getName())) continue;
                return eip;
            }
        }
        return null;
    }

    public ContentGenerator getContentGenerator() {
        return this.contentGenerator;
    }

    public void setContentGenerator(ContentGenerator contentGenerator) {
        this.contentGenerator = contentGenerator;
    }
}

