/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.wrapper;

import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.EdalHttp11ResponseHandler;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.EdalInitListener;
import io.milton.common.Stoppable;
import io.milton.event.EventManager;
import io.milton.event.EventManagerImpl;
import io.milton.http.AuthenticationHandler;
import io.milton.http.AuthenticationService;
import io.milton.http.CompressingResponseHandler;
import io.milton.http.Filter;
import io.milton.http.HandlerHelper;
import io.milton.http.HttpExtension;
import io.milton.http.HttpManager;
import io.milton.http.ProtocolHandlers;
import io.milton.http.ResourceFactory;
import io.milton.http.ResourceHandlerHelper;
import io.milton.http.SecurityManager;
import io.milton.http.StandardFilter;
import io.milton.http.UrlAdapter;
import io.milton.http.UrlAdapterImpl;
import io.milton.http.WellKnownResourceFactory;
import io.milton.http.acl.ACLProtocol;
import io.milton.http.acl.AccessControlledResourceTypeHelper;
import io.milton.http.caldav.CalDavProtocol;
import io.milton.http.caldav.CalendarResourceTypeHelper;
import io.milton.http.carddav.AddressBookResourceTypeHelper;
import io.milton.http.carddav.CardDavProtocol;
import io.milton.http.entity.DefaultEntityTransport;
import io.milton.http.entity.EntityTransport;
import io.milton.http.fck.FckResourceFactory;
import io.milton.http.fs.FileSystemResourceFactory;
import io.milton.http.fs.SimpleSecurityManager;
import io.milton.http.http11.DefaultETagGenerator;
import io.milton.http.http11.DefaultHttp11ResponseHandler;
import io.milton.http.http11.ETagGenerator;
import io.milton.http.http11.Http11Protocol;
import io.milton.http.http11.Http11ResponseHandler;
import io.milton.http.http11.MatchHelper;
import io.milton.http.http11.PartialGetHelper;
import io.milton.http.http11.auth.BasicAuthHandler;
import io.milton.http.http11.auth.CookieAuthenticationHandler;
import io.milton.http.http11.auth.DigestAuthenticationHandler;
import io.milton.http.http11.auth.ExpiredNonceRemover;
import io.milton.http.http11.auth.FormAuthenticationHandler;
import io.milton.http.http11.auth.LoginResponseHandler;
import io.milton.http.http11.auth.Nonce;
import io.milton.http.http11.auth.NonceProvider;
import io.milton.http.http11.auth.SimpleMemoryNonceProvider;
import io.milton.http.json.JsonResourceFactory;
import io.milton.http.quota.QuotaDataAccessor;
import io.milton.http.values.ValueWriters;
import io.milton.http.webdav.DefaultUserAgentHelper;
import io.milton.http.webdav.DefaultWebDavResponseHandler;
import io.milton.http.webdav.PropFindXmlGenerator;
import io.milton.http.webdav.PropPatchSetter;
import io.milton.http.webdav.PropertySourcePatchSetter;
import io.milton.http.webdav.ResourceTypeHelper;
import io.milton.http.webdav.UserAgentHelper;
import io.milton.http.webdav.WebDavProtocol;
import io.milton.http.webdav.WebDavResourceTypeHelper;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.property.BeanPropertyAuthoriser;
import io.milton.property.BeanPropertySource;
import io.milton.property.DefaultPropertyAuthoriser;
import io.milton.property.MultiNamespaceCustomPropertySource;
import io.milton.property.PropertyAuthoriser;
import io.milton.property.PropertySource;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class EdalHttpManagerBuilder {
    private List<EdalInitListener> listeners;
    private ResourceFactory mainResourceFactory;
    private ResourceFactory outerResourceFactory;
    private DefaultHttp11ResponseHandler.BUFFERING buffering;
    private List<AuthenticationHandler> authenticationHandlers;
    private List<AuthenticationHandler> cookieDelegateHandlers;
    private DigestAuthenticationHandler digestHandler;
    private BasicAuthHandler basicHandler;
    private CookieAuthenticationHandler cookieAuthenticationHandler;
    private FormAuthenticationHandler formAuthenticationHandler;
    private Map<UUID, Nonce> nonces = new ConcurrentHashMap<UUID, Nonce>();
    private int nonceValiditySeconds = 86400;
    private NonceProvider nonceProvider;
    private AuthenticationService authenticationService;
    private ExpiredNonceRemover expiredNonceRemover;
    private List<Stoppable> shutdownHandlers = new CopyOnWriteArrayList<Stoppable>();
    private ResourceTypeHelper resourceTypeHelper;
    private WebDavResponseHandler webdavResponseHandler;
    private HandlerHelper handlerHelper;
    private ArrayList<HttpExtension> protocols;
    private ProtocolHandlers protocolHandlers;
    private EntityTransport entityTransport = new DefaultEntityTransport();
    private List<WellKnownResourceFactory.WellKnownHandler> wellKnownHandlers;
    private EventManager eventManager = new EventManagerImpl();
    private PropertyAuthoriser propertyAuthoriser;
    private List<PropertySource> propertySources;
    private List<PropertySource> extraPropertySources;
    private ETagGenerator eTagGenerator = new DefaultETagGenerator();
    private Http11ResponseHandler http11ResponseHandler;
    private ValueWriters valueWriters = new ValueWriters();
    private PropFindXmlGenerator propFindXmlGenerator;
    private List<Filter> filters;
    private Filter defaultStandardFilter = new StandardFilter();
    private UrlAdapter urlAdapter = new UrlAdapterImpl();
    private QuotaDataAccessor quotaDataAccessor;
    private PropPatchSetter propPatchSetter;
    private boolean enableOptionsAuth = false;
    private ResourceHandlerHelper resourceHandlerHelper;
    private boolean initDone;
    private boolean enableCompression = true;
    private boolean enableWellKnown = true;
    private boolean enabledJson = true;
    private boolean enableBasicAuth = true;
    private boolean enableDigestAuth = true;
    private boolean enableFormAuth = true;
    private boolean enableCookieAuth = true;
    private boolean enabledCkBrowser = false;
    private String loginPage = "/login.html";
    private List<String> loginPageExcludePaths;
    private File rootDir = null;
    private SecurityManager securityManager;
    private String fsContextPath;
    private String fsRealm = "milton";
    private Map<String, String> mapOfNameAndPasswords;
    private String defaultUser = "user";
    private String defaultPassword = "password";
    private UserAgentHelper userAgentHelper;
    private MultiNamespaceCustomPropertySource multiNamespaceCustomPropertySource;
    private boolean multiNamespaceCustomPropertySourceEnabled = true;
    private BeanPropertySource beanPropertySource;
    private WebDavProtocol webDavProtocol;
    private CalDavProtocol calDavProtocol;
    private CardDavProtocol cardDavProtocol;
    private ACLProtocol aclProtocol;
    private boolean webdavEnabled = true;
    private boolean caldavEnabled = true;
    private boolean carddavEnabled = true;
    private boolean aclEnabled = true;
    private MatchHelper matchHelper;
    private PartialGetHelper partialGetHelper;
    private LoginResponseHandler loginResponseHandler;
    private LoginResponseHandler.LoginPageTypeHandler loginPageTypeHandler = new LoginResponseHandler.ContentTypeLoginPageTypeHandler();

    public final void init() {
        if (this.listeners != null) {
            for (EdalInitListener l : this.listeners) {
                l.beforeInit(this);
            }
        }
        if (this.mainResourceFactory == null) {
            this.rootDir = new File(System.getProperty("user.home"));
            if (!this.rootDir.exists() || !this.rootDir.isDirectory()) {
                throw new RuntimeException("Root directory is not valie: " + this.rootDir.getAbsolutePath());
            }
            if (this.securityManager == null) {
                if (this.mapOfNameAndPasswords == null) {
                    this.mapOfNameAndPasswords = new HashMap<String, String>();
                    this.mapOfNameAndPasswords.put(this.defaultUser, this.defaultPassword);
                }
                this.securityManager = new SimpleSecurityManager(this.fsRealm, this.mapOfNameAndPasswords);
            }
            ClientDataManager.logger.info((Object)("Using securityManager: " + this.securityManager.getClass()));
            this.mainResourceFactory = new FileSystemResourceFactory(this.rootDir, this.securityManager, this.fsContextPath);
            ClientDataManager.logger.info((Object)("Using file system with root directory: " + this.rootDir.getAbsolutePath()));
        }
        ClientDataManager.logger.info((Object)("Using mainResourceFactory: " + this.mainResourceFactory.getClass()));
        if (this.authenticationService == null) {
            if (this.authenticationHandlers == null) {
                this.authenticationHandlers = new ArrayList<AuthenticationHandler>();
                if (this.basicHandler == null && this.enableBasicAuth) {
                    this.basicHandler = new BasicAuthHandler();
                }
                if (this.basicHandler != null) {
                    this.authenticationHandlers.add((AuthenticationHandler)this.basicHandler);
                }
                if (this.digestHandler == null && this.enableDigestAuth) {
                    if (this.nonceProvider == null) {
                        if (this.expiredNonceRemover == null) {
                            this.expiredNonceRemover = new ExpiredNonceRemover(this.nonces, this.nonceValiditySeconds);
                            this.showLog("expiredNonceRemover", this.expiredNonceRemover);
                        }
                        this.nonceProvider = new SimpleMemoryNonceProvider(this.nonceValiditySeconds, this.expiredNonceRemover, this.nonces);
                        this.showLog("nonceProvider", this.nonceProvider);
                    }
                    this.digestHandler = new DigestAuthenticationHandler(this.nonceProvider);
                }
                if (this.digestHandler != null) {
                    this.authenticationHandlers.add((AuthenticationHandler)this.digestHandler);
                }
                if (this.formAuthenticationHandler == null && this.enableFormAuth) {
                    this.formAuthenticationHandler = new FormAuthenticationHandler();
                }
                if (this.formAuthenticationHandler != null) {
                    this.authenticationHandlers.add((AuthenticationHandler)this.formAuthenticationHandler);
                }
                if (this.cookieAuthenticationHandler == null && this.enableCookieAuth) {
                    if (this.cookieDelegateHandlers == null) {
                        this.cookieDelegateHandlers = new ArrayList<AuthenticationHandler>();
                        if (this.basicHandler != null) {
                            this.cookieDelegateHandlers.add((AuthenticationHandler)this.basicHandler);
                            this.authenticationHandlers.remove(this.basicHandler);
                        }
                        if (this.formAuthenticationHandler != null) {
                            this.cookieDelegateHandlers.add((AuthenticationHandler)this.formAuthenticationHandler);
                            this.authenticationHandlers.remove(this.formAuthenticationHandler);
                        }
                    }
                    this.cookieAuthenticationHandler = new CookieAuthenticationHandler(this.cookieDelegateHandlers, this.mainResourceFactory);
                    this.authenticationHandlers.add((AuthenticationHandler)this.cookieAuthenticationHandler);
                }
            }
            this.authenticationService = new AuthenticationService(this.authenticationHandlers);
            this.showLog("authenticationService", this.authenticationService);
        }
        this.init(this.authenticationService);
        this.shutdownHandlers.add((Stoppable)this.expiredNonceRemover);
        this.expiredNonceRemover.start();
    }

    private void init(AuthenticationService authenticationService) {
        if (this.resourceTypeHelper == null) {
            WebDavResourceTypeHelper webDavResourceTypeHelper = new WebDavResourceTypeHelper();
            AccessControlledResourceTypeHelper accessControlledResourceTypeHelper = new AccessControlledResourceTypeHelper((ResourceTypeHelper)webDavResourceTypeHelper);
            CalendarResourceTypeHelper calendarResourceTypeHelper = new CalendarResourceTypeHelper((ResourceTypeHelper)accessControlledResourceTypeHelper);
            this.resourceTypeHelper = new AddressBookResourceTypeHelper((ResourceTypeHelper)calendarResourceTypeHelper);
            this.showLog("resourceTypeHelper", this.resourceTypeHelper);
        }
        if (this.webdavResponseHandler == null) {
            if (this.propFindXmlGenerator == null) {
                this.propFindXmlGenerator = new PropFindXmlGenerator(this.valueWriters);
                this.showLog("propFindXmlGenerator", this.propFindXmlGenerator);
            }
            if (this.http11ResponseHandler == null) {
                this.http11ResponseHandler = new EdalHttp11ResponseHandler(authenticationService, this.eTagGenerator);
                this.showLog("http11ResponseHandler", this.http11ResponseHandler);
            }
            this.webdavResponseHandler = new DefaultWebDavResponseHandler(this.http11ResponseHandler, this.resourceTypeHelper, this.propFindXmlGenerator);
            if (this.enableCompression) {
                this.webdavResponseHandler = new CompressingResponseHandler(this.webdavResponseHandler);
                this.showLog("webdavResponseHandler", this.webdavResponseHandler);
            }
            if (this.enableFormAuth) {
                ClientDataManager.logger.info((Object)("form authentication is enabled, so wrap response handler with " + LoginResponseHandler.class));
                if (this.loginResponseHandler == null) {
                    this.loginResponseHandler = new LoginResponseHandler(this.webdavResponseHandler, this.mainResourceFactory, this.loginPageTypeHandler);
                    this.loginResponseHandler.setExcludePaths(this.loginPageExcludePaths);
                    this.loginResponseHandler.setLoginPage(this.loginPage);
                    this.webdavResponseHandler = this.loginResponseHandler;
                }
            }
        }
        this.init(authenticationService, this.webdavResponseHandler, this.resourceTypeHelper);
    }

    private void init(AuthenticationService authenticationService, WebDavResponseHandler webdavResponseHandler, ResourceTypeHelper resourceTypeHelper) {
        this.initDone = true;
        if (this.handlerHelper == null) {
            this.handlerHelper = new HandlerHelper(authenticationService);
            this.showLog("handlerHelper", this.handlerHelper);
        }
        if (this.resourceHandlerHelper == null) {
            this.resourceHandlerHelper = new ResourceHandlerHelper(this.handlerHelper, this.urlAdapter, (Http11ResponseHandler)webdavResponseHandler);
            this.showLog("resourceHandlerHelper", this.resourceHandlerHelper);
        }
        if (this.protocols == null) {
            this.protocols = new ArrayList();
            if (this.matchHelper == null) {
                this.matchHelper = new MatchHelper(this.eTagGenerator);
            }
            if (this.partialGetHelper == null) {
                this.partialGetHelper = new PartialGetHelper((Http11ResponseHandler)webdavResponseHandler);
            }
            Http11Protocol http11Protocol = new Http11Protocol((Http11ResponseHandler)webdavResponseHandler, this.handlerHelper, this.resourceHandlerHelper, this.enableOptionsAuth, this.matchHelper, this.partialGetHelper);
            this.protocols.add((HttpExtension)http11Protocol);
            if (this.propertySources == null) {
                this.propertySources = this.initDefaultPropertySources(resourceTypeHelper);
                this.showLog("propertySources", this.propertySources);
            }
            if (this.extraPropertySources != null) {
                for (PropertySource ps : this.extraPropertySources) {
                    ClientDataManager.logger.info((Object)("Add extra property source: " + ps.getClass()));
                    this.propertySources.add(ps);
                }
            }
            if (this.propPatchSetter == null) {
                this.propPatchSetter = new PropertySourcePatchSetter(this.propertySources);
            }
            if (this.userAgentHelper == null) {
                this.userAgentHelper = new DefaultUserAgentHelper();
            }
            if (this.webDavProtocol == null && this.webdavEnabled) {
                this.webDavProtocol = new WebDavProtocol(this.handlerHelper, resourceTypeHelper, webdavResponseHandler, this.propertySources, this.quotaDataAccessor, this.propPatchSetter, this.initPropertyAuthoriser(), this.eTagGenerator, this.urlAdapter, this.resourceHandlerHelper, this.userAgentHelper);
            }
            if (this.webDavProtocol != null) {
                this.protocols.add((HttpExtension)this.webDavProtocol);
            }
            if (this.calDavProtocol == null && this.caldavEnabled) {
                this.calDavProtocol = new CalDavProtocol(this.mainResourceFactory, webdavResponseHandler, this.handlerHelper, this.webDavProtocol);
            }
            if (this.calDavProtocol != null) {
                this.protocols.add((HttpExtension)this.calDavProtocol);
            }
            if (this.aclProtocol == null && this.aclEnabled) {
                this.aclProtocol = new ACLProtocol(this.webDavProtocol);
            }
            if (this.aclProtocol != null) {
                this.protocols.add((HttpExtension)this.aclProtocol);
            }
            if (this.cardDavProtocol == null && this.carddavEnabled) {
                this.cardDavProtocol = new CardDavProtocol(this.mainResourceFactory, webdavResponseHandler, this.handlerHelper, this.webDavProtocol);
            }
            if (this.calDavProtocol != null) {
                this.protocols.add((HttpExtension)this.cardDavProtocol);
            }
        }
        if (this.protocolHandlers == null) {
            this.protocolHandlers = new ProtocolHandlers(this.protocols);
        }
        if (this.wellKnownHandlers == null) {
            this.wellKnownHandlers = new ArrayList<WellKnownResourceFactory.WellKnownHandler>();
            for (HttpExtension p : this.protocols) {
                if (!(p instanceof WellKnownResourceFactory.WellKnownHandler)) continue;
                WellKnownResourceFactory.WellKnownHandler wellKnownHandler = (WellKnownResourceFactory.WellKnownHandler)p;
                this.wellKnownHandlers.add(wellKnownHandler);
            }
        }
        if (this.outerResourceFactory == null) {
            this.outerResourceFactory = this.mainResourceFactory;
            if (this.enabledJson) {
                this.outerResourceFactory = new JsonResourceFactory(this.outerResourceFactory, this.eventManager, this.propertySources, this.propPatchSetter, this.initPropertyAuthoriser());
                ClientDataManager.logger.info((Object)("Enabled json/ajax gatewayw with: " + this.outerResourceFactory.getClass()));
            }
            if (this.enableWellKnown) {
                this.outerResourceFactory = new WellKnownResourceFactory(this.outerResourceFactory, this.wellKnownHandlers);
                ClientDataManager.logger.info((Object)("Enabled well-known protocol support with: " + this.outerResourceFactory.getClass()));
            }
            if (this.enabledCkBrowser) {
                this.outerResourceFactory = new FckResourceFactory(this.outerResourceFactory);
                ClientDataManager.logger.info((Object)("Enabled CK Editor support with: " + this.outerResourceFactory.getClass()));
            }
        }
        this.filters = this.filters != null ? new ArrayList<Filter>(this.filters) : new ArrayList<Filter>();
        this.filters.add(this.defaultStandardFilter);
    }

    public HttpManager buildHttpManager() {
        if (!this.initDone) {
            this.init();
        }
        if (this.listeners != null) {
            for (EdalInitListener l : this.listeners) {
                l.afterInit(this);
            }
        }
        HttpManager httpManager = new HttpManager(this.outerResourceFactory, this.webdavResponseHandler, this.protocolHandlers, this.entityTransport, this.filters, this.eventManager, this.shutdownHandlers);
        if (this.listeners != null) {
            for (EdalInitListener l : this.listeners) {
                l.afterBuild(this, httpManager);
            }
        }
        return httpManager;
    }

    private PropertyAuthoriser initPropertyAuthoriser() {
        if (this.propertyAuthoriser == null) {
            this.propertyAuthoriser = new DefaultPropertyAuthoriser();
            if (this.beanPropertySource != null) {
                this.propertyAuthoriser = new BeanPropertyAuthoriser(this.beanPropertySource, this.propertyAuthoriser);
            }
        }
        return this.propertyAuthoriser;
    }

    private List<PropertySource> initDefaultPropertySources(ResourceTypeHelper resourceTypeHelper) {
        ArrayList<PropertySource> list = new ArrayList<PropertySource>();
        if (this.multiNamespaceCustomPropertySource == null && this.multiNamespaceCustomPropertySourceEnabled) {
            this.multiNamespaceCustomPropertySource = new MultiNamespaceCustomPropertySource();
        }
        if (this.multiNamespaceCustomPropertySource != null) {
            list.add((PropertySource)this.multiNamespaceCustomPropertySource);
        }
        if (this.initBeanPropertySource() != null) {
            list.add((PropertySource)this.beanPropertySource);
        }
        return list;
    }

    private BeanPropertySource initBeanPropertySource() {
        if (this.beanPropertySource == null) {
            this.beanPropertySource = new BeanPropertySource();
        }
        return this.beanPropertySource;
    }

    public DefaultHttp11ResponseHandler.BUFFERING getBuffering() {
        return this.buffering;
    }

    public void setBuffering(DefaultHttp11ResponseHandler.BUFFERING buffering) {
        this.buffering = buffering;
    }

    public ResourceFactory getResourceFactory() {
        return this.mainResourceFactory;
    }

    public void setResourceFactory(ResourceFactory resourceFactory) {
        this.mainResourceFactory = resourceFactory;
    }

    public List<AuthenticationHandler> getAuthenticationHandlers() {
        return this.authenticationHandlers;
    }

    public void setAuthenticationHandlers(List<AuthenticationHandler> authenticationHandlers) {
        this.authenticationHandlers = authenticationHandlers;
    }

    public Map<UUID, Nonce> getNonces() {
        return this.nonces;
    }

    public void setNonces(Map<UUID, Nonce> nonces) {
        this.nonces = nonces;
    }

    public ResourceFactory getMainResourceFactory() {
        return this.mainResourceFactory;
    }

    public void setMainResourceFactory(ResourceFactory mainResourceFactory) {
        this.mainResourceFactory = mainResourceFactory;
    }

    public ResourceFactory getOuterResourceFactory() {
        return this.outerResourceFactory;
    }

    public void setOuterResourceFactory(ResourceFactory outerResourceFactory) {
        this.outerResourceFactory = outerResourceFactory;
    }

    public int getNonceValiditySeconds() {
        return this.nonceValiditySeconds;
    }

    public void setNonceValiditySeconds(int nonceValiditySeconds) {
        this.nonceValiditySeconds = nonceValiditySeconds;
    }

    public NonceProvider getNonceProvider() {
        return this.nonceProvider;
    }

    public void setNonceProvider(NonceProvider nonceProvider) {
        this.nonceProvider = nonceProvider;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public ExpiredNonceRemover getExpiredNonceRemover() {
        return this.expiredNonceRemover;
    }

    public void setExpiredNonceRemover(ExpiredNonceRemover expiredNonceRemover) {
        this.expiredNonceRemover = expiredNonceRemover;
    }

    public List<Stoppable> getShutdownHandlers() {
        return this.shutdownHandlers;
    }

    public void setShutdownHandlers(List<Stoppable> shutdownHandlers) {
        this.shutdownHandlers = shutdownHandlers;
    }

    public ResourceTypeHelper getResourceTypeHelper() {
        return this.resourceTypeHelper;
    }

    public void setResourceTypeHelper(ResourceTypeHelper resourceTypeHelper) {
        this.resourceTypeHelper = resourceTypeHelper;
    }

    public WebDavResponseHandler getWebdavResponseHandler() {
        return this.webdavResponseHandler;
    }

    public void setWebdavResponseHandler(WebDavResponseHandler webdavResponseHandler) {
        this.webdavResponseHandler = webdavResponseHandler;
    }

    public HandlerHelper getHandlerHelper() {
        return this.handlerHelper;
    }

    public void setHandlerHelper(HandlerHelper handlerHelper) {
        this.handlerHelper = handlerHelper;
    }

    public ArrayList<HttpExtension> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(ArrayList<HttpExtension> protocols) {
        this.protocols = protocols;
    }

    public ProtocolHandlers getProtocolHandlers() {
        return this.protocolHandlers;
    }

    public void setProtocolHandlers(ProtocolHandlers protocolHandlers) {
        this.protocolHandlers = protocolHandlers;
    }

    public EntityTransport getEntityTransport() {
        return this.entityTransport;
    }

    public void setEntityTransport(EntityTransport entityTransport) {
        this.entityTransport = entityTransport;
    }

    public List<WellKnownResourceFactory.WellKnownHandler> getWellKnownHandlers() {
        return this.wellKnownHandlers;
    }

    public void setWellKnownHandlers(List<WellKnownResourceFactory.WellKnownHandler> wellKnownHandlers) {
        this.wellKnownHandlers = wellKnownHandlers;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public PropertyAuthoriser getPropertyAuthoriser() {
        return this.propertyAuthoriser;
    }

    public void setPropertyAuthoriser(PropertyAuthoriser propertyAuthoriser) {
        this.propertyAuthoriser = propertyAuthoriser;
    }

    public List<PropertySource> getPropertySources() {
        return this.propertySources;
    }

    public void setPropertySources(List<PropertySource> propertySources) {
        this.propertySources = propertySources;
    }

    public ETagGenerator geteTagGenerator() {
        return this.eTagGenerator;
    }

    public void seteTagGenerator(ETagGenerator eTagGenerator) {
        this.eTagGenerator = eTagGenerator;
    }

    public Http11ResponseHandler getHttp11ResponseHandler() {
        return this.http11ResponseHandler;
    }

    public void setHttp11ResponseHandler(Http11ResponseHandler http11ResponseHandler) {
        this.http11ResponseHandler = http11ResponseHandler;
    }

    public ValueWriters getValueWriters() {
        return this.valueWriters;
    }

    public void setValueWriters(ValueWriters valueWriters) {
        this.valueWriters = valueWriters;
    }

    public PropFindXmlGenerator getPropFindXmlGenerator() {
        return this.propFindXmlGenerator;
    }

    public void setPropFindXmlGenerator(PropFindXmlGenerator propFindXmlGenerator) {
        this.propFindXmlGenerator = propFindXmlGenerator;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public Filter getDefaultStandardFilter() {
        return this.defaultStandardFilter;
    }

    public void setDefaultStandardFilter(Filter defaultStandardFilter) {
        this.defaultStandardFilter = defaultStandardFilter;
    }

    public UrlAdapter getUrlAdapter() {
        return this.urlAdapter;
    }

    public void setUrlAdapter(UrlAdapter urlAdapter) {
        this.urlAdapter = urlAdapter;
    }

    public QuotaDataAccessor getQuotaDataAccessor() {
        return this.quotaDataAccessor;
    }

    public void setQuotaDataAccessor(QuotaDataAccessor quotaDataAccessor) {
        this.quotaDataAccessor = quotaDataAccessor;
    }

    public PropPatchSetter getPropPatchSetter() {
        return this.propPatchSetter;
    }

    public void setPropPatchSetter(PropPatchSetter propPatchSetter) {
        this.propPatchSetter = propPatchSetter;
    }

    public boolean isInitDone() {
        return this.initDone;
    }

    public void setInitDone(boolean initDone) {
        this.initDone = initDone;
    }

    public boolean isEnableOptionsAuth() {
        return this.enableOptionsAuth;
    }

    public void setEnableOptionsAuth(boolean enableOptionsAuth) {
        this.enableOptionsAuth = enableOptionsAuth;
    }

    public boolean isEnableCompression() {
        return this.enableCompression;
    }

    public void setEnableCompression(boolean enableCompression) {
        this.enableCompression = enableCompression;
    }

    public boolean isEnableWellKnown() {
        return this.enableWellKnown;
    }

    public void setEnableWellKnown(boolean enableWellKnown) {
        this.enableWellKnown = enableWellKnown;
    }

    public boolean isEnabledJson() {
        return this.enabledJson;
    }

    public void setEnabledJson(boolean enabledJson) {
        this.enabledJson = enabledJson;
    }

    public List<PropertySource> getExtraPropertySources() {
        return this.extraPropertySources;
    }

    public void setExtraPropertySources(List<PropertySource> extraPropertySources) {
        this.extraPropertySources = extraPropertySources;
    }

    private void showLog(String propertyName, Object defaultedTo) {
        ClientDataManager.logger.info((Object)("set property: " + propertyName + " to: " + defaultedTo));
    }

    public boolean isEnableBasicAuth() {
        return this.enableBasicAuth;
    }

    public void setEnableBasicAuth(boolean enableBasicAuth) {
        this.enableBasicAuth = enableBasicAuth;
    }

    public boolean isEnableCookieAuth() {
        return this.enableCookieAuth;
    }

    public void setEnableCookieAuth(boolean enableCookieAuth) {
        this.enableCookieAuth = enableCookieAuth;
    }

    public boolean isEnableDigestAuth() {
        return this.enableDigestAuth;
    }

    public void setEnableDigestAuth(boolean enableDigestAuth) {
        this.enableDigestAuth = enableDigestAuth;
    }

    public boolean isEnableFormAuth() {
        return this.enableFormAuth;
    }

    public void setEnableFormAuth(boolean enableFormAuth) {
        this.enableFormAuth = enableFormAuth;
    }

    public BasicAuthHandler getBasicHandler() {
        return this.basicHandler;
    }

    public void setBasicHandler(BasicAuthHandler basicHandler) {
        this.basicHandler = basicHandler;
    }

    public CookieAuthenticationHandler getCookieAuthenticationHandler() {
        return this.cookieAuthenticationHandler;
    }

    public void setCookieAuthenticationHandler(CookieAuthenticationHandler cookieAuthenticationHandler) {
        this.cookieAuthenticationHandler = cookieAuthenticationHandler;
    }

    public List<AuthenticationHandler> getCookieDelegateHandlers() {
        return this.cookieDelegateHandlers;
    }

    public void setCookieDelegateHandlers(List<AuthenticationHandler> cookieDelegateHandlers) {
        this.cookieDelegateHandlers = cookieDelegateHandlers;
    }

    public DigestAuthenticationHandler getDigestHandler() {
        return this.digestHandler;
    }

    public void setDigestHandler(DigestAuthenticationHandler digestHandler) {
        this.digestHandler = digestHandler;
    }

    public FormAuthenticationHandler getFormAuthenticationHandler() {
        return this.formAuthenticationHandler;
    }

    public void setFormAuthenticationHandler(FormAuthenticationHandler formAuthenticationHandler) {
        this.formAuthenticationHandler = formAuthenticationHandler;
    }

    public String getLoginPage() {
        return this.loginPage;
    }

    public void setLoginPage(String loginPage) {
        this.loginPage = loginPage;
    }

    public List<String> getLoginPageExcludePaths() {
        return this.loginPageExcludePaths;
    }

    public void setLoginPageExcludePaths(List<String> loginPageExcludePaths) {
        this.loginPageExcludePaths = loginPageExcludePaths;
    }

    public ResourceHandlerHelper getResourceHandlerHelper() {
        return this.resourceHandlerHelper;
    }

    public void setResourceHandlerHelper(ResourceHandlerHelper resourceHandlerHelper) {
        this.resourceHandlerHelper = resourceHandlerHelper;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(File rootDir) {
        this.rootDir = rootDir;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public String getFsContextPath() {
        return this.fsContextPath;
    }

    public void setFsContextPath(String fsContextPath) {
        this.fsContextPath = fsContextPath;
    }

    public UserAgentHelper getUserAgentHelper() {
        return this.userAgentHelper;
    }

    public void setUserAgentHelper(UserAgentHelper userAgentHelper) {
        this.userAgentHelper = userAgentHelper;
    }

    public String getDefaultPassword() {
        return this.defaultPassword;
    }

    public void setDefaultPassword(String defaultPassword) {
        this.defaultPassword = defaultPassword;
    }

    public String getDefaultUser() {
        return this.defaultUser;
    }

    public void setDefaultUser(String defaultUser) {
        this.defaultUser = defaultUser;
    }

    public String getFsRealm() {
        return this.fsRealm;
    }

    public void setFsRealm(String fsRealm) {
        this.fsRealm = fsRealm;
    }

    public Map<String, String> getMapOfNameAndPasswords() {
        return this.mapOfNameAndPasswords;
    }

    public void setMapOfNameAndPasswords(Map<String, String> mapOfNameAndPasswords) {
        this.mapOfNameAndPasswords = mapOfNameAndPasswords;
    }

    public MultiNamespaceCustomPropertySource getMultiNamespaceCustomPropertySource() {
        return this.multiNamespaceCustomPropertySource;
    }

    public void setMultiNamespaceCustomPropertySource(MultiNamespaceCustomPropertySource multiNamespaceCustomPropertySource) {
        this.multiNamespaceCustomPropertySource = multiNamespaceCustomPropertySource;
    }

    public BeanPropertySource getBeanPropertySource() {
        return this.beanPropertySource;
    }

    public void setBeanPropertySource(BeanPropertySource beanPropertySource) {
        this.beanPropertySource = beanPropertySource;
    }

    public boolean isEnabledCkBrowser() {
        return this.enabledCkBrowser;
    }

    public void setEnabledCkBrowser(boolean enabledCkBrowser) {
        this.enabledCkBrowser = enabledCkBrowser;
    }

    public WebDavProtocol getWebDavProtocol() {
        return this.webDavProtocol;
    }

    public void setWebDavProtocol(WebDavProtocol webDavProtocol) {
        this.webDavProtocol = webDavProtocol;
    }

    public CalDavProtocol getCalDavProtocol() {
        return this.calDavProtocol;
    }

    public void setCalDavProtocol(CalDavProtocol calDavProtocol) {
        this.calDavProtocol = calDavProtocol;
    }

    public CardDavProtocol getCardDavProtocol() {
        return this.cardDavProtocol;
    }

    public void setCardDavProtocol(CardDavProtocol cardDavProtocol) {
        this.cardDavProtocol = cardDavProtocol;
    }

    public ACLProtocol getAclProtocol() {
        return this.aclProtocol;
    }

    public void setAclProtocol(ACLProtocol aclProtocol) {
        this.aclProtocol = aclProtocol;
    }

    public boolean isAclEnabled() {
        return this.aclEnabled;
    }

    public void setAclEnabled(boolean aclEnabled) {
        this.aclEnabled = aclEnabled;
    }

    public boolean isCaldavEnabled() {
        return this.caldavEnabled;
    }

    public void setCaldavEnabled(boolean caldavEnabled) {
        this.caldavEnabled = caldavEnabled;
    }

    public boolean isCarddavEnabled() {
        return this.carddavEnabled;
    }

    public void setCarddavEnabled(boolean carddavEnabled) {
        this.carddavEnabled = carddavEnabled;
    }

    public boolean isWebdavEnabled() {
        return this.webdavEnabled;
    }

    public void setWebdavEnabled(boolean webdavEnabled) {
        this.webdavEnabled = webdavEnabled;
    }

    public MatchHelper getMatchHelper() {
        return this.matchHelper;
    }

    public void setMatchHelper(MatchHelper matchHelper) {
        this.matchHelper = matchHelper;
    }

    public PartialGetHelper getPartialGetHelper() {
        return this.partialGetHelper;
    }

    public void setPartialGetHelper(PartialGetHelper partialGetHelper) {
        this.partialGetHelper = partialGetHelper;
    }

    public boolean isMultiNamespaceCustomPropertySourceEnabled() {
        return this.multiNamespaceCustomPropertySourceEnabled;
    }

    public void setMultiNamespaceCustomPropertySourceEnabled(boolean multiNamespaceCustomPropertySourceEnabled) {
        this.multiNamespaceCustomPropertySourceEnabled = multiNamespaceCustomPropertySourceEnabled;
    }

    public LoginResponseHandler.LoginPageTypeHandler getLoginPageTypeHandler() {
        return this.loginPageTypeHandler;
    }

    public void setLoginPageTypeHandler(LoginResponseHandler.LoginPageTypeHandler loginPageTypeHandler) {
        this.loginPageTypeHandler = loginPageTypeHandler;
    }

    public LoginResponseHandler getLoginResponseHandler() {
        return this.loginResponseHandler;
    }

    public void setLoginResponseHandler(LoginResponseHandler loginResponseHandler) {
        this.loginResponseHandler = loginResponseHandler;
    }

    public List<EdalInitListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<EdalInitListener> listeners) {
        this.listeners = listeners;
    }
}

