/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.wrapper;

import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.EdalHttpManagerBuilder;
import io.milton.http.AuthenticationHandler;
import io.milton.http.Filter;
import io.milton.http.HttpManager;
import io.milton.http.ResourceFactory;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.servlet.Config;
import io.milton.servlet.Initable;
import io.milton.servlet.MiltonConfigurator;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;

public class EdalMiltonConfigurator
implements MiltonConfigurator {
    protected EdalHttpManagerBuilder builder = new EdalHttpManagerBuilder();
    protected List<Initable> initables;
    protected HttpManager httpManager;

    public HttpManager configure(Config config) throws ServletException {
        String resourceFactoryClassName;
        ClientDataManager.logger.info((Object)"Listing all config parameters:");
        for (String s : config.getInitParameterNames()) {
            ClientDataManager.logger.info((Object)(" " + s + " = " + config.getInitParameter(s)));
        }
        String authHandlers = config.getInitParameter("authenticationHandlers");
        if (authHandlers != null) {
            this.initAuthHandlers(authHandlers);
        }
        if ((resourceFactoryClassName = config.getInitParameter("resource.factory.class")) != null) {
            ResourceFactory rf = (ResourceFactory)EdalMiltonConfigurator.instantiate(resourceFactoryClassName);
            this.builder.setMainResourceFactory(rf);
        } else {
            ClientDataManager.logger.warn((Object)"No custom ResourceFactory class name provided in resource.factory.class");
        }
        String responseHandlerClassName = config.getInitParameter("response.handler.class");
        if (responseHandlerClassName != null) {
            WebDavResponseHandler davResponseHandler = (WebDavResponseHandler)EdalMiltonConfigurator.instantiate(responseHandlerClassName);
            this.builder.setWebdavResponseHandler(davResponseHandler);
        }
        ArrayList<Filter> filters = null;
        List params = config.getInitParameterNames();
        for (String paramName : params) {
            if (!paramName.startsWith("filter_")) continue;
            String filterClass = config.getInitParameter(paramName);
            Filter f = (Filter)EdalMiltonConfigurator.instantiate(filterClass);
            if (filters == null) {
                filters = new ArrayList<Filter>();
            }
            filters.add(f);
        }
        if (filters != null) {
            this.builder.setFilters(filters);
        }
        this.build();
        this.initables = new ArrayList<Initable>();
        this.checkAddInitable(this.initables, this.builder.getAuthenticationHandlers());
        this.checkAddInitable(this.initables, this.builder.getMainResourceFactory());
        this.checkAddInitable(this.initables, this.builder.getWebdavResponseHandler());
        this.checkAddInitable(this.initables, this.builder.getFilters());
        for (Initable i : this.initables) {
            i.init(config, this.httpManager);
        }
        return this.httpManager;
    }

    protected void build() {
        this.httpManager = this.builder.buildHttpManager();
    }

    public void shutdown() {
        this.httpManager.shutdown();
        for (Initable i : this.initables) {
            i.destroy(this.httpManager);
        }
    }

    private void initAuthHandlers(String classNames) throws ServletException {
        List<String> authHandlers = this.loadAuthHandlersIfAny(classNames);
        if (authHandlers == null) {
            return;
        }
        ArrayList<AuthenticationHandler> list = new ArrayList<AuthenticationHandler>();
        for (String authHandlerClassName : authHandlers) {
            Object o = EdalMiltonConfigurator.instantiate(authHandlerClassName);
            if (o instanceof AuthenticationHandler) {
                AuthenticationHandler auth = (AuthenticationHandler)o;
                list.add(auth);
                continue;
            }
            throw new ServletException("Class: " + authHandlerClassName + " is not a: " + AuthenticationHandler.class.getCanonicalName());
        }
        this.builder.setAuthenticationHandlers(list);
    }

    public static <T> T instantiate(String className) throws ServletException {
        try {
            Class<?> c = Class.forName(className);
            Object rf = c.newInstance();
            return (T)rf;
        }
        catch (Throwable ex) {
            throw new ServletException("Failed to instantiate: " + className, ex);
        }
    }

    private List<String> loadAuthHandlersIfAny(String initParameter) {
        if (initParameter == null) {
            return null;
        }
        String[] arr = initParameter.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (String s : arr) {
            if ((s = s.trim()).length() <= 0) continue;
            list.add(s);
        }
        return list;
    }

    private void checkAddInitable(List<Initable> initables, Object o) {
        if (o instanceof Initable) {
            initables.add((Initable)o);
        } else if (o instanceof List) {
            for (Object o2 : (List)o) {
                this.checkAddInitable(initables, o2);
            }
        }
    }
}

