/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.wrapper;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalAuthenticateException;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.FileSystemCache;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.FileSystemHandler;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data.PrimaryDataDirectoryResource;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data.PrimaryDataEntityPropertyVirtualResource;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data.PrimaryDataEntityResource;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data.PrimaryDataFileDirectoryVirtualResource;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data.PrimaryDataFileResource;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data.PrimaryDataVersionDirectoryVirtualResource;
import io.milton.common.Path;
import io.milton.http.HttpManager;
import io.milton.http.ResourceFactory;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.Resource;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;

public class EdalResourceFactory
implements ResourceFactory {
    public Resource getResource(String host, String strPath) throws NotAuthorizedException, BadRequestException {
        block23: {
            String username;
            Path path = Path.path((String)strPath);
            FileSystemHandler fileSystemHandler = null;
            if (HttpManager.request().getAuthorization() != null && (username = HttpManager.request().getAuthorization().getUser()) != null) {
                fileSystemHandler = FileSystemCache.get(username);
            }
            try {
                if (path.isRoot()) {
                    return new PrimaryDataDirectoryResource("/", fileSystemHandler);
                }
                if (fileSystemHandler == null) {
                    return null;
                }
                String file = path.toString();
                int index = file.indexOf(FileSystemHandler.VIRTUALVERSIONFOLDERPREFIX);
                if (index >= 0) {
                    String realpath = file.substring(0, index) + file.substring(index + FileSystemHandler.VIRTUALVERSIONFOLDERPREFIX.length());
                    int ipos = realpath.indexOf("/" + FileSystemHandler.VIRTUALFILEPREFIX);
                    while (ipos >= 0) {
                        realpath = realpath.substring(0, ipos + 1) + realpath.substring(ipos + 1 + FileSystemHandler.VIRTUALFILEPREFIX.length());
                        ipos = realpath.indexOf("/" + FileSystemHandler.VIRTUALFILEPREFIX);
                    }
                    ipos = realpath.indexOf("/" + FileSystemHandler.VIRTUALFOLDERPREFIX);
                    while (ipos >= 0) {
                        realpath = realpath.substring(0, ipos + 1) + realpath.substring(ipos + 1 + FileSystemHandler.VIRTUALFOLDERPREFIX.length());
                        ipos = realpath.indexOf("/" + FileSystemHandler.VIRTUALFOLDERPREFIX);
                    }
                    Pattern virtual = Pattern.compile("(.*)\\.v[0-9]+\\.?[^\\.]*\\.(properties?\\.?xml|.*)$");
                    Matcher vm = virtual.matcher(realpath);
                    if (vm.matches()) {
                        Pattern property = Pattern.compile(".*\\.v[0-9]+\\.?[^\\.]*\\.properties\\.xml$");
                        Matcher pm = property.matcher(realpath);
                        if (!pm.matches()) {
                            return new PrimaryDataFileDirectoryVirtualResource(vm.group(1) + "." + vm.group(2), fileSystemHandler).child(realpath);
                        }
                        PrimaryDataEntityPropertyVirtualResource virtualxmlresouce = new PrimaryDataEntityPropertyVirtualResource(realpath, fileSystemHandler);
                        return virtualxmlresouce;
                    }
                    PrimaryDataEntityResource entr = new PrimaryDataEntityResource(realpath, fileSystemHandler);
                    if (entr.exists()) {
                        if (entr.isDirectory()) {
                            return new PrimaryDataVersionDirectoryVirtualResource(entr.getEntity().getPath(), fileSystemHandler);
                        }
                        return new PrimaryDataFileDirectoryVirtualResource(entr.getEntity().getPath(), fileSystemHandler);
                    }
                    break block23;
                }
                Pattern property = Pattern.compile(".*\\.v[0-9]+\\.?[^\\.]*\\.properties\\.xml$");
                Matcher pm = property.matcher(file);
                if (!pm.matches()) {
                    PrimaryDataEntityResource entr = new PrimaryDataEntityResource(file, fileSystemHandler);
                    if (entr.exists()) {
                        if (entr.isDirectory()) {
                            if (entr.getEntity() == null) {
                                return null;
                            }
                            return new PrimaryDataDirectoryResource(entr.getEntity().getPath(), fileSystemHandler);
                        }
                        if (entr.getEntity() == null) {
                            return null;
                        }
                        return new PrimaryDataFileResource(entr.getEntity().getPath(), fileSystemHandler);
                    }
                    break block23;
                }
                PrimaryDataEntityPropertyVirtualResource virtualxmlresouce = new PrimaryDataEntityPropertyVirtualResource(file, fileSystemHandler);
                return virtualxmlresouce;
            }
            catch (NotBoundException e) {
                ClientDataManager.logger.error((Object)("Failed handling request for file: " + strPath + "\nReason: " + e.toString()));
            }
            catch (RemoteException e) {
                ClientDataManager.logger.error((Object)("Failed handling request for file: " + strPath + "\nReason: " + e.toString()));
            }
            catch (PrimaryDataDirectoryException e) {
                ClientDataManager.logger.error((Object)("Failed handling request for file: " + strPath + "\nReason: " + e.toString()));
            }
            catch (EdalAuthenticateException e) {
                ClientDataManager.logger.error((Object)("Failed handling request for file: " + strPath + "\nReason: " + e.toString()));
                throw new NotAuthorizedException("don't support this operation!", null);
            }
            catch (JAXBException e) {
                ClientDataManager.logger.error((Object)("Failed handling request for file: " + strPath + "\nReason: " + e.toString()));
            }
            catch (PrimaryDataEntityVersionException e) {
                ClientDataManager.logger.error((Object)("Failed handling request for file: " + strPath + "\nReason: " + e.toString()));
            }
            catch (MetaDataException e) {
                ClientDataManager.logger.error((Object)("Failed handling request for file: " + strPath + "\nReason: " + e.toString()));
            }
        }
        return null;
    }
}

