/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.metadata;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataFormat;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataSize;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataType;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DateEvents;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DirectoryMetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalLanguage;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Identifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.IdentifierRelation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.LegalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.metadata.BasicDateWrapper;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.metadata.DateEventsWrapper;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.metadata.EdalLanguageWrapper;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.metadata.IdentifierRelationWrapper;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.metadata.IdentifierWrapper;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.metadata.LegalPersonWrapper;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.metadata.NaturalPersonWrapper;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.metadata.PersonWrapper;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;

@XmlRootElement
public class Property {
    private String title;
    private String description;
    private String subject;
    private PersonWrapper contributor;
    private String coverage;
    private PersonWrapper creator;
    private EdalLanguageWrapper language;
    private String rights;
    private String source;
    private BasicDateWrapper date;
    private DateEventsWrapper events;
    private IdentifierWrapper identifier;
    private IdentifierRelationWrapper identifierRelation;
    @XmlAttribute
    private final long version;
    @XmlAttribute
    private final long size;
    @XmlAttribute
    private final String format;
    @XmlAttribute
    private final String type;
    @XmlAttribute
    private final boolean deleted;

    public Property() {
        this.version = 0L;
        this.size = 0L;
        this.format = "Unknown";
        this.type = "Unknown";
        this.deleted = false;
    }

    public Property(MetaData metaData, long revision, boolean deleted) throws MetaDataException {
        this.title = metaData.getElementValue((Enum)EnumDublinCoreElements.TITLE).getString();
        this.version = revision;
        UntypedData data = metaData.getElementValue((Enum)EnumDublinCoreElements.SIZE);
        this.size = ((DataSize)data).getFileSize();
        this.description = metaData.getElementValue((Enum)EnumDublinCoreElements.DESCRIPTION).getString();
        data = metaData.getElementValue((Enum)EnumDublinCoreElements.FORMAT);
        this.format = data instanceof DataFormat ? ((DataFormat)data).getMimeType() : "Unknown";
        this.subject = metaData.getElementValue((Enum)EnumDublinCoreElements.SUBJECT).getString();
        data = metaData.getElementValue((Enum)EnumDublinCoreElements.TYPE);
        this.type = data instanceof DataType ? ((DataType)data).getDataType().toString() : (DirectoryMetaData.class.isInstance(data) ? "Directory" : "Unknown");
        data = metaData.getElementValue((Enum)EnumDublinCoreElements.CONTRIBUTOR);
        if (data instanceof NaturalPerson) {
            this.contributor = new NaturalPersonWrapper((NaturalPerson)data);
        } else if (data instanceof LegalPerson) {
            this.contributor = new LegalPersonWrapper((LegalPerson)data);
        }
        this.coverage = metaData.getElementValue((Enum)EnumDublinCoreElements.COVERAGE).getString();
        data = metaData.getElementValue((Enum)EnumDublinCoreElements.CREATOR);
        if (data instanceof NaturalPerson) {
            this.creator = new NaturalPersonWrapper((NaturalPerson)data);
        } else if (data instanceof LegalPerson) {
            this.creator = new LegalPersonWrapper((LegalPerson)data);
        }
        this.deleted = deleted;
        data = metaData.getElementValue((Enum)EnumDublinCoreElements.DATE);
        if (DateEvents.class.isInstance(data)) {
            this.events = new DateEventsWrapper((DateEvents)data);
        }
        if (Identifier.class.isInstance(data = metaData.getElementValue((Enum)EnumDublinCoreElements.IDENTIFIER))) {
            this.identifier = new IdentifierWrapper((Identifier)data);
        }
        data = metaData.getElementValue((Enum)EnumDublinCoreElements.LANGUAGE);
        this.language = new EdalLanguageWrapper((EdalLanguage)data);
        data = metaData.getElementValue((Enum)EnumDublinCoreElements.RELATION);
        if (IdentifierRelation.class.isInstance(data)) {
            this.identifierRelation = new IdentifierRelationWrapper((IdentifierRelation)data);
        }
        this.rights = metaData.getElementValue((Enum)EnumDublinCoreElements.RIGHTS).getString();
        this.source = metaData.getElementValue((Enum)EnumDublinCoreElements.SOURCE).getString();
    }

    public void setEvents(DateEventsWrapper events) {
        this.events = events;
    }

    public void setIdentifier(IdentifierWrapper identifier) {
        this.identifier = identifier;
    }

    public void setIdentifierRelation(IdentifierRelationWrapper identifierRelation) {
        this.identifierRelation = identifierRelation;
    }

    public void setCreator(PersonWrapper creator) {
        this.creator = creator;
    }

    public void setDate(BasicDateWrapper date) {
        this.date = date;
    }

    public PersonWrapper getContributor() {
        return this.contributor;
    }

    public String getCoverage() {
        return this.coverage;
    }

    public PersonWrapper getCreator() {
        return this.creator;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFormat() {
        return this.format;
    }

    public long getSize() {
        return this.size;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public String getType() {
        return this.type;
    }

    public long getVersion() {
        return this.version;
    }

    public EdalLanguageWrapper getLanguage() {
        return this.language;
    }

    public String getRights() {
        return this.rights;
    }

    public String getSource() {
        return this.source;
    }

    public BasicDateWrapper getDate() {
        return this.date;
    }

    public DateEventsWrapper getEvents() {
        return this.events;
    }

    public IdentifierWrapper getIdentifier() {
        return this.identifier;
    }

    public IdentifierRelationWrapper getIdentifierRelation() {
        return this.identifierRelation;
    }

    public static Logger getLog() {
        return ClientDataManager.logger;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setRights(String rights) {
        this.rights = rights;
    }

    public void setLanguage(EdalLanguageWrapper language) {
        this.language = language;
    }

    public void setContributor(PersonWrapper contributor) {
        this.contributor = contributor;
    }

    public void setCoverage(String coverage) {
        this.coverage = coverage;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void updateMetaData(MetaData m) {
        try {
            m.setElementValue(EnumDublinCoreElements.TITLE, new UntypedData(this.title));
            m.setElementValue(EnumDublinCoreElements.DESCRIPTION, new UntypedData(this.description));
            m.setElementValue(EnumDublinCoreElements.SUBJECT, new UntypedData(this.subject));
            m.setElementValue(EnumDublinCoreElements.CONTRIBUTOR, (UntypedData)this.contributor.getPerson());
            m.setElementValue(EnumDublinCoreElements.CREATOR, (UntypedData)this.creator.getPerson());
            m.setElementValue(EnumDublinCoreElements.COVERAGE, new UntypedData(this.coverage));
            m.setElementValue(EnumDublinCoreElements.LANGUAGE, (UntypedData)this.language.getEdalLanguage());
            m.setElementValue(EnumDublinCoreElements.RIGHTS, new UntypedData(this.rights));
            m.setElementValue(EnumDublinCoreElements.SOURCE, new UntypedData(this.source));
        }
        catch (MetaDataException e) {
            Property.getLog().error((Object)("Failed to update meta data: " + e.toString()));
        }
    }
}

