/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFileException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalAuthenticateException;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.FileSystemHandler;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.metadata.ExtXMLConfig;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.metadata.Property;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data.PrimaryDataEntityPropertyVirtualResource;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data.PrimaryDataEntityResource;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data.PrimaryDataFileDirectoryVirtualResource;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data.PrimaryDataFileResource;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data.PrimaryDataVersionDirectoryVirtualResource;
import io.milton.http.Auth;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.CollectionResource;
import io.milton.resource.DeletableCollectionResource;
import io.milton.resource.MakeCollectionableResource;
import io.milton.resource.MoveableResource;
import io.milton.resource.PutableResource;
import io.milton.resource.Resource;
import java.io.InputStream;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;

public class PrimaryDataDirectoryResource
extends PrimaryDataEntityResource
implements CollectionResource,
PutableResource,
MakeCollectionableResource,
DeletableCollectionResource,
MoveableResource {
    private ClientPrimaryDataDirectory dir;

    public PrimaryDataDirectoryResource(String path, FileSystemHandler fileSystemHandler) throws RemoteException, PrimaryDataDirectoryException, NotBoundException, EdalAuthenticateException {
        super(path, fileSystemHandler);
        if (this.entity != null) {
            this.dir = (ClientPrimaryDataDirectory)this.entity;
        }
    }

    public ClientPrimaryDataDirectory getDir() {
        return this.dir;
    }

    @Override
    public boolean authorise(Request request, Request.Method method, Auth auth) {
        boolean b = super.authorise(request, method, auth);
        if (this.entity != null) {
            this.dir = (ClientPrimaryDataDirectory)this.entity;
        }
        return b;
    }

    public Resource child(String childName) {
        try {
            if (this.dir.exist(childName)) {
                PrimaryDataEntityResource child = new PrimaryDataEntityResource(this.dir.getPrimaryDataEntity(childName).getPath(), this.fileSystemHandler);
                if (child.isDirectory()) {
                    return (PrimaryDataDirectoryResource)child;
                }
                Pattern property = Pattern.compile(".*\\.v[0-9]+\\.?[^\\.]*\\.properties\\.xml$");
                Matcher pm = property.matcher(childName);
                if (!pm.matches()) {
                    return new PrimaryDataFileDirectoryVirtualResource(this.entity.getPath(), this.fileSystemHandler);
                }
                return new PrimaryDataEntityPropertyVirtualResource(this.entity.getCurrentVersion(), this.entity.getCurrentVersion().getRevision());
            }
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error((Object)("Failed to get resource for: " + childName + "\nReason: " + e.toString()));
        }
        catch (PrimaryDataDirectoryException e) {
            ClientDataManager.logger.error((Object)("Failed to get resource for: " + childName + "\nReason: " + e.toString()));
        }
        catch (JAXBException e) {
            ClientDataManager.logger.error((Object)("Failed to get resource for: " + childName + "\nReason: " + e.toString()));
        }
        catch (MetaDataException e) {
            ClientDataManager.logger.error((Object)("Failed to get resource for: " + childName + "\nReason: " + e.toString()));
        }
        catch (NotBoundException e) {
            ClientDataManager.logger.error((Object)("Failed to get resource for: " + childName + "\nReason: " + e.toString()));
        }
        catch (EdalAuthenticateException e) {
            ClientDataManager.logger.error((Object)("Failed to get resource for: " + childName + "\nReason: " + e.toString()));
        }
        return null;
    }

    public List<? extends Resource> getChildren() {
        ArrayList<PrimaryDataEntityResource> children = new ArrayList<PrimaryDataEntityResource>();
        try {
            List<ClientPrimaryDataEntity> lis = this.dir.listPrimaryDataEntities();
            for (ClientPrimaryDataEntity ent : lis) {
                if (ent.isDirectory()) {
                    if (ent.getCurrentVersion().isDeleted()) continue;
                    children.add(new PrimaryDataDirectoryResource(ent.getPath(), this.fileSystemHandler));
                    continue;
                }
                if (ent.getCurrentVersion().isDeleted()) continue;
                children.add(new PrimaryDataFileResource(ent.getPath(), this.fileSystemHandler));
            }
            children.add(new PrimaryDataVersionDirectoryVirtualResource(this.dir.getPath(), this.fileSystemHandler));
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error((Object)("Failed to get children of: " + this.dir + "\n" + e.toString()));
        }
        catch (PrimaryDataDirectoryException e) {
            ClientDataManager.logger.error((Object)("Failed to get children of: " + this.dir + "\n" + e.toString()));
        }
        catch (NotBoundException e) {
            ClientDataManager.logger.error((Object)("Failed to get children of: " + this.dir + "\n" + e.toString()));
        }
        catch (EdalAuthenticateException e) {
            ClientDataManager.logger.error((Object)("Failed to get children of: " + this.dir + "\n" + e.toString()));
        }
        return children;
    }

    public Resource createNew(String newName, InputStream inputStream, Long length, String contentType) {
        ClientPrimaryDataFile file = null;
        if (!newName.contains("properties")) {
            try {
                if (this.dir.exist(newName)) {
                    ClientPrimaryDataEntity ent = this.dir.getPrimaryDataEntity(newName);
                    if (!ent.isDirectory()) {
                        file = (ClientPrimaryDataFile)ent;
                        file.store(inputStream);
                    }
                } else {
                    file = this.dir.createPrimaryDataFile(newName);
                    if (length > 0L) {
                        file.store(inputStream);
                    }
                }
                if (file != null) {
                    this.fileSystemHandler.removecache(file.getPath());
                }
                return new PrimaryDataFileDirectoryVirtualResource(file.getPath(), this.fileSystemHandler);
            }
            catch (PrimaryDataDirectoryException e) {
                ClientDataManager.logger.error((Object)("Failed to create/save '" + newName + "\nReason: " + e.toString()));
            }
            catch (PrimaryDataFileException e) {
                ClientDataManager.logger.error((Object)("Failed to create/save file: " + newName + "\nReason: " + e.toString()));
            }
            catch (PrimaryDataEntityVersionException e) {
                ClientDataManager.logger.error((Object)("Failed to create/save file: " + newName + "\nReason: " + e.toString()));
            }
            catch (NotBoundException e) {
                ClientDataManager.logger.error((Object)("Failed to create/save file: " + newName + "\nReason: " + e.toString()));
            }
            catch (EdalAuthenticateException e) {
                ClientDataManager.logger.error((Object)("Failed to create/save file: " + newName + "\nReason: " + e.toString()));
            }
            catch (RemoteException e) {
                ClientDataManager.logger.error((Object)("Failed to create/save file: " + newName + "\nReason: " + e.toString()));
            }
        } else {
            try {
                ExtXMLConfig conf = new ExtXMLConfig(Property.class);
                Object rawData = conf.load(inputStream);
                if (rawData != null) {
                    ClientPrimaryDataEntity dirfile;
                    Property metaData = (Property)rawData;
                    Pattern property = Pattern.compile("(.*)\\.v[0-9]+\\.?[^\\.]*\\.(properties?\\.?xml|.*)$");
                    Matcher pm = property.matcher(newName);
                    if (pm.matches() && (dirfile = this.fileSystemHandler.getEntity(this.dir.getPath() + "/" + pm.group(1))) != null) {
                        MetaData newMetaData = dirfile.getMetaData().clone();
                        metaData.updateMetaData(newMetaData);
                        dirfile.setMetaData(newMetaData);
                        PrimaryDataEntityPropertyVirtualResource virtualxmlresouce = new PrimaryDataEntityPropertyVirtualResource(this.dir.getPath() + "/" + newName, this.fileSystemHandler);
                        return virtualxmlresouce;
                    }
                }
            }
            catch (JAXBException e) {
                ClientDataManager.logger.error((Object)("Failed to save properties-file: " + newName + "\nReason: " + e.toString()));
            }
            catch (RemoteException e) {
                ClientDataManager.logger.error((Object)("Failed to save properties-file: " + newName + "\nReason: " + e.toString()));
            }
            catch (CloneNotSupportedException e) {
                ClientDataManager.logger.error((Object)("Failed to save properties-file: " + newName + "\nReason: " + e.toString()));
            }
            catch (PrimaryDataEntityVersionException e) {
                ClientDataManager.logger.error((Object)("Failed to save properties-file: " + newName + "\nReason: " + e.toString()));
            }
            catch (MetaDataException e) {
                ClientDataManager.logger.error((Object)("Failed to save properties-file: " + newName + "\nReason: " + e.toString()));
            }
            catch (PrimaryDataDirectoryException e) {
                ClientDataManager.logger.error((Object)("Failed to save properties-file: " + newName + "\nReason: " + e.toString()));
            }
            catch (NotBoundException e) {
                ClientDataManager.logger.error((Object)("Failed to create/save file: " + newName + "\nReason: " + e.toString()));
            }
            catch (EdalAuthenticateException e) {
                ClientDataManager.logger.error((Object)("Failed to create/save file: " + newName + "\nReason: " + e.toString()));
            }
        }
        return null;
    }

    public CollectionResource createCollection(String newName) throws NotAuthorizedException, ConflictException, BadRequestException {
        ClientPrimaryDataEntity newDir = null;
        try {
            if (!this.dir.exist(newName)) {
                newDir = this.dir.createPrimaryDataDirectory(newName);
            }
            return new PrimaryDataDirectoryResource(newDir.getPath(), this.fileSystemHandler);
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error((Object)("Failed to create '" + newName + "'\n" + e.toString()));
        }
        catch (PrimaryDataDirectoryException e) {
            ClientDataManager.logger.error((Object)("Failed to create '" + newName + "'\n" + e.toString()));
        }
        catch (NotBoundException e) {
            ClientDataManager.logger.error((Object)("Failed to create '" + newName + "'\n" + e.toString()));
        }
        catch (EdalAuthenticateException e) {
            ClientDataManager.logger.error((Object)("Failed to create '" + newName + "'\n" + e.toString()));
        }
        return null;
    }

    public void delete() throws NotAuthorizedException, ConflictException, BadRequestException {
        try {
            this.fileSystemHandler.removecache(this.dir.getPath());
            this.dir.delete();
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error((Object)("Failed to delete directory: " + e.toString()));
        }
        catch (PrimaryDataEntityVersionException e) {
            ClientDataManager.logger.error((Object)("Failed to delete directory: " + e.toString()));
        }
        catch (PrimaryDataDirectoryException e) {
            ClientDataManager.logger.error((Object)("Failed to delete directory: " + e.toString()));
        }
    }

    public void moveTo(CollectionResource rDest, String name) throws ConflictException, NotAuthorizedException, BadRequestException {
        try {
            this.fileSystemHandler.removecache(this.dir.getPath());
            PrimaryDataDirectoryResource dir = (PrimaryDataDirectoryResource)rDest;
            if (dir != null) {
                ClientPrimaryDataDirectory oldParent = this.dir.getParentDirectory();
                ClientPrimaryDataDirectory newParent = dir.getDir();
                if (oldParent.getPath().compareTo(newParent.getPath()) == 0 && !oldParent.exist(name)) {
                    this.dir.rename(name);
                } else if (oldParent != null) {
                    this.dir.move(newParent);
                }
            }
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error((Object)("Failed to move/rename File: " + e.toString()));
        }
        catch (PrimaryDataDirectoryException e) {
            ClientDataManager.logger.error((Object)("Failed to move/rename File: " + e.toString()));
        }
        catch (PrimaryDataEntityVersionException e) {
            ClientDataManager.logger.error((Object)("Failed to rename File: " + e.toString()));
        }
    }

    public boolean isLockedOutRecursive(Request request) {
        return false;
    }
}

