/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalAuthenticateException;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.FileSystemHandler;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data.PrimaryDataEntityPropertyVirtualResource;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data.PrimaryDataEntityResource;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data.PrimaryDataFileVirtualResource;
import io.milton.http.Auth;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.CollectionResource;
import io.milton.resource.PutableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;

public class PrimaryDataDirectoryVirtualResource
extends PrimaryDataEntityResource
implements CollectionResource,
PutableResource {
    private ClientPrimaryDataDirectory dir;

    public PrimaryDataDirectoryVirtualResource(String path, FileSystemHandler fileSystemHandler) throws RemoteException, PrimaryDataDirectoryException, NotBoundException, EdalAuthenticateException {
        super(path, fileSystemHandler);
        if (this.entity != null) {
            this.dir = (ClientPrimaryDataDirectory)this.entity;
        }
    }

    public ClientPrimaryDataDirectory getDir() {
        return this.dir;
    }

    @Override
    public boolean authorise(Request request, Request.Method method, Auth auth) {
        boolean b = super.authorise(request, method, auth);
        if (this.entity != null) {
            this.dir = (ClientPrimaryDataDirectory)this.entity;
        }
        return b;
    }

    public Resource child(String childName) {
        if (this.entity == null) {
            return null;
        }
        Pattern p = Pattern.compile(".*\\/.*\\.v([0-9]+)\\..*$");
        Matcher m = p.matcher(childName);
        if (m.matches()) {
            try {
                long version = Long.valueOf(m.group(1));
                Pattern property = Pattern.compile(".*\\.v[0-9]+\\.?[^\\.]*\\.properties\\.xml$");
                Matcher pm = property.matcher(childName);
                if (!pm.matches()) {
                    return new PrimaryDataFileVirtualResource(this.entity.getPath(), version, this.fileSystemHandler);
                }
                return new PrimaryDataEntityPropertyVirtualResource(this.entity.getCurrentVersion(), this.entity.getCurrentVersion().getRevision());
            }
            catch (NumberFormatException e) {
                ClientDataManager.logger.error((Object)("Failed to get child: " + childName + "\nReason: " + e.toString()));
            }
            catch (RemoteException e) {
                ClientDataManager.logger.error((Object)("Failed to get child: " + childName + "\nReason: " + e.toString()));
            }
            catch (JAXBException e) {
                ClientDataManager.logger.error((Object)("Failed to get child: " + childName + "\nReason: " + e.toString()));
            }
            catch (MetaDataException e) {
                ClientDataManager.logger.error((Object)("Failed to get child: " + childName + "\nReason: " + e.toString()));
            }
            catch (PrimaryDataDirectoryException e) {
                ClientDataManager.logger.error((Object)("Failed to get child: " + childName + "\nReason: " + e.toString()));
            }
            catch (NotBoundException e) {
                ClientDataManager.logger.error((Object)("Failed to get child: " + childName + "\nReason: " + e.toString()));
            }
            catch (EdalAuthenticateException e) {
                ClientDataManager.logger.error((Object)("Failed to get child: " + childName + "\nReason: " + e.toString()));
            }
            catch (PrimaryDataEntityVersionException e) {
                ClientDataManager.logger.error((Object)("Failed to get child: " + this.dir + "\nReason: " + e.toString()));
            }
        }
        return null;
    }

    public List<? extends Resource> getChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        try {
            this.dir = (ClientPrimaryDataDirectory)this.fileSystemHandler.getEntity(this.path);
            SortedSet<ClientPrimaryDataEntityVersion> versions = this.dir.getVersions();
            if (versions.size() > 1) {
                for (ClientPrimaryDataEntityVersion v : versions) {
                    if (v.getRevision() == 0L || v.isDeleted()) continue;
                    children.add(new PrimaryDataFileVirtualResource(this.dir.getPath(), v.getRevision(), this.fileSystemHandler));
                    children.add(new PrimaryDataEntityPropertyVirtualResource(v, v.getRevision()));
                }
            }
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error((Object)("Failed to get children of: " + this.dir + "\nReason: " + e.toString()));
        }
        catch (JAXBException e) {
            ClientDataManager.logger.error((Object)("Failed to create properties.xml for: " + this.dir + "\nReason: " + e.toString()));
        }
        catch (MetaDataException e) {
            ClientDataManager.logger.error((Object)("Failed to create properties.xml for: " + this.dir + "\nReason: " + e.toString()));
        }
        catch (PrimaryDataDirectoryException e) {
            ClientDataManager.logger.error((Object)("Failed to get children of: " + this.dir + "\nReason: " + e.toString()));
        }
        catch (NotBoundException e) {
            ClientDataManager.logger.error((Object)("Failed to get children of: " + this.dir + "\nReason: " + e.toString()));
        }
        catch (EdalAuthenticateException e) {
            ClientDataManager.logger.error((Object)("Failed to get children of: " + this.dir + "\nReason: " + e.toString()));
        }
        catch (PrimaryDataEntityVersionException e) {
            ClientDataManager.logger.error((Object)("Failed to get child: " + this.dir + "\nReason: " + e.toString()));
        }
        return children;
    }

    @Override
    public String getName() {
        try {
            return FileSystemHandler.VIRTUALFOLDERPREFIX + this.entity.getName();
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error((Object)("Failed to get name of: " + this.dir + "\nReason: " + e.toString()));
            return null;
        }
    }

    public Resource createNew(String arg0, InputStream arg1, Long arg2, String arg3) throws IOException, ConflictException, NotAuthorizedException, BadRequestException {
        throw new NotAuthorizedException("don't support this operation!", (Resource)this);
    }
}

