/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalAuthenticateException;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.rmi.server.Authentication;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.FileSystemCache;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.FileSystemHandler;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.metadata.ExtXMLConfig;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.metadata.Property;
import io.milton.http.Auth;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.resource.GetableResource;
import io.milton.resource.PropFindableResource;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;

public class PrimaryDataEntityPropertyVirtualResource
implements GetableResource,
PropFindableResource {
    private String content;
    private Property prop;
    private String name;
    private String filename;
    private long version;
    protected FileSystemHandler fileSystemHandler;

    public PrimaryDataEntityPropertyVirtualResource(ClientPrimaryDataEntityVersion v, long revision) throws JAXBException, MetaDataException {
        try {
            ExtXMLConfig conf = new ExtXMLConfig(Property.class);
            this.prop = new Property(v.getMetaData(), revision, v.isDeleted());
            this.content = conf.toString(this.prop);
            this.name = this.prop.getTitle();
            this.version = revision;
        }
        catch (RemoteException e) {
            ClientDataManager.logger.fatal((Object)("Failed to load/initialize FileSystemHandler: " + e.getMessage()));
        }
    }

    public PrimaryDataEntityPropertyVirtualResource(String filename, FileSystemHandler fs) throws JAXBException, RemoteException, PrimaryDataDirectoryException, NotBoundException, EdalAuthenticateException, PrimaryDataEntityVersionException, MetaDataException {
        ClientPrimaryDataEntity ent;
        Pattern p;
        Matcher m;
        String pathname = filename;
        String xmlfilename = filename;
        int idx = filename.lastIndexOf("/");
        if (idx > 0) {
            pathname = filename.substring(0, idx);
            xmlfilename = filename.substring(idx + 1);
        }
        if ((m = (p = Pattern.compile("(.*)\\.v([0-9]+)\\.?[^\\.]*\\.(properties\\.xml|.*)$")).matcher(xmlfilename)).matches() && fs != null && (ent = fs.getEntity(pathname)) != null) {
            long version = Long.valueOf(m.group(2));
            ClientPrimaryDataEntityVersion v = FileSystemHandler.getVersion(ent, version);
            ExtXMLConfig conf = new ExtXMLConfig(Property.class);
            this.prop = new Property(v.getMetaData(), version, v.isDeleted());
            this.content = conf.toString(this.prop);
            this.name = this.prop.getTitle();
            this.version = version;
        }
    }

    public Long getContentLength() {
        if (this.content == null) {
            return 0L;
        }
        long length = this.content.getBytes().length;
        return length;
    }

    public String getContentType(String accepts) {
        return "text/xml";
    }

    public Long getMaxAgeSeconds(Auth auth) {
        return 60L;
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException, NotFoundException {
        out.write(this.content.getBytes());
    }

    public Object authenticate(String user, String password) {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("user", user);
        info.put("password", password);
        return info;
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        if (auth == null || auth.getTag() == null) {
            return false;
        }
        Map info = (Map)auth.getTag();
        String username = info.get("user").toString();
        if (FileSystemCache.get(username) != null) {
            return true;
        }
        Authentication loginobj = new Authentication(username, info.get("password").toString());
        try {
            ClientDataManager myClient = new ClientDataManager(FileSystemHandler.REGISTRY_PORT, FileSystemHandler.HOST, loginobj);
            ClientPrimaryDataDirectory rootDirectory = myClient.getRootDirectory();
            this.fileSystemHandler = new FileSystemHandler(rootDirectory);
            FileSystemCache.put(username, this.fileSystemHandler);
            Pattern p = Pattern.compile("(.*)\\.v([0-9]+)\\.?[^\\.]*\\.(properties\\.xml|.*)$");
            Matcher m = p.matcher(this.filename);
            if (m.matches()) {
                ClientPrimaryDataEntity ent = this.fileSystemHandler.getEntity(m.group(1));
                long version = Long.valueOf(m.group(2));
                ClientPrimaryDataEntityVersion v = FileSystemHandler.getVersion(ent, version);
                ExtXMLConfig conf = new ExtXMLConfig(Property.class);
                this.prop = new Property(v.getMetaData(), version, v.isDeleted());
                this.content = conf.toString(this.prop);
                this.name = this.prop.getTitle();
                this.version = version;
            }
            return true;
        }
        catch (MetaDataException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            ClientDataManager.logger.fatal((Object)("Failed to load/initialize FileSystemHandler: " + e.getMessage()));
        }
        catch (NotBoundException e) {
            ClientDataManager.logger.fatal((Object)("Failed to load/initialize FileSystemHandler: " + e.getMessage()));
        }
        catch (PrimaryDataDirectoryException e) {
            ClientDataManager.logger.fatal((Object)("Failed to load/initialize FileSystemHandler: " + e.getMessage()));
        }
        catch (EdalAuthenticateException e) {
            ClientDataManager.logger.fatal((Object)("Failed to load/initialize FileSystemHandler: " + e.getMessage()));
        }
        catch (EdalException e) {
            ClientDataManager.logger.fatal((Object)("Failed to load/initialize FileSystemHandler: " + e.getMessage()));
        }
        return false;
    }

    public String checkRedirect(Request request) {
        return null;
    }

    public Date getModifiedDate() {
        return new Date(System.currentTimeMillis());
    }

    public String getName() {
        Pattern p = Pattern.compile("(.*)\\.v[0-9]+\\.[^\\.]+\\.properties\\.xml$");
        Matcher m = p.matcher(this.name);
        if (m.matches()) {
            return m.group(1) + ".v" + this.version + "." + m.group(2) + ".properties.xml";
        }
        return this.name + ".v" + this.version + ".properties.xml";
    }

    public String getRealm() {
        return null;
    }

    public String getUniqueId() {
        return null;
    }

    public Date getCreateDate() {
        return new Date(System.currentTimeMillis());
    }
}

