/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFileException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataFormat;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataSize;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalAuthenticateException;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.FileSystemHandler;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data.PrimaryDataEntityResource;
import io.milton.http.Auth;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.resource.CollectionResource;
import io.milton.resource.DeletableResource;
import io.milton.resource.GetableResource;
import io.milton.resource.MoveableResource;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.security.AccessControlException;
import java.util.Map;

public class PrimaryDataFileResource
extends PrimaryDataEntityResource
implements GetableResource,
DeletableResource,
MoveableResource {
    private ClientPrimaryDataFile file;
    private String name;

    public PrimaryDataFileResource(String path, FileSystemHandler fileSystemHandler) throws RemoteException, PrimaryDataDirectoryException, NotBoundException, EdalAuthenticateException {
        super(path, fileSystemHandler);
        if (this.entity != null) {
            this.file = (ClientPrimaryDataFile)this.entity;
            this.name = this.file.getName();
        }
    }

    @Override
    public boolean authorise(Request request, Request.Method method, Auth auth) {
        boolean b = super.authorise(request, method, auth);
        if (this.entity != null) {
            this.file = (ClientPrimaryDataFile)this.entity;
            try {
                this.name = this.file.getName();
            }
            catch (RemoteException e) {
                ClientDataManager.logger.fatal((Object)("Failed to load/initialize FileSystemHandler: " + e.getMessage()));
            }
        }
        return b;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException, NotFoundException {
        try {
            ClientPrimaryDataEntityVersion v = this.file.getCurrentVersion();
            if (v.getRevision() > 0L && !v.isDeleted()) {
                this.file.switchCurrentVersion(v);
                this.file.read(out);
            }
        }
        catch (PrimaryDataFileException e) {
            ClientDataManager.logger.error((Object)("Failed to send content of: " + this.file + "\nReason" + e.toString()));
        }
        catch (AccessControlException e) {
            ClientDataManager.logger.error((Object)("Failed to send content of: " + this.file + "\nReason" + e.toString()));
        }
        catch (PrimaryDataEntityVersionException e) {
            ClientDataManager.logger.error((Object)("Failed to send content of: " + this.file + "\nReason" + e.toString()));
        }
    }

    public Long getContentLength() {
        DataSize size = null;
        try {
            size = (DataSize)this.file.getCurrentVersion().getMetaData().getElementValue((Enum)EnumDublinCoreElements.SIZE);
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error((Object)("Failed to get content-length of: " + this.file + "\nReason" + e.toString()));
        }
        catch (MetaDataException e) {
            ClientDataManager.logger.error((Object)("Failed to get content-length of: " + this.file + "\nReason" + e.toString()));
        }
        catch (AccessControlException e) {
            ClientDataManager.logger.error((Object)("Failed to get content-length of: " + this.file + "\nReason" + e.toString()));
        }
        return size.getFileSize();
    }

    public String getContentType(String accepts) {
        String type = "default";
        try {
            DataFormat dataType = (DataFormat)this.file.getMetaData().getElementValue((Enum)EnumDublinCoreElements.FORMAT);
            type = dataType.getMimeType();
            return type;
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error((Object)("Failed to get content-type of: " + this.file + "\nReason" + e.toString()));
        }
        catch (MetaDataException e) {
            ClientDataManager.logger.error((Object)("Failed to get content length of: " + this.file + "\nReason" + e.toString()));
        }
        return type;
    }

    public Long getMaxAgeSeconds(Auth auth) {
        return null;
    }

    public void delete() throws NotAuthorizedException, ConflictException, BadRequestException {
        try {
            this.fileSystemHandler.removecache(this.file.getPath());
            if (!this.file.getCurrentVersion().isDeleted()) {
                this.file.delete();
            }
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error((Object)("Failed to delete PrimaryDataFileResource: " + this.file + "\nReason" + e.toString()));
        }
        catch (PrimaryDataEntityVersionException e) {
            ClientDataManager.logger.error((Object)("Failed to delete PrimaryDataFileResource: " + this.file + "\nReason" + e.toString()));
        }
        catch (PrimaryDataDirectoryException e) {
            ClientDataManager.logger.error((Object)("Failed to delete PrimaryDataFileResource: " + this.file + "\nReason" + e.toString()));
        }
    }

    public void moveTo(CollectionResource rDest, String name) throws ConflictException, NotAuthorizedException, BadRequestException {
        try {
            this.fileSystemHandler.removecache(this.file.getPath());
            this.file.rename(name);
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error((Object)("Failed to move/rename File: " + e.toString()));
        }
        catch (PrimaryDataEntityVersionException e) {
            ClientDataManager.logger.error((Object)("Failed to rename File: " + e.toString()));
        }
        catch (PrimaryDataDirectoryException e) {
            ClientDataManager.logger.error((Object)("Failed to move/rename File: " + e.toString()));
        }
    }
}

