/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFileException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataFormat;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataSize;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalAuthenticateException;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.FileSystemHandler;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data.PrimaryDataEntityResource;
import io.milton.http.Auth;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.resource.GetableResource;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.security.AccessControlException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PrimaryDataFileVirtualResource
extends PrimaryDataEntityResource
implements GetableResource {
    private ClientPrimaryDataFile file;
    private long version;
    private String name;

    public PrimaryDataFileVirtualResource(String path, long revision, FileSystemHandler fileSystemHandler) throws RemoteException, PrimaryDataDirectoryException, NotBoundException, EdalAuthenticateException, PrimaryDataEntityVersionException {
        super(path, fileSystemHandler);
        this.version = revision;
        if (this.entity != null) {
            this.file = (ClientPrimaryDataFile)this.entity;
            ClientPrimaryDataEntityVersion v = FileSystemHandler.getVersion(this.file, this.version);
            try {
                this.name = v.getMetaData().getElementValue((Enum)EnumDublinCoreElements.TITLE).getString();
            }
            catch (MetaDataException e) {
                this.name = this.file.getName();
                ClientDataManager.logger.error((Object)("Failed to get name of: " + this.file + "\nReason" + e.toString()));
            }
        }
    }

    @Override
    public boolean authorise(Request request, Request.Method method, Auth auth) {
        boolean b = super.authorise(request, method, auth);
        if (this.entity != null) {
            this.file = (ClientPrimaryDataFile)this.entity;
            try {
                this.name = this.file.getName();
            }
            catch (RemoteException e) {
                ClientDataManager.logger.fatal((Object)("Failed to load/initialize FileSystemHandler: " + e.getMessage()));
            }
        }
        return b;
    }

    @Override
    public String getName() {
        Pattern p = Pattern.compile("(.*)\\.([^\\.]*)$");
        Matcher m = p.matcher(this.name);
        if (m.matches()) {
            return m.group(1) + ".v" + this.version + "." + m.group(2);
        }
        return this.name;
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException, NotFoundException {
        try {
            ClientPrimaryDataEntityVersion v = FileSystemHandler.getVersion(this.file, this.version);
            this.file.switchCurrentVersion(v);
            this.file.read(out);
        }
        catch (PrimaryDataFileException e) {
            ClientDataManager.logger.error((Object)("Failed to send content of: " + this.file + "\nReason" + e.toString()));
        }
        catch (AccessControlException e) {
            ClientDataManager.logger.error((Object)("Failed to send content of: " + this.file + "\nReason" + e.toString()));
        }
        catch (PrimaryDataEntityVersionException e) {
            ClientDataManager.logger.error((Object)("Failed to send content of: " + this.file + "\nReason" + e.toString()));
        }
    }

    public Long getContentLength() {
        DataSize size = null;
        try {
            ClientPrimaryDataEntityVersion v = FileSystemHandler.getVersion(this.file, this.version);
            size = (DataSize)v.getMetaData().getElementValue((Enum)EnumDublinCoreElements.SIZE);
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error((Object)("Failed to get content-length of: " + this.file + "\nReason" + e.toString()));
        }
        catch (MetaDataException e) {
            ClientDataManager.logger.error((Object)("Failed to get content-length of: " + this.file + "\nReason" + e.toString()));
        }
        catch (AccessControlException e) {
            ClientDataManager.logger.error((Object)("Failed to get content-length of: " + this.file + "\nReason" + e.toString()));
        }
        return size.getFileSize();
    }

    public String getContentType(String accepts) {
        String type = "default";
        try {
            DataFormat dataType = (DataFormat)this.file.getMetaData().getElementValue((Enum)EnumDublinCoreElements.FORMAT);
            type = dataType.getMimeType();
            return type;
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error((Object)("Failed to get content-type of: " + this.file + "\nReason" + e.toString()));
        }
        catch (MetaDataException e) {
            ClientDataManager.logger.error((Object)("Failed to get content length of: " + this.file + "\nReason" + e.toString()));
        }
        return type;
    }

    public Long getMaxAgeSeconds(Auth auth) {
        return null;
    }
}

