/*
 * Copyright (c) 2016 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Creative Commons Attribution-NoDerivatives 4.0 International (CC BY-ND 4.0)
 * which accompanies this distribution, and is available at http://creativecommons.org/licenses/by-nd/4.0/
 *
 * Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - RMI Client, FileChooser and WebDAV
 */
package de.ipk_gatersleben.bit.bi.edal.publication;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;

public class PropertyLoader {

	public static final String PROGRAM_NAME = "IPK Data Publication System";

	private static String userAttributeFile = "attributes.txt";

	private static String propertyFile = "properties.txt";

	public static Image EDAL_LOGO = null;

	public static Image EDAL_ICON = null;

	public static Properties props;

	public static Properties userValues;

	public static Path RUNNING_PATH = null;

	public static final Color HEADER_FOOTER_COLOR = new Color(210, 210, 210);

	public static final Color MAIN_BACKGROUND_COLOR = Color.WHITE;

	public static final Color LABEL_COLOR = new Color(0, 132, 184);

	public static final Color MAIN_FONT_COLOR = new Color(102, 102, 102);

	public static final int DEFAULT_FONT_SIZE = 13;

	public static final Font DEFAULT_FONT = new Font(Font.SANS_SERIF, 0, PropertyLoader.DEFAULT_FONT_SIZE);

	public static final int TITLE_PANEL_HEIGHT = 2 * DEFAULT_FONT_SIZE;

	public static final int SUBJECTS_PANEL_HEIGHT = 6 * DEFAULT_FONT_SIZE;

	public static final int PUBLISHER_PANEL_HEIGHT = 5 * DEFAULT_FONT_SIZE;

	public static final int AUTHOR_PANEL_HEIGHT = 10 * DEFAULT_FONT_SIZE;

	public static final int EMBARGO_PANEL_HEIGHT = 10 * DEFAULT_FONT_SIZE;

	public static final int DESCRIPTION_PANEL_HEIGHT = 5 * DEFAULT_FONT_SIZE;

	public static final int TWO_LINE_HEIGHT = 2 * DEFAULT_FONT_SIZE;

	public static final Dimension MINIMUM_DIM_PUBLICATION_FRAME = new Dimension(1024, 786);

	public static final int ATTRIBUTE_PANEL_WIDTH = 680;
	public static final int ATTRIBUTE_LABEL_WIDTH = 120;

	public static List<String> SUPPORTED_LICENSES = null;

	public static AttributeLabel UPLOADPATH_LABEL, TITLE_LABEL, DESCRIPTION_LABEL, AUTHORS_LABEL, SUBJECTS_LABEL,
			LANGUAGE_LABEL, LICENSE_LABEL, PUBLISHER_LABEL, EMBARGO_LABEL;

	private static void initGraphicComponents() {
		UPLOADPATH_LABEL = new AttributeLabel(PropertyLoader.props.getProperty("UPLOAD_LABEL"),
				PropertyLoader.props.getProperty("UPLOAD_TOOLTIP"));
		TITLE_LABEL = new AttributeLabel(PropertyLoader.props.getProperty("TITLE_LABEL"),
				PropertyLoader.props.getProperty("TITLE_TOOLTIP"));
		DESCRIPTION_LABEL = new AttributeLabel(PropertyLoader.props.getProperty("DESCRIPTION_LABEL"),
				PropertyLoader.props.getProperty("DESCRIPTION_TOOLTIP"));
		AUTHORS_LABEL = new AttributeLabel(PropertyLoader.props.getProperty("AUTHORS_LABEL"),
				PropertyLoader.props.getProperty("AUTHORS_TOOLTIP"));
		SUBJECTS_LABEL = new AttributeLabel(PropertyLoader.props.getProperty("SUBJECTS_LABEL"),
				PropertyLoader.props.getProperty("SUBJECTS_TOOLTIP"));
		LANGUAGE_LABEL = new AttributeLabel(PropertyLoader.props.getProperty("LANGUAGE_LABEL"),
				PropertyLoader.props.getProperty("LANGUAGE_TOOLTIP"));
		LICENSE_LABEL = new AttributeLabel(PropertyLoader.props.getProperty("LICENSE_LABEL"),
				PropertyLoader.props.getProperty("LICENSE_TOOLTIP"));
		PUBLISHER_LABEL = new AttributeLabel(PropertyLoader.props.getProperty("PUBLISHER_LABEL"),
				PropertyLoader.props.getProperty("PUBLISHER_TOOLTIP"));
		EMBARGO_LABEL = new AttributeLabel(PropertyLoader.props.getProperty("EMBARGO_LABEL"),
				PropertyLoader.props.getProperty("EMBARGO_TOOLTIP"));
	}

	private static void loadEdalLogos() {
		EDAL_LOGO = new ImageIcon(PropertyLoader.class.getResource("edal_scaled.png")).getImage();
		EDAL_ICON = new ImageIcon(PropertyLoader.class.getResource("edal_icon.png")).getImage();

	}

	private static void loadProperties() {

		props = new Properties();

		try {
			props.load(new InputStreamReader(PropertyLoader.class.getResourceAsStream(propertyFile), "UTF-8"));
		} catch (IOException | NullPointerException e) {

			JOptionPane.showMessageDialog(null,
					"Unable to load property file '" + propertyFile + "' : " + e.getMessage(), "ERROR",
					JOptionPane.ERROR_MESSAGE);
			System.exit(0);
		}

		SUPPORTED_LICENSES = new ArrayList<String>();

		int i = 1;

		while (PropertyLoader.props.getProperty("LICENSE_" + i) != null) {
			SUPPORTED_LICENSES.add(PropertyLoader.props.getProperty("LICENSE_" + i));
			i++;
		}

	}

	private static void loadRunnigPath() {

		try {
			RUNNING_PATH = Paths.get(PropertyLoader.class.getProtectionDomain().getCodeSource().getLocation().toURI());
		} catch (Exception e) {
			RUNNING_PATH = Paths.get(System.getProperty("user.home"));
		}
	}

	private static void loadUserValues() {

		userValues = new Properties();

		try {
			userValues
					.load(new FileInputStream(Paths.get(System.getProperty("user.home"), userAttributeFile).toFile()));
		} catch (IOException | NullPointerException e) {
			try {
				Files.createFile(Paths.get(System.getProperty("user.home"), userAttributeFile));
			} catch (IOException e1) {
				JOptionPane.showMessageDialog(null,
						"Unable to load/create user file '" + userAttributeFile + "' : " + e.getMessage(), "ERROR",
						JOptionPane.ERROR_MESSAGE);
				System.exit(0);
			}
		}

	}

	public static void initialize() {
		Locale.setDefault(Locale.ENGLISH);

		loadProperties();
		loadUserValues();
		loadRunnigPath();
		loadEdalLogos();
		initGraphicComponents();

		ToolTipManager.sharedInstance().setInitialDelay(0);
	}

	private static void saveUserValue() {

		File file = Paths.get(System.getProperty("user.home"), userAttributeFile).toFile();

		try {
			OutputStream out = new FileOutputStream(file);
			userValues.store(out, "Update");
		} catch (IOException e) {
			e.printStackTrace();
		}

	}

	public static String loadSubjectsString() {

		String subjects = PropertyLoader.userValues.getProperty("SUBJECTS");

		if (subjects == null || subjects.isEmpty()) {
			return PropertyLoader.props.getProperty("DEFAULT_SUBJECTS_STRING");
		} else
			return subjects;

	}

	public static String loadPublisherString() {

		String publisherString = PropertyLoader.userValues.getProperty("PUBLISHER");

		if (publisherString == null || publisherString.isEmpty()) {
			return PropertyLoader.props.getProperty("DEFAULT_PUBLISHER_STRING");
		} else {
			StringBuffer buffer = new StringBuffer();

			String[] publisher = publisherString.split(";");

			for (int i = 0; i < publisher.length; i++) {

				buffer.append(publisher[i]);

				if (i != publisher.length - 1) {
					buffer.append(", ");
				}
			}
			return buffer.toString();
		}
	}

	public static String loadAuthorsString() {
		String authorsString = PropertyLoader.userValues.getProperty("AUTHORS");

		if (authorsString == null || authorsString.isEmpty()) {
			return PropertyLoader.props.getProperty("DEFAULT_AUTHORS_STRING");
		} else {

			StringBuffer buffer = new StringBuffer();

			String[] authors = authorsString.split(";");

			for (int i = 0; i < authors.length; i++) {

				String[] author = authors[i].split("@");

				/* author is a NaturalPerson */
				if (!author[1].isEmpty() && !author[2].isEmpty()) {

					buffer.append(author[2]);
					buffer.append(", ");
					buffer.append(author[1]);
					if (i != authors.length - 1) {
						buffer.append("; ");
					}
				}
				/* author is a LegalPerson */
				else if (!author[3].isEmpty()) {
					buffer.append(author[3]);
					if (i != authors.length - 1) {
						buffer.append("; ");
					}
				}
			}
			return buffer.toString();
		}

	}

	public static void setUserValue(String key, String value) {
		PropertyLoader.userValues.setProperty(key, value);
		PropertyLoader.saveUserValue();

	}

	public static String loadLanguageString() {
		String language = PropertyLoader.userValues.getProperty("LANGUAGE");

		if (language == null || language.isEmpty()) {
			return PropertyLoader.props.getProperty("DEFAULT_LANGUAGE_STRING");
		} else
			return language;
	}

	public static String loadLicenseString() {
		String license = PropertyLoader.userValues.getProperty("LICENSE");

		if (license == null || license.isEmpty()) {
			return PropertyLoader.props.getProperty("LICENSE_1");
		} else
			return license;
	}

	public static String loadUploadPathString() {
		String uploadPath = PropertyLoader.userValues.getProperty("UPLOAD_PATH");

		if (uploadPath == null || uploadPath.isEmpty()) {
			return PropertyLoader.props.getProperty("DEFAULT_UPLOAD_PATH_STRING");
		} else if (Files.exists(Paths.get(uploadPath))) {
			return uploadPath;
		} else {
			setUserValue("UPLOAD_PATH", PropertyLoader.props.getProperty("DEFAULT_UPLOAD_PATH_STRING"));
			return PropertyLoader.props.getProperty("DEFAULT_UPLOAD_PATH_STRING");
		}
	}
}