/*
 * Copyright (c) 2016 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Creative Commons Attribution-NoDerivatives 4.0 International (CC BY-ND 4.0)
 * which accompanies this distribution, and is available at http://creativecommons.org/licenses/by-nd/4.0/
 *
 * Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - RMI Client, FileChooser and WebDAV
 */
package de.ipk_gatersleben.bit.bi.edal.publication;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.Paths;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.publication.listener.ShutdownWindowsListener;
import de.ipk_gatersleben.bit.bi.edal.publication.metadata.MetaDataCollector;
import de.ipk_gatersleben.bit.bi.edal.publication.metadata.ProgressBarDialog;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;

public class PublicationButtonLinePanel extends JPanel implements ActionListener {

	private static final long serialVersionUID = -6295685143671113656L;
	private static SmallButton SUBMIT_BUTTON = new SmallButton("SUBMIT");
	private static SmallButton QUIT_BUTTON = new SmallButton("QUIT");
	public static boolean updatePublicationFlag = false;
	private ClientDataManager clientDataManager = null;

	public PublicationButtonLinePanel(ClientDataManager clientDataManager) {

		this.clientDataManager = clientDataManager;

		JPanel buttonPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));

		JPanel field = new JPanel(new FlowLayout(FlowLayout.LEFT));

		JLabel label = new JLabel("* - required fields");

		label.setForeground(Color.RED);
		label.setFont(new Font(Font.SANS_SERIF, Font.BOLD, PropertyLoader.DEFAULT_FONT_SIZE));
		field.add(label);
		field.setBackground(PropertyLoader.HEADER_FOOTER_COLOR);

		buttonPanel.add(SUBMIT_BUTTON);
		buttonPanel.add(QUIT_BUTTON);
		buttonPanel.setBackground(PropertyLoader.HEADER_FOOTER_COLOR);

		SUBMIT_BUTTON.addActionListener(this);
		QUIT_BUTTON.addActionListener(this);

		this.setBackground(PropertyLoader.HEADER_FOOTER_COLOR);
		this.setLayout(new GridLayout(1, 1));
		this.add(field);
		this.add(buttonPanel);
		this.setBorder(new MatteBorder(2, 0, 0, 0, Color.BLACK));

	}

	public static JButton getSubmitButton() {
		return SUBMIT_BUTTON;
	}

	@Override
	public void actionPerformed(ActionEvent actionEvent) {

		boolean everythingCorrect = true;

		if (actionEvent.getSource().equals(SUBMIT_BUTTON)) {

			if (PublicationMainPanel.uploadPathField.getText().equalsIgnoreCase(PropertyLoader.props.getProperty("DEFAULT_UPLOAD_PATH_STRING"))) {

				PropertyLoader.UPLOADPATH_LABEL.setForeground(Color.RED);
				PublicationFrame.updateUI();
				everythingCorrect = false;
			}
			if (Utils.cleanUpString(PublicationMainPanel.titleField.getText()).equalsIgnoreCase(Utils.cleanUpString(PublicationMainPanel.DEFAULT_TITLE_STRING))) {

				PropertyLoader.TITLE_LABEL.setForeground(Color.RED);
				PublicationFrame.updateUI();
				everythingCorrect = false;
			}

			if (Utils.cleanUpString(PublicationMainPanel.descriptionField.getText()).equalsIgnoreCase(Utils.cleanUpString(PublicationMainPanel.DEFAULT_DESCRIPTION_STRING))) {

				PropertyLoader.DESCRIPTION_LABEL.setForeground(Color.RED);
				PublicationFrame.updateUI();
				everythingCorrect = false;
			}

			if (Utils.cleanUpString(PublicationMainPanel.authorsField.getText()).equalsIgnoreCase(Utils.cleanUpString(PropertyLoader.props.getProperty("DEFAULT_AUTHORS_STRING")))) {

				PropertyLoader.AUTHORS_LABEL.setForeground(Color.RED);
				PublicationFrame.updateUI();
				everythingCorrect = false;
			}

			if (Utils.checkIfStringIsEmpty(PublicationMainPanel.publisherField.getText())) {

				PropertyLoader.PUBLISHER_LABEL.setForeground(Color.RED);
				PublicationFrame.updateUI();
				everythingCorrect = false;
			}

			if (Utils.cleanUpString(PublicationMainPanel.subjectsField.getText()).equalsIgnoreCase(Utils.cleanUpString(PropertyLoader.props.getProperty("DEFAULT_SUBJECTS_STRING")))) {

				PropertyLoader.SUBJECTS_LABEL.setForeground(Color.RED);
				PublicationFrame.updateUI();
				everythingCorrect = false;
			}

			if (everythingCorrect) {

				MetaDataCollector collector = new MetaDataCollector();
				collector.collectAllMetaData();

				MetaData metaData = this.clientDataManager.createMetadataInstance();

				try {
					metaData.setElementValue(EnumDublinCoreElements.CREATOR, collector.getCreators());
					metaData.setElementValue(EnumDublinCoreElements.CONTRIBUTOR, collector.getContributors());
					metaData.setElementValue(EnumDublinCoreElements.SUBJECT, collector.getSubjects());
					metaData.setElementValue(EnumDublinCoreElements.CREATOR, collector.getCreators());
					metaData.setElementValue(EnumDublinCoreElements.LANGUAGE, collector.getLanguage());
					metaData.setElementValue(EnumDublinCoreElements.RIGHTS, collector.getLicense());
					metaData.setElementValue(EnumDublinCoreElements.DESCRIPTION, collector.getDescription());
					metaData.setElementValue(EnumDublinCoreElements.PUBLISHER, collector.getPublisher());
					metaData.setElementValue(EnumDublinCoreElements.TITLE, collector.getTitle());
				} catch (MetaDataException e) {
					e.printStackTrace();
				}

				try {

					int numberOfFiles = Utils.countObjectsWithErrorsAndWarnings(null, Paths.get(PublicationMainPanel.uploadPathField.getText()));

					if (numberOfFiles != 0) {

						ProgressBarDialog dialog = new ProgressBarDialog(null, numberOfFiles, Paths.get(PublicationMainPanel.uploadPathField.getText()), metaData, PublicationFrame.getUserDirectory(), new InternetAddress(PublicationFrame.loggedUser), collector.getEmbargoDate());

						dialog.showDialog();

						if (dialog.getReturnValue() == 1) {
							PublicationMainPanel.reset();
						}
					}

				} catch (AddressException e) {
					e.printStackTrace();
				}

			}

		} else if (actionEvent.getSource().equals(QUIT_BUTTON)) {
			ShutdownWindowsListener shutdown = new ShutdownWindowsListener();
			shutdown.windowClosing(null);
		}
	}

}
