/*
 * Copyright (c) 2016 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Creative Commons Attribution-NoDerivatives 4.0 International (CC BY-ND 4.0)
 * which accompanies this distribution, and is available at http://creativecommons.org/licenses/by-nd/4.0/
 *
 * Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - RMI Client, FileChooser and WebDAV
 */
package de.ipk_gatersleben.bit.bi.edal.publication;

import java.awt.BorderLayout;
import java.rmi.RemoteException;

import javax.swing.JFrame;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.publication.listener.ShutdownWindowsListener;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;

public class PublicationFrame extends JFrame {

	private static final long serialVersionUID = 3152855359717852975L;

	private static PublicationMainPanel mainPanel;

	private static PublicationHtmlTextPanel headPanel;

	private static PublicationButtonLinePanel buttonPanel;
	
	public static PublicationButtonLinePanel getButtonPanel() {
		return buttonPanel;
	}

	public static ClientPrimaryDataDirectory rootDirectory = null;

	public static String loggedUser = "";

	public static void updateUI() {

		PublicationFrame.mainPanel.revalidate();
		PublicationFrame.mainPanel.repaint();
		PublicationFrame.buttonPanel.revalidate();
		PublicationFrame.buttonPanel.repaint();
		PublicationFrame.headPanel.updateHtml();
	}

	public PublicationFrame(String loggedUser, ClientDataManager clientDataManager) throws Exception {

		this.setTitle(PropertyLoader.PROGRAM_NAME);

		this.setIconImage(PropertyLoader.EDAL_ICON);

		this.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);

		this.addWindowListener(new ShutdownWindowsListener());
		
		PublicationFrame.mainPanel = new PublicationMainPanel();
		PublicationFrame.headPanel = new PublicationHtmlTextPanel();
		PublicationFrame.buttonPanel = new PublicationButtonLinePanel(clientDataManager);
		PublicationFrame.loggedUser = loggedUser;

		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add(PublicationFrame.headPanel, BorderLayout.NORTH);
		this.getContentPane().add(PublicationFrame.mainPanel, BorderLayout.CENTER);
		this.getContentPane().add(PublicationFrame.buttonPanel, BorderLayout.SOUTH);

		this.setMinimumSize(PropertyLoader.MINIMUM_DIM_PUBLICATION_FRAME);
		this.setPreferredSize(PropertyLoader.MINIMUM_DIM_PUBLICATION_FRAME);

		this.pack();
		/* place windows centered */
		this.setLocationRelativeTo(null);
		this.setVisible(true);
	}

	/**
	 * Get the {@link ClientPrimaryDataDirectory} for the logged user or create
	 * a new one is not exist.
	 * 
	 * @return the {@link ClientPrimaryDataDirectory} of the current user.
	 */
	public static ClientPrimaryDataDirectory getUserDirectory() {

		ClientPrimaryDataDirectory userDirectory = null;

		try {
			userDirectory = (ClientPrimaryDataDirectory) PublicationFrame.rootDirectory.getPrimaryDataEntity(PublicationFrame.loggedUser);

		} catch (RemoteException e) {
			e.printStackTrace();
		} catch (PrimaryDataDirectoryException e) {
			try {
				userDirectory = PublicationFrame.rootDirectory.createPrimaryDataDirectory(PublicationFrame.loggedUser);
			} catch (RemoteException | PrimaryDataDirectoryException e1) {
				e1.printStackTrace();
			}
		}

		return userDirectory;

	}
}