/*
 * Copyright (c) 2016 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Creative Commons Attribution-NoDerivatives 4.0 International (CC BY-ND 4.0)
 * which accompanies this distribution, and is available at http://creativecommons.org/licenses/by-nd/4.0/
 *
 * Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - RMI Client, FileChooser and WebDAV
 */
package de.ipk_gatersleben.bit.bi.edal.publication;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseListener;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneConstants;

import de.ipk_gatersleben.bit.bi.edal.publication.attribute.panel.AuthorsPanel;
import de.ipk_gatersleben.bit.bi.edal.publication.attribute.panel.EmbargoPanel;
import de.ipk_gatersleben.bit.bi.edal.publication.attribute.panel.LanguagePanel;
import de.ipk_gatersleben.bit.bi.edal.publication.attribute.panel.LicensePanel;
import de.ipk_gatersleben.bit.bi.edal.publication.attribute.panel.PublisherPanel;
import de.ipk_gatersleben.bit.bi.edal.publication.attribute.panel.SubjectPanel;
import de.ipk_gatersleben.bit.bi.edal.publication.listener.NonFreeTextPanelMouseAdapter;
import de.ipk_gatersleben.bit.bi.edal.publication.listener.NonFreeTextPanelMouseAdapter.PanelType;
import de.ipk_gatersleben.bit.bi.edal.publication.listener.TextAreaCheckFocusListener;
import de.ipk_gatersleben.bit.bi.edal.publication.listener.TextAreaValueChangedFocusListener;

public class PublicationMainPanel extends JPanel {

	private static final long serialVersionUID = -894068063132047509L;

	public static final String DEFAULT_UPLOAD_PATH_STRING = PropertyLoader.loadUploadPathString();
	public static final String DEFAULT_TITLE_STRING = PropertyLoader.props.getProperty("DEFAULT_TITLE_STRING");
	public static final String DEFAULT_LANGUAGE_STRING = PropertyLoader.loadLanguageString();
	public static final String DEFAULT_LICENSE_STRING = PropertyLoader.loadLicenseString();
	public static final String DEFAULT_PUBLISHER_STRING = PropertyLoader.loadPublisherString();
	public static final String DEFAULT_DESCRIPTION_STRING = PropertyLoader.props.getProperty("DEFAULT_DESCRIPTION_STRING");
	public static final String DEFAULT_AUTHORS_STRING = PropertyLoader.loadAuthorsString();
	public static final String DEFAULT_SUBJECTS_STRING = PropertyLoader.loadSubjectsString();
	public static final String DEFAULT_EMBARGO_STRING = PropertyLoader.props.getProperty("DEFAULT_EMBARGO_STRING");

	public static AttributeTextArea uploadPathField = new AttributeTextArea(DEFAULT_UPLOAD_PATH_STRING, false, true);
	public static AttributeTextArea titleField = new AttributeTextArea(DEFAULT_TITLE_STRING, true, true);
	public static AttributeTextArea descriptionField = new AttributeTextArea(DEFAULT_DESCRIPTION_STRING, true, false);
	public static AttributeTextArea authorsField = new AttributeTextArea(DEFAULT_AUTHORS_STRING, false, true);
	public static AttributeTextArea subjectsField = new AttributeTextArea(DEFAULT_SUBJECTS_STRING, false, true);
	public static AttributeTextArea languageField = new AttributeTextArea(DEFAULT_LANGUAGE_STRING, false, true);
	public static AttributeTextArea licenseField = new AttributeTextArea(DEFAULT_LICENSE_STRING, false, true);
	public static AttributeTextArea publisherField = new AttributeTextArea(DEFAULT_PUBLISHER_STRING, false, true);
	public static AttributeTextArea embargoField = new AttributeTextArea(DEFAULT_EMBARGO_STRING, false, true);

	public static AuthorsPanel authorPanel;
	public static LanguagePanel languagePanel;
	public static LicensePanel licensePanel;
	public static SubjectPanel subjectPanel;
	public static PublisherPanel publisherPanel;
	public static EmbargoPanel embargboPanel;

	private static NonFreeTextPanelMouseAdapter openAuthorPanelListener;
	private static NonFreeTextPanelMouseAdapter openLanguagePanelListener;
	private static NonFreeTextPanelMouseAdapter openLicensePanelListener;
	private static NonFreeTextPanelMouseAdapter openUploadPanelListener;
	private static NonFreeTextPanelMouseAdapter openSubjectPanelListener;
	private static NonFreeTextPanelMouseAdapter openPublisherPanelListener;
	private static NonFreeTextPanelMouseAdapter openEmbargoPanelListener;

	private static JPanel mainPanel;

	static {
		authorPanel = new AuthorsPanel();
		languagePanel = new LanguagePanel();
		licensePanel = new LicensePanel();
		publisherPanel = new PublisherPanel();
		subjectPanel = new SubjectPanel();
		embargboPanel = new EmbargoPanel();

		openAuthorPanelListener = new NonFreeTextPanelMouseAdapter(PanelType.AUTHOR_PANEL);
		openLanguagePanelListener = new NonFreeTextPanelMouseAdapter(PanelType.LANGUAGE_PANEL);
		openLicensePanelListener = new NonFreeTextPanelMouseAdapter(PanelType.LICENSE_PANEL);
		openUploadPanelListener = new NonFreeTextPanelMouseAdapter(PanelType.UPLOAD_PANEL);
		openSubjectPanelListener = new NonFreeTextPanelMouseAdapter(PanelType.SUBJECT_PANEL);
		openPublisherPanelListener = new NonFreeTextPanelMouseAdapter(PanelType.PUBLISHER_PANEL);
		openEmbargoPanelListener = new NonFreeTextPanelMouseAdapter(PanelType.EMBARGO_PANEL);
	}

	public static AttributeSplitPane titleAuthorSplitPanel = null;
	public static AttributeSplitPane authorDescriptionSplitPanel = null;
	public static AttributeSplitPane descriptionSubjectsSplitPanel = null;
	public static AttributeSplitPane subjectsPublisherPanel = null;
	public static JPanel embargoLanguageLicensePanel = null;

	public PublicationMainPanel() {

		/* set ValueChangedListener */

		titleField.addFocusListener(new TextAreaValueChangedFocusListener(PropertyLoader.TITLE_LABEL, titleField, DEFAULT_TITLE_STRING));

		descriptionField.addFocusListener(new TextAreaValueChangedFocusListener(PropertyLoader.DESCRIPTION_LABEL, descriptionField, DEFAULT_DESCRIPTION_STRING));

		publisherField.addFocusListener(new TextAreaCheckFocusListener(PropertyLoader.PUBLISHER_LABEL, publisherField, DEFAULT_PUBLISHER_STRING));

		/* end ValueChangedListener */

		/* set other Listeners */

		authorsField.addMouseListener(openAuthorPanelListener);
		languageField.addMouseListener(openLanguagePanelListener);
		licenseField.addMouseListener(openLicensePanelListener);
		uploadPathField.addMouseListener(openUploadPanelListener);
		subjectsField.addMouseListener(openSubjectPanelListener);
		publisherField.addMouseListener(openPublisherPanelListener);
		embargoField.addMouseListener(openEmbargoPanelListener);

		/* end other Listeners */

		AttributeTablePanel descriptionPanel = new AttributeTablePanel(PropertyLoader.DESCRIPTION_LABEL, descriptionField, PropertyLoader.DESCRIPTION_PANEL_HEIGHT);

		AttributeTablePanel titleAttributePanel = new AttributeTablePanel(PropertyLoader.TITLE_LABEL, titleField, PropertyLoader.TITLE_PANEL_HEIGHT);

		AttributeTablePanel uploadAttributePanel = new AttributeTablePanel(PropertyLoader.UPLOADPATH_LABEL, uploadPathField, PropertyLoader.TWO_LINE_HEIGHT);

		AttributeTablePanel authorsAttributePanel = new AttributeTablePanel(PropertyLoader.AUTHORS_LABEL, authorsField, PropertyLoader.AUTHOR_PANEL_HEIGHT);

		AttributeTablePanel subjectsAttributePanel = new AttributeTablePanel(PropertyLoader.SUBJECTS_LABEL, subjectsField, PropertyLoader.SUBJECTS_PANEL_HEIGHT);

		AttributeTablePanel languageAttributePanel = new AttributeTablePanel(PropertyLoader.LANGUAGE_LABEL, languageField, PropertyLoader.TWO_LINE_HEIGHT);

		AttributeTablePanel licenseAttributePanel = new AttributeTablePanel(PropertyLoader.LICENSE_LABEL, licenseField, PropertyLoader.TWO_LINE_HEIGHT);

		AttributeTablePanel publisherAttributePanel = new AttributeTablePanel(PropertyLoader.PUBLISHER_LABEL, publisherField, PropertyLoader.PUBLISHER_PANEL_HEIGHT);

		AttributeTablePanel embargoAttributePanel = new AttributeTablePanel(PropertyLoader.EMBARGO_LABEL, embargoField, PropertyLoader.TWO_LINE_HEIGHT);

		// publicationButtonLinePanel = new PublicationButtonLinePanel();

		// mainPanel = new JPanel();
		// BoxLayout boxLayout = new BoxLayout(mainPanel, BoxLayout.Y_AXIS);
		// mainPanel.setLayout(boxLayout);
		// mainPanel.add(uploadAttributePanel, UPLOAD_PANEL_COMPONENT_NUMBER);
		// mainPanel.add(titleAttributePanel, TITLE_PANEL_COMPONENT_NUMBER);
		// mainPanel.add(authorsAttributePanel, AUTHOR_PANEL_COMPONENT_NUMBER);
		// mainPanel.add(descriptionPanel, DESCRIPTION_PANEL_COMPONENT_NUMBER);
		// mainPanel.add(subjectsAttributePanel,
		// SUBJECTS_PANEL_COMPONENT_NUMBER);
		// mainPanel.add(languageAttributePanel,
		// LANGUAGE_PANEL_COMPONENT_NUMBER);
		// mainPanel.add(publisherAttributePanel,
		// PUBLISHER_PANEL_COMPONENT_NUMBER);
		// mainPanel.add(embargoAttributePanel, EMBARGO_DATE_COMPONENT_NUMBER);
		// mainPanel.add(publicationButtonLinePanel,
		// BUTTON_LINE_PANEL_COMPONENT_NUMBER);
		// mainPanel.setBackground(PropertyLoader.HEADER_FOOTER_COLOR);
		//
		// JScrollPane scrollableMainPane = new JScrollPane(mainPanel,
		// ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED,
		// ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		//
		// scrollableMainPane.setPreferredSize(new Dimension(400, 400));
		// scrollableMainPane.setBorder(BorderFactory.createEmptyBorder());
		// this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		// this.add(scrollableMainPane);

		mainPanel = new JPanel();
		mainPanel.setLayout(new BorderLayout());

		titleAttributePanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));

		titleAuthorSplitPanel = new AttributeSplitPane(titleAttributePanel, authorsAttributePanel);
		titleAuthorSplitPanel.setResizeWeight(0.0);
		authorDescriptionSplitPanel = new AttributeSplitPane(titleAuthorSplitPanel, descriptionPanel);
		authorDescriptionSplitPanel.setResizeWeight(0.9);
		descriptionSubjectsSplitPanel = new AttributeSplitPane(authorDescriptionSplitPanel, subjectsAttributePanel);
		descriptionSubjectsSplitPanel.setResizeWeight(0.9);
		subjectsPublisherPanel = new AttributeSplitPane(descriptionSubjectsSplitPanel, publisherAttributePanel);
		subjectsPublisherPanel.setResizeWeight(0.5);

		embargoAttributePanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
		languageAttributePanel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, Color.GRAY));
		licenseAttributePanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
		uploadAttributePanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));

		mainPanel.add(uploadAttributePanel, BorderLayout.NORTH);
		mainPanel.add(subjectsPublisherPanel, BorderLayout.CENTER);

		embargoLanguageLicensePanel = new JPanel(new BorderLayout());

		embargoLanguageLicensePanel.add(languageAttributePanel, BorderLayout.NORTH);
		embargoLanguageLicensePanel.add(licenseAttributePanel, BorderLayout.CENTER);
		embargoLanguageLicensePanel.add(embargoAttributePanel, BorderLayout.SOUTH);

		mainPanel.add(embargoLanguageLicensePanel, BorderLayout.SOUTH);

		JScrollPane scrollableMainPane = new JScrollPane(mainPanel, ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED, ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		scrollableMainPane.setPreferredSize(new Dimension(400, 400));
		this.setLayout(new GridLayout(1, 1));
		this.add(mainPanel);

	}

	public static JPanel getMainPanel() {
		return PublicationMainPanel.mainPanel;
	}

	/**
	 * Block all textfields except the Authorsfield
	 * 
	 */
	public static void blockForAuthorsField() {
		PublicationButtonLinePanel.getSubmitButton().setEnabled(false);
		removeTitleFieldListener();
		removeDescriptionFieldListener();
		removeLanguageFieldListener();
		removeUploadPanelListener();
		removeSubjectFieldListener();
		removePublisherPanelListener();
		removeLicenseFieldListener();
		removeEmbargoFieldListener();

	}

	private static void removeAuthorPanelListener() {
		for (MouseListener iterable_element : authorsField.getMouseListeners()) {
			if (iterable_element.equals(openAuthorPanelListener)) {
				authorsField.removeMouseListener(openAuthorPanelListener);
				authorsField.setEnabled(false);
			}
		}
	}

	private static void removeLanguageFieldListener() {
		for (MouseListener iterable_element : languageField.getMouseListeners()) {
			if (iterable_element.equals(openLanguagePanelListener)) {
				languageField.removeMouseListener(openLanguagePanelListener);
				languageField.setEnabled(false);
			}
		}
	}

	private static void removeUploadPanelListener() {
		for (MouseListener iterable_element : uploadPathField.getMouseListeners()) {
			if (iterable_element.equals(openUploadPanelListener)) {
				uploadPathField.removeMouseListener(openUploadPanelListener);
				uploadPathField.setEnabled(false);
			}
		}
	}

	private static void removePublisherPanelListener() {
		for (MouseListener iterable_element : publisherField.getMouseListeners()) {
			if (iterable_element.equals(openPublisherPanelListener)) {
				publisherField.removeMouseListener(openPublisherPanelListener);
				publisherField.setEnabled(false);
			}
		}
	}

	private static void removeSubjectFieldListener() {
		for (MouseListener iterable_element : subjectsField.getMouseListeners()) {
			if (iterable_element.equals(openSubjectPanelListener)) {
				subjectsField.removeMouseListener(openSubjectPanelListener);
				subjectsField.setEnabled(false);
			}
		}
	}

	private static void removeEmbargoFieldListener() {
		for (MouseListener iterable_element : embargoField.getMouseListeners()) {
			if (iterable_element.equals(openEmbargoPanelListener)) {
				embargoField.removeMouseListener(openEmbargoPanelListener);
				embargoField.setEnabled(false);
			}
		}
	}

	private static void removeLicenseFieldListener() {
		for (MouseListener iterable_element : licenseField.getMouseListeners()) {
			if (iterable_element.equals(openLicensePanelListener)) {
				licenseField.removeMouseListener(openLicensePanelListener);
				licenseField.setEnabled(false);
			}
		}
	}

	private static void removeDescriptionFieldListener() {
		descriptionField.setEditable(false);
		descriptionField.setFocusable(false);
		descriptionField.setEnabled(false);
	}

	private static void removeTitleFieldListener() {

		titleField.setEditable(false);
		titleField.setFocusable(false);
		titleField.setEnabled(false);
	}

	public static void releaseAllBlockedFields() {
		PublicationButtonLinePanel.getSubmitButton().setEnabled(true);

		titleField.setEditable(true);
		titleField.setFocusable(true);
		titleField.setEnabled(true);

		descriptionField.setEditable(true);
		descriptionField.setFocusable(true);
		descriptionField.setEnabled(true);

		uploadPathField.setFocusable(true);

		boolean hasLanguageListener = false;

		for (MouseListener iterable_element : languageField.getMouseListeners()) {
			if (iterable_element.equals(openLanguagePanelListener)) {
				hasLanguageListener = true;
			}
		}

		if (!hasLanguageListener) {
			languageField.addMouseListener(openLanguagePanelListener);
			languageField.setEnabled(true);
		}

		boolean hasLicenseListener = false;

		for (MouseListener iterable_element : licenseField.getMouseListeners()) {
			if (iterable_element.equals(openLicensePanelListener)) {
				hasLicenseListener = true;
			}
		}

		if (!hasLicenseListener) {
			licenseField.addMouseListener(openLicensePanelListener);
			licenseField.setEnabled(true);
		}

		boolean hasAuthorListener = false;

		for (MouseListener iterable_element : authorsField.getMouseListeners()) {
			if (iterable_element.equals(openAuthorPanelListener)) {
				hasAuthorListener = true;
			}
		}

		if (!hasAuthorListener) {
			authorsField.addMouseListener(openAuthorPanelListener);
			authorsField.setEnabled(true);
		}

		boolean hasUploadPathListener = false;

		for (MouseListener iterable_element : uploadPathField.getMouseListeners()) {
			if (iterable_element.equals(openUploadPanelListener)) {
				hasUploadPathListener = true;
			}
		}

		if (!hasUploadPathListener) {
			uploadPathField.addMouseListener(openUploadPanelListener);
			uploadPathField.setEnabled(true);
		}

		boolean hasSubjectListener = false;

		for (MouseListener iterable_element : subjectsField.getMouseListeners()) {
			if (iterable_element.equals(openSubjectPanelListener)) {
				hasSubjectListener = true;
			}
		}

		if (!hasSubjectListener) {
			subjectsField.addMouseListener(openSubjectPanelListener);
			subjectsField.setEnabled(true);
		}

		boolean hasPublisherListener = false;

		for (MouseListener iterable_element : publisherField.getMouseListeners()) {
			if (iterable_element.equals(openPublisherPanelListener)) {
				hasPublisherListener = true;
			}
		}

		if (!hasPublisherListener) {
			publisherField.addMouseListener(openPublisherPanelListener);
			publisherField.setEnabled(true);
		}

		boolean hasEmbargoListener = false;

		for (MouseListener iterable_element : embargoField.getMouseListeners()) {
			if (iterable_element.equals(openEmbargoPanelListener)) {
				hasPublisherListener = true;
			}
		}

		if (!hasEmbargoListener) {
			embargoField.addMouseListener(openEmbargoPanelListener);
			embargoField.setEnabled(true);
		}

	}

	/**
	 * Block all fields except the LanguageField
	 */
	public static void blockForLanguageField() {
		PublicationButtonLinePanel.getSubmitButton().setEnabled(false);
		removeTitleFieldListener();
		removeDescriptionFieldListener();
		removeAuthorPanelListener();
		removeUploadPanelListener();
		removeSubjectFieldListener();
		removePublisherPanelListener();
		removeEmbargoFieldListener();
		removeLicenseFieldListener();

	}

	/**
	 * Block all fields except the LanguageField
	 */
	public static void blockForLicenseField() {
		PublicationButtonLinePanel.getSubmitButton().setEnabled(false);
		removeTitleFieldListener();
		removeDescriptionFieldListener();
		removeAuthorPanelListener();
		removeUploadPanelListener();
		removeSubjectFieldListener();
		removePublisherPanelListener();
		removeEmbargoFieldListener();
		removeLanguageFieldListener();

	}

	public static void blockForSubjectsField() {
		PublicationButtonLinePanel.getSubmitButton().setEnabled(false);
		removeTitleFieldListener();
		removeDescriptionFieldListener();
		removeLanguageFieldListener();
		removeUploadPanelListener();
		removeAuthorPanelListener();
		removePublisherPanelListener();
		removeEmbargoFieldListener();
		removeLicenseFieldListener();
	}

	public static void blockForPublisherField() {
		PublicationButtonLinePanel.getSubmitButton().setEnabled(false);
		removeTitleFieldListener();
		removeDescriptionFieldListener();
		removeAuthorPanelListener();
		removeUploadPanelListener();
		removeLanguageFieldListener();
		removeSubjectFieldListener();
		removeEmbargoFieldListener();
		removeLicenseFieldListener();
	}

	public static void reset() {
		uploadPathField.cleanTextArea();
		titleField.cleanTextArea();
		descriptionField.cleanTextArea();
	}

	public static void blockForEmbargoField() {
		PublicationButtonLinePanel.getSubmitButton().setEnabled(false);
		removeTitleFieldListener();
		removeDescriptionFieldListener();
		removeAuthorPanelListener();
		removeUploadPanelListener();
		removeLanguageFieldListener();
		removeSubjectFieldListener();
		removePublisherPanelListener();
		removeLicenseFieldListener();
	}

	public static void blockForTitleField() {
		removeDescriptionFieldListener();
		removeAuthorPanelListener();
		removeUploadPanelListener();
		removeLanguageFieldListener();
		removeSubjectFieldListener();
		removePublisherPanelListener();
		removeLicenseFieldListener();
		removeEmbargoFieldListener();
	}
}
