/*
 * Copyright (c) 2016 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Creative Commons Attribution-NoDerivatives 4.0 International (CC BY-ND 4.0)
 * which accompanies this distribution, and is available at http://creativecommons.org/licenses/by-nd/4.0/
 *
 * Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - RMI Client, FileChooser and WebDAV
 */
package de.ipk_gatersleben.bit.bi.edal.publication;

import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.Calendar;

import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;

/**
 * Class to create html pages for the frame header with the help of
 * {@link Velocity}
 * 
 * @author arendd
 */
public class PublicationVeloCityCreater {

	private static final String CODING_UTF_8 = "UTF-8";
	private static final String RESOURCES = "de/ipk_gatersleben/bit/bi/edal/publication/";
	private static final String HEAD_TEMPLATE = RESOURCES + "head.html";
	private static final String PROCESS_TEMPLATE = RESOURCES + "process.html";
	private static final String FINISH_TEMPLATE = RESOURCES + "finish.html";
	private static final String SERVER_ERROR_TEMPLATE = RESOURCES
			+ "server_error.html";

	static {
		Velocity.setProperty("resource.loader", "class");
		Velocity.setProperty("class.resource.loader.class",
				"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
		Velocity.setProperty("runtime.log.logsystem.class",
				"org.apache.velocity.runtime.log.NullLogSystem");
		Velocity.init();
	}

	/**
	 * Generate the HTML output for the welcome page.
	 * 
	 * @return the HTML output in a {@link StringWriter}.
	 * @throws EdalException
	 *             if unable to create output.
	 */
	protected static String generateHtmlForHeadPage() throws EdalException {

		VelocityContext context = new VelocityContext();

		URL edalLogoUrl = PublicationFrame.class.getResource("edal_scaled.png");
		URL ipkLogoUrl = PublicationFrame.class.getResource("ipk_scaled.png");

		context.put("edal", edalLogoUrl);
		context.put("ipk", ipkLogoUrl);
		context.put("bgcolor", PropertyLoader.HEADER_FOOTER_COLOR);
		context.put("authors", PublicationMainPanel.authorPanel.getAuthors());
		context.put("year", Calendar.getInstance().get(Calendar.YEAR));
		context.put("title", PublicationMainPanel.titleField.getText());
		context.put("publisher", PublicationMainPanel.publisherField.getText());

		StringWriter output = new StringWriter();

		Velocity.mergeTemplate(HEAD_TEMPLATE, CODING_UTF_8, context, output);

		try {
			output.flush();
			output.close();
		} catch (final IOException e) {
			throw new EdalException("unable to create html page : "
					+ e.getMessage(), e);
		}
		return output.toString();
	}

	public static String generateHtmnlForProcessDialog() throws EdalException {
		VelocityContext context = new VelocityContext();

		context.put("bgcolor", PropertyLoader.HEADER_FOOTER_COLOR);
		context.put("authors", PublicationMainPanel.authorPanel.getAuthors());
		context.put("year", Calendar.getInstance().get(Calendar.YEAR));
		context.put("title", PublicationMainPanel.titleField.getText());
		context.put("publisher", PublicationMainPanel.publisherField.getText());

		StringWriter output = new StringWriter();

		Velocity.mergeTemplate(PROCESS_TEMPLATE, CODING_UTF_8, context, output);

		try {
			output.flush();
			output.close();
		} catch (final IOException e) {
			throw new EdalException("unable to create html page : "
					+ e.getMessage(), e);
		}
		return output.toString();
	}

	public static String generateFinishUploadPage() throws EdalException {

		VelocityContext context = new VelocityContext();

		context.put("bgcolor", PropertyLoader.HEADER_FOOTER_COLOR);
		context.put("authors", PublicationMainPanel.authorPanel.getAuthors());
		context.put("year", Calendar.getInstance().get(Calendar.YEAR));
		context.put("title", PublicationMainPanel.titleField.getText());
		context.put("publisher", PublicationMainPanel.publisherField.getText());

		StringWriter output = new StringWriter();

		Velocity.mergeTemplate(FINISH_TEMPLATE, CODING_UTF_8, context, output);

		try {
			output.flush();
			output.close();
		} catch (final IOException e) {
			throw new EdalException("unable to create html page : "
					+ e.getMessage(), e);
		}
		return output.toString();
	}

	public static String generateServerErrorDialog(String errorMessage)
			throws EdalException {
		VelocityContext context = new VelocityContext();

		context.put("bgcolor", PropertyLoader.HEADER_FOOTER_COLOR);
		context.put("errorMessage", errorMessage);
		StringWriter output = new StringWriter();

		Velocity.mergeTemplate(SERVER_ERROR_TEMPLATE, CODING_UTF_8, context,
				output);

		try {
			output.flush();
			output.close();
		} catch (final IOException e) {
			throw new EdalException("unable to create html page : "
					+ e.getMessage(), e);
		}
		return output.toString();
	}

}
