/*
 * Copyright (c) 2016 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Creative Commons Attribution-NoDerivatives 4.0 International (CC BY-ND 4.0)
 * which accompanies this distribution, and is available at http://creativecommons.org/licenses/by-nd/4.0/
 *
 * Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - RMI Client, FileChooser and WebDAV
 */
package de.ipk_gatersleben.bit.bi.edal.publication.listener;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.rmi.RemoteException;

import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.publication.AttributeLabel;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationButtonLinePanel;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationFrame;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationMainPanel;
import de.ipk_gatersleben.bit.bi.edal.publication.Utils;
import de.ipk_gatersleben.bit.bi.edal.publication.PropertyLoader;

public class TextAreaValueChangedFocusListener implements FocusListener {

	private AttributeLabel label;
	private JTextComponent textArea;
	private String defaultString;

	private static boolean leavedTitleField = false;

	public TextAreaValueChangedFocusListener(AttributeLabel label, JTextComponent titleArea, String defaultString) {
		this.label = label;
		this.textArea = titleArea;
		this.defaultString = defaultString;
	}

	@Override
	public void focusGained(FocusEvent event) {

		if (leavedTitleField && this.textArea.equals(PublicationMainPanel.descriptionField)) {
			try {
				PublicationFrame.getUserDirectory().getPrimaryDataEntity(PublicationMainPanel.titleField.getText());

				Object[] options = { "Yes", "No" };
				int result = JOptionPane.showOptionDialog(null, "Would you like to update the version? If not please change the title !", "Publication already exist !", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE, null, options, options[0]);
				if (result == JOptionPane.YES_OPTION) {
					PublicationButtonLinePanel.updatePublicationFlag = true;
					PublicationMainPanel.releaseAllBlockedFields();
				}
				if (result == JOptionPane.NO_OPTION) {
					PublicationButtonLinePanel.updatePublicationFlag = false;
					// PublicationMainPanel.releaseAllBlockedFields();
					PublicationMainPanel.titleField.grabFocus();
				}
			} catch (RemoteException | PrimaryDataDirectoryException e) {
			}
		}

		label.setForeground(PropertyLoader.LABEL_COLOR);

		if (Utils.cleanUpString(this.textArea.getText()).equalsIgnoreCase(Utils.cleanUpString(this.defaultString))) {
			this.textArea.setText(new String());
		}

	}

	@Override
	public void focusLost(FocusEvent event) {

		if (Utils.checkIfStringIsEmpty(this.textArea.getText())) {
			this.textArea.setText(this.defaultString);
		}

		if (this.textArea.equals(PublicationMainPanel.titleField)) {
			leavedTitleField = true;
		} else {
			leavedTitleField = false;
		}
		PublicationFrame.updateUI();
	}
}